/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      dmb     In real life:   David M. Baggett
 *
 *      djp     In real life:   David J. Picton
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 *
 * Modification History (this file)
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version
 *                      * A preparseCmd routine has been added to reset
 *                        actor variables at the start of command processing.
 *                        adv.t file is now used, and most customizations
 *                        to standard library objects are now made in
 *                        advmods.t.
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *
 * 23-Jul-04    djp     Version 3.00
 *                      * Change to handle game701+ command.  The preparse 
 *                        routine now makes provision for special words 
 *                        (e.g. game701+) containing nonstandard punctuation 
 *                        symbols.
 *
 */

/*
 * Originally this file only contained stub functions to prevent compiler 
 * warnings, but now some of the routines actually do something.
 */

/*
 * Handle any words containing special characters.
 */
preparse: function(s)
{
    local specialwords := ['game701+'];
    local cleanwords := ['game701P'];
    local i,j,c,l := length(specialwords);
    local specialword;
    
    /* Test whether the command line contains special words */
    c := 0;
    for (i := 1; i <= l; i++) { 
        specialword := specialwords[i];
        if (find(s, specialword)) c++;
    }
    /* If so, transform special words */
    if (c) {
        local i,l,word,words := parseWord(s),outstring := '';
        l :=length(words);
        for (i := 1; i <= l; i++) {
            word := words[i];
            for (j := 1; j <= l; j++) { 
                specialword := specialwords[i];
                if (word = specialword) 
                    word := cleanwords[j];
            }
            if (i = 1) 
                outstring := word;
            else 
                outstring := outstring + ' ' + word;
           
        } 
        return outstring;
    }
    /* if there are no special words, return true to indicate that the
       command string is to be used without modification */
    else 
       return true;
}

/*
 * Stub function to prevent compiler warnings.
 */
parseError: function(n, s)
{
    return nil;
}

// Unfortunately a bug in TADS 2.5.5 prevented parserGetObj(PO_ACTOR) from 
// returning a usable value at this point (it either returned nil, or the 
// last explicitly-specified actor in a previous verb!)  

// kludge: verb methods which are called early on in the command execution
// process, such as doDefault and validDoList, have been hacked to set the
// appropriate global variables.
//
// The bug has been fixed in release 2.5.6 but this has only just been
// released at the time of writing (June 2002).
//
// For now, we use parserGetObj for tads version 2.5.6 onwards, but we use
// a kludge for earlier versions of TADS: methods which are called early on
// in the command execution process such as doDefault and validDoList will
// set the appropriate variables from their 'actor' argument.
//
preparseCmd : function(cmd)
{
    if(global.tadsversion >= '2.5.6') {
        global.verbActor := parserGetObj(PO_ACTOR);
        global.travelActor := global.verbActor;
        global.currentActor := global.verbActor;
    }
    else {
        global.verbActor := nil;
        global.travelActor := nil;
        global.currentActor := nil;
    }
    return true; 
}
/* Copyright (c) 1999, 2000 by Kevin Forchione.  All Rights Reserved. */
/*
 *  TADS ADV.T/STD.T LIBRARY EXTENSION
 *  PARSEWORD.T  (modified)                     
 *  based on version 1.0
 *
 *          This TADS file is intended to assist in the conversion of 
 *      player input strings into a list of words for easier use by 
 *      preparse routines.
 *
 *----------------------------------------------------------------------
 *  REQUIREMENTS
 *
 *      + HTML TADS 2.2.6 or later
 *      + Requires ADV.T and STD.T
 *      + Should be #included after ADV.T and STD.T.
 *
 *----------------------------------------------------------------------
 *  IMPORTANT LIBRARY INTERFACE AND MODIFICATION
 *
 *      None.
 *
 *----------------------------------------------------------------------
 *  COPYRIGHT NOTICE
 *
 *      You may modify and use this file in any way you want, provided that
 *      if you redistribute modified copies of this file in source form, the
 *      copies must include the original copyright notice (including this
 *      paragraph), and must be clearly marked as modified from the original
 *      version.
 *
 *------------------------------------------------------------------------------
 *  REVISION HISTORY
 *
 *              99-03-10 programming begun.
 *              02-07-06 modified by DJP to improve handling of quoted
 *                       strings.
 *
 */

parseWord: function;
parsePunct: function;

/*
 *      parseWord: function
 *
 *      This function takes in a player's input stream
 *      and returns a list consisting of 'words' (the player's
 *      input as separated by spaces, but not separating 
 *      out punctuation.) It then goes on to call parsePunct()
 *      which creates a list consisting of words and punctuation
 *      marks.
 */
parseWord: function( inline )
{
        local istr := lower( inline ), j, len, pos, w, wlst := [], fstr := [ ',' '.' ';' '?' '!' ];
        local first;

        len := length( istr );
        while ( len )
        {
                /* skip a leading space */
                first := substr(istr,1,1);
                if(first = ' '){
                    istr := substr (istr,2,len);
                    len -= 1;
                    continue;
                }
                /* detect a quoted string */
                else if((first = '\'') or (first = '\"')) {
                    istr := substr (istr,2,len);
                    len -= 1;
                    pos := find( istr, first);
                    if (pos = nil)
                        pos := len;
                    w := first + substr( istr,1, pos);
                }
                /* normal word */
                else {
                    pos := find( istr, ' ' );
                    if ( pos = nil )
                        pos := len + 1;
                    w := substr( istr, 1, pos-1 );
                }
                wlst += [ w ];
                istr := substr( istr, pos+1, len );
                len := length( istr );
        }
        for ( j := 1; j <= length( fstr ); j++ )
        {
                wlst := parsePunct( wlst, fstr[ j ] );
        }
        return wlst;
}

/*
 *      parsePunct: function
 *
 *      This function is called by parseWord and separates
 *      out the punctuation marks in the word list. For instance
 *      the statement <Doctor, give me the book.> will result in the
 *      following word list from parseWord: [ 'doctor,' 'give' 'me' 'the' 'book.']
 *      parsePunct will return  the following list:
 *      [ 'doctor'  ','  'give' 'me' 'the' 'book'  '.' ]
 */
parsePunct: function( lst, fstr )
{
        local i, lenstr, lenword, pos, w, wlst := [],first;

        lenstr := length( lst );
        for ( i := 1; i <= lenstr; i++ )
        {
                first := substr(lst[i],1,1);
                pos := find( lst[ i ], fstr );
                if ( (pos = nil) or (first = '\'') or (first = '"'))
                {
                        wlst += lst[ i ];
                        continue;
                }
                lenword := length( lst[ i ] );
                w := substr( lst[ i ], 1, pos-1 );
                wlst += [ w ];
                w := substr( lst[ i ], pos, 1 );
                wlst += [ w ];
                if ( pos < lenword )
                {
                        w := substr( lst[ i ], pos+1, lenword-pos );
                        wlst += [ w ];
                }
        }
        return wlst;
}
