/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * Verbs to help coding and playtesting.
 * Delete in official releases.
 */
getpassword: Soloverb, Debugverb
	verb = 'getpw' 'getpassword'
	soloaction(actor) = {
		TVpassword.isknown := true;
		"OK.";
	}
;
thintVerb: Soloverb
	verb = 'thint'
	sdesc = "give a hint for (testing only)"
	soloaction(actor) = { dispensehint(nil); abort; }
;

// Silly stuff

magicwordVerb: Soloverb
	sdesc = "xyzzy"
	verb = 'xyzzy' 'plugh' 'plover' 'y2' 'wazzum' 'snorgumfert'
	soloaction(actor) = {
		if (global.ingame)
			"Nothing happens.";
		else
			"A hollow voice inside your head says,
			\"Wrong genre.\"";
	}
;
zotVerb: Soloverb
	sdesc = "zot"
	verb = 'zot'
	soloaction(actor) = { "You feel the movement of the planets."; }
;

/*
 * Real verbs
 */
creditsVerb: Soloverb
	verb = 'credits' 'acknowledgements'
	sdesc = "list credits for"
	soloaction(actor) = { creditsobject.sdesc; abort; }
; 
helpVerb: Soloverb
	verb = 'help'
	sdesc = "help"
	soloaction(actor) = {
		if (global.ingame)
			"I'm afraid you're simply beyond help.";
		else
			"For instructions, type \"instructions\".  For a hint,
			type \"hint\".";

		abort;
	}
;
encryptVerb: Soloverb
	verb = 'encrypt'
	sdesc = "encrypt hints"
	soloaction(actor) = {
		local	yesno;

		if (global.encrypt)
			"Hints are already encrypted.";
		else {
			I(); "Are you sure you want to turn on hint
			encryption?  The encryption is a letter
			substitution cipher, where each letter is
			replaced by the letter 13 places after it in
			the alphabet. E.g.: "; P();

			I(); "A -> N, B -> O, ... M -> Z, N -> A,
			O -> B)"; P();

			I(); "You can only turn off hint ecryption by
			undoing this command, restarting, or restoring
			a game you save before you enabled hint
			encryption."; P();

			I(); "Permanently enable hint ecryption? (YES or NO) > ";	

			yesno := yorn();
			"\b";
			if (yesno = 1) {
				global.encrypt := true;
				"Hints will be encrypted from now on.";
			}
			else {
				"OK, never mind.";
			}
		}
	}
;
hintVerb: Soloverb
	verb = 'hint' 'h'
	sdesc = "give a hint for"
	soloaction(actor) = { 
		if (global.ingame)
			"Hint:\ Try Unnkulia 1/2:\ The Salesman Triumphant -- it's much easier!";
		else
			dispensehint(true);

		abort;
	}
;
lipsVerb: Soloverb	// the answer to the riddle!
	verb = 'lips'
	sdesc = "lips"
	soloaction(actor) = {
#ifndef DEMO
		if (Me.isin(AtTheCenter)) {
			answerriddle.transition;
		}
		else {
#endif
			"Eh?";
#ifndef	DEMO
		}
#endif
	}
;

waveVerb: Verb
	sdesc = "shake"
	verb = 'wave' 'shake'
	doAction = 'Wave'
	ioAction(atPrep) = 'Waveat'
	dorequires = [[&cantouch]]
	iorequires = [[&cansee]]
;
// for watching the EV
watchVerb: Verb
	sdesc = "watch"
	verb = 'watch'
	doAction = 'Watch'
	requires = [[&cansee]]
;
rubVerb: Verb
	sdesc = "rub"
	verb = 'rub' 'caress' 'fondle' 'pat' 'pet' 'hug' 'cuddle' 'squeeze'
	doAction = 'Rub'
	requires = [[&cantouch]]
;

prayVerb: Soloverb
	sdesc = "pray"
	verb = 'pray' 'worship'
	doAction = 'Pray'
	soloaction(actor) = { 
		"An ethereal voice intones, \"You have reached The
		Great Duhdha's automated prayer line.  If you wish
		to ask for a minor miracle, press one.  If you would
		like to check your karmic balance, press two.  If
		you would like to register a complaint or file a 
		bug report, press three.  Press four to hang up.  If
		you are calling from a rotary phone, please contact
		your local branch office to upgrade to a touch tone.\"";
	}
;

swimVerb: Soloverb
	verb = 'swim'
	sdesc = "swim"
	soloaction(actor) = "You don't know how."
;
swingVerb: Verb
	verb = 'swing' 'swing in' 'swing on'
	sdesc = "swing in"
	doAction = 'Swingin'
	requires = [[&cantouch]]
;
countVerb: Verb
	verb = 'count'
	sdesc = "count"
	doAction = 'Count'
	requires = [[&cansee]]
;

pourVerb: Verb
	sdesc = "pour"
	verb = 'pour' 'dump' 'dribble'
	prepDefault = onPrep
	ioAction(onPrep) = 'Pouron'
	dorequires = [[&cantake]]
	iorequires = [[&cantouch]]
;

cookVerb: Verb
	sdesc = "cook"
	verb = 'cook' 'fry' 'heat' 'bake'
	doAction = 'Cook'
	requires = [[&cantouch]]
;

playVerb: Verb
	sdesc = "play with"
	verb = 'play' 'play with' 'solve' 'do' 'unsolve'
	doAction = 'Play'
	requires = [[&cantouch]]
;

eraseVerb: Verb
	sdesc = "erase"
	verb = 'erase'
	doAction = 'Erase'
	requires = [[&cantouch]]
;

useVerb: Verb
	sdesc = "use"
	verb = 'use' 'utilize' 'employ'
	doAction = 'Use'
	requires = [[&cantouch]]
;

makeVerb: Verb
	sdesc = "make"
	verb = 'make' 'create' 'build' 'produce' 'catalyze'
	doAction = 'Make'
	requires = [[&cantouch]]
;

lightVerb: Verb
	sedsc = "light"
	verb = 'light'
	doAction = 'Light'
	requires = [[&cantouch]]
;
rollVerb: Verb
	sdesc = "roll"
	verb = 'roll' 'fold' 'wrap'
	doAction = 'Roll'
	requires = [[&cantouch]]
;

unrollVerb: Verb
	sdesc = "unroll"
	verb = 'unroll' 'unfold' 'unwrap'
	doAction = 'Unroll'
	requires = [[&cantouch]]
;

pickVerb: Verb
	sdesc = "pick"
	verb = 'pick'
	doAction = 'Pick'
	requires = [[&cantouch]]
;
wakeVerb: Verb
	sdesc = "wake"
	verb = 'wake' 'awaken'
	doAction = 'Wake'
	requires = [[&cantouch]]
;
diagnoseVerb: Soloverb
	verb = 'diagnose' 'health'
	sdesc = "diagnose"
	soloaction(actor) = {
		if (Me.stimulant)
			"You feel totally wired!";
		else
			"You feel healthy.";
	}
;
resetVerb: Verb
	verb = 'reset' 'calibrate' 'callibrate' 'initialize'
		'clear' 'start over'
	sdesc = "reset"
	doAction = 'Reset'
	requires = [[&cantouch]]
;

bendVerb: Verb
	sdesc = "bend"
	verb = 'bend' 
	doAction = 'Bend'
	requires = [[&cantouch]]
;

guessVerb: Verb
	sdesc = "guess"
	verb = 'guess' 'think up' 'think of' 'make up' 'imagine'
	doAction = 'Guess'
	requires = [[]]
;

whatisverb: Verb
	sdesc = "identify"
	verb = 'identify' 'whatis' 'whois'
	doAction = 'Whatis'
	requires = [[&isatopic]]
;
cutverb: Verb
	sdesc = "cut"
	verb = 'cut' 'cut open' 'slice'

	doAction = 'Cut'	// This is mainly to block TADS from filling
				// in default "with" objects, e.g., 
				// (with the coat hanger)
	ioAction(withPrep) = 'Cutwith'
	dorequires = [[&cantouch]]
	iorequires = [[&cantake]]
;
buyverb: Verb
	sdesc = "buy"
	verb = 'buy' 'payfor' 'purchase' 'pay for'
	doAction = 'Buy'
	requires = [[]]
;
payverb: Verb
	sdesc = "pay"
	verb = 'pay'
	doAction = 'Pay'
	requires = [[&cantouch, &canputinto]]
;
knotverb: Verb
	sdesc = "knot"
	verb = 'knot'
	doAction = 'Knot'
	requires = [[&cantouch]]
;
unknotverb: Verb
	sdesc = "unknot"
 	verb = 'unknot'
	doAction = 'Unknot'
	requires = [[&cantouch]]
;
blowverb: Verb
	sdesc = "blow"
	verb = 'blow' 'toot'
	doAction = 'Blow'
	requires = [[&cantake]]
;
plantverb: Verb
	sdesc = "plant"
	verb = 'plant' 'bury'
	doAction = 'Plant'
	ioAction(inPrep) = 'Plantin'
	dorequires = [[&cantake]]
	iorequires = [[&cantouch]]
;

// Added stuff for game-within-a-game
replace quitVerb: Systemverb, Soloverb
	verb = 'quit'
	soloaction(actor) = {
		local yesno;

		score_and_rank();
		"\bDo you really want to quit? (YES or NO) > ";
		yesno := yorn();
		"\b";
		if (yesno = 1) {
			if (global.ingame) {
#ifndef	DEMO
				uu3transition.backtolegend;
#endif
			}
			else {
				terminate();	// allow user good-bye message
				quit();
			}
		}
		else
			"Okay. ";

		abort;
	}
;

// Added stuff for game-within-a-game
replace restartVerb: Systemverb, Soloverb
	verb = 'restart'
	soloaction(actor) = {
		local yesno;
		if (global.ingame) {
			"*** external interrupt: [Z-code emulator no longer supports the restart operation.]"; 
			abort;
		}
		else {
			while (true) {
				"Are you sure you want to start over? (YES or NO) > ";
				yesno := yorn();
				if (yesno = 1) {
					"\n";
					init_statusline();
					score_statusline();
					restart(initrestart, global.restarting);
					abort;
				}
				else if (yesno = 0) {
					"\nOkay.\n";
					abort;
				}
			}
		}
	}
;


//
// Words for Squirt
//
// (See compoundWords in adv.t too.)
//
stompverb: Soloverb
	sdesc = "stomp"
	verb =	'stomp' 'stompfeet' 'stamp' 'stampfeet'
	soloaction(actor) = {
		"You stomp the ground. ";

		if (squirt.inroom) {
			squirt.stomp;
		}
		else {
			"Other than making your feet hurt, this accomplishes
			nothing.";
		}
	}
;
clapverb: Soloverb
	sdesc = "clap"
	verb = 'clap' 'claphands'
	soloaction(actor) = {
		"You clap your hands. ";

		if (squirt.inroom) {
			squirt.clap;
		}
		else {
			"The author of this game accepts the compliment
			with pleasure.";
		}
	}
;
snapverb: Soloverb
	sdesc = "snap"
	verb = 'snap' 
	soloaction(actor) = {
		"You snap your fingers. ";

		if (squirt.inroom) {
			squirt.snap;
		}
		else {
			"This makes you feel way cool.";
		}
	}
;
whistleverb: Soloverb
	sdesc = "whistle"
	verb = 'whistle'
	soloaction(actor) = {
		"You whistle loudly. ";

		if (squirt.inroom) {
			squirt.whistle;
		}
		else {
			"You get the odd feeling that if this were
			another place and another time, you might
			have just warded off a fearsome grue.";
		}
	}
;
singVerb: Soloverb
	sdesc = "sing"
	verb = 'sing'
	doAction = 'Sing'
	soloaction(actor) = {
		if (squirt.inroom) {
			squirt.whistle;
		}
		else {
			"You're pretty good.  Nice to know you've got 
			a second career in case grad school doesn't 
			work out.  But then again, the Unnkulians may 
			have already taken over the universe by the 
			time you finish grad school.";
		}
	}
;

replace yellVerb: Verb;	// with nothing

yellverb: Soloverb
	sdesc = "yell"
	verb = 'yell' 'shout' 'scream' 'bellow'
	soloaction(actor) = {
		"You shout at the top of your lungs. ";

		if (squirt.inroom) {
			squirt.yell;
		}
		else {
			"Other than making you feel a bit less stressed,
			this has no effect.";
		}
	}
;
rideVerb: Verb
	sdesc = "ride"
	verb = 'ride' 'pedal' 'peddle'
	doAction = 'Ride'
	requires = [[&cantouch]]
;
sprayVerb: Verb
	sdesc = "spray"
	verb = 'spray'
	ioAction(withPrep) = 'Spraywith'
	ioAction(atPrep) = 'Sprayat'
	ioAction(onPrep) = 'Sprayat'

	dorequires = [
		      		[&cantake]
		withPrep	[&cansee]
	]
	iorequires = [
				[&cansee]
		withPrep	[&cantake]
	]
;
launchVerb: Soloverb
	sdesc = "launch"
	verb = 'launch' 'lift off' 'liftoff'
	soloaction(actor) = {
		if (INPODbutton.isin(Me.location))
			INPODbutton.doPush(Me);
		else
			"That doesn't seem too likely here.";
	}
;

catchVerb: Verb
	sdesc = "catch"
	verb = 'catch' 'snare'
	doAction = 'Take'
	requires = [&cantake]
;
feedVerb: Verb
	sdesc = "feed"
	verb = 'feed'
	prepDefault = toPrep
	ioAction(toPrep) = 'Giveto'
	dorequires = [[&cantake]]
	iorequires = [[&cantouch, &canputinto]]
;

modify breakVerb	// add crack for egg
	verb =	'crack'
;

modify typeVerb
	dorequires = [[&canusealphanumorpassword]] // allow "type password on keyboard"
;

modify sleepVerb
	soloaction(actor) = { "This is no time for napping!"; }
;
