VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form frmLocalidades 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Localidades"
   ClientHeight    =   5655
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7965
   Icon            =   "Localidades.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   5655
   ScaleWidth      =   7965
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cmdAceptar 
      Cancel          =   -1  'True
      Caption         =   "&Aceptar"
      Height          =   375
      Left            =   6480
      TabIndex        =   16
      Top             =   5160
      Width           =   1335
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   5655
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7965
      _ExtentX        =   14049
      _ExtentY        =   9975
      _Version        =   393216
      Style           =   1
      Tabs            =   2
      TabHeight       =   520
      TabCaption(0)   =   "Localidades"
      TabPicture(0)   =   "Localidades.frx":0E42
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "Label4"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "Label3"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "Label2"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).Control(3)=   "Label1"
      Tab(0).Control(3).Enabled=   0   'False
      Tab(0).Control(4)=   "lstLocalidades"
      Tab(0).Control(4).Enabled=   0   'False
      Tab(0).Control(5)=   "cmdModificar"
      Tab(0).Control(5).Enabled=   0   'False
      Tab(0).Control(6)=   "txtSonido"
      Tab(0).Control(6).Enabled=   0   'False
      Tab(0).Control(7)=   "txtGrafico"
      Tab(0).Control(7).Enabled=   0   'False
      Tab(0).Control(8)=   "Frame1"
      Tab(0).Control(8).Enabled=   0   'False
      Tab(0).Control(9)=   "cmdBorrar"
      Tab(0).Control(9).Enabled=   0   'False
      Tab(0).Control(10)=   "cmdNueva"
      Tab(0).Control(10).Enabled=   0   'False
      Tab(0).Control(11)=   "txtLarga"
      Tab(0).Control(11).Enabled=   0   'False
      Tab(0).Control(12)=   "txtCorta"
      Tab(0).Control(12).Enabled=   0   'False
      Tab(0).ControlCount=   13
      TabCaption(1)   =   "Propiedades Usuario"
      TabPicture(1)   =   "Localidades.frx":0E5E
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "cmdNuevaUsr"
      Tab(1).Control(1)=   "cmbBorrarUsr"
      Tab(1).Control(2)=   "Frame2"
      Tab(1).ControlCount=   3
      Begin VB.CommandButton cmdNuevaUsr 
         Caption         =   "&Aadir"
         Height          =   375
         Left            =   -74880
         TabIndex        =   22
         Top             =   5160
         Width           =   1335
      End
      Begin VB.CommandButton cmbBorrarUsr 
         Caption         =   "&Borrar"
         Height          =   375
         Left            =   -73440
         TabIndex        =   21
         Top             =   5160
         Width           =   1335
      End
      Begin VB.Frame Frame2 
         Height          =   4695
         Left            =   -74880
         TabIndex        =   17
         Top             =   360
         Width           =   7695
         Begin VB.CommandButton cmdArray 
            Caption         =   "..."
            Height          =   285
            Index           =   0
            Left            =   7080
            TabIndex        =   23
            Top             =   240
            Visible         =   0   'False
            Width           =   285
         End
         Begin VB.TextBox txtPropUsr 
            ForeColor       =   &H80000012&
            Height          =   285
            Index           =   0
            Left            =   2040
            TabIndex        =   19
            Top             =   240
            Visible         =   0   'False
            Width           =   4935
         End
         Begin VB.VScrollBar VScroll1 
            Enabled         =   0   'False
            Height          =   4575
            Left            =   7440
            Max             =   0
            TabIndex        =   18
            Top             =   120
            Width           =   255
         End
         Begin VB.Label lblPropUsr 
            Caption         =   "Propiedad"
            BeginProperty Font 
               Name            =   "Arial"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   20
            Top             =   240
            Visible         =   0   'False
            Width           =   1935
         End
      End
      Begin VB.TextBox txtCorta 
         Height          =   285
         Left            =   4440
         TabIndex        =   10
         Top             =   600
         Width           =   3375
      End
      Begin VB.TextBox txtLarga 
         Height          =   2055
         Left            =   4440
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   9
         Top             =   1200
         Width           =   3375
      End
      Begin VB.CommandButton cmdNueva 
         Caption         =   "&Aadir"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   5160
         Width           =   1335
      End
      Begin VB.CommandButton cmdBorrar 
         Caption         =   "&Borrar"
         Height          =   375
         Left            =   1560
         TabIndex        =   7
         Top             =   5160
         Width           =   1335
      End
      Begin VB.Frame Frame1 
         Caption         =   "Propiedades"
         Height          =   855
         Left            =   4440
         TabIndex        =   4
         Top             =   3360
         Width           =   3375
         Begin VB.CheckBox chkIluminada 
            Caption         =   "Iluminada"
            Height          =   255
            Left            =   240
            TabIndex        =   6
            Top             =   240
            Width           =   975
         End
         Begin VB.CheckBox chkExterior 
            Caption         =   "Exterior"
            Height          =   255
            Left            =   240
            TabIndex        =   5
            Top             =   480
            Width           =   855
         End
      End
      Begin VB.TextBox txtGrafico 
         Height          =   285
         Left            =   5280
         TabIndex        =   3
         Top             =   4320
         Width           =   2535
      End
      Begin VB.TextBox txtSonido 
         Height          =   285
         Left            =   5280
         TabIndex        =   2
         Top             =   4680
         Width           =   2535
      End
      Begin VB.CommandButton cmdModificar 
         Caption         =   "&Modificar"
         Height          =   375
         Left            =   3000
         TabIndex        =   1
         Top             =   5160
         Width           =   1335
      End
      Begin MSComctlLib.ListView lstLocalidades 
         Height          =   4695
         Left            =   120
         TabIndex        =   11
         Top             =   360
         Width           =   4215
         _ExtentX        =   7435
         _ExtentY        =   8281
         View            =   3
         LabelEdit       =   1
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   2
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "N"
            Object.Width           =   882
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Nombre"
            Object.Width           =   4763
         EndProperty
      End
      Begin VB.Label Label1 
         Caption         =   "Descripcin corta"
         Height          =   255
         Left            =   4440
         TabIndex        =   15
         Top             =   360
         Width           =   3015
      End
      Begin VB.Label Label2 
         Caption         =   "Descripcin larga"
         Height          =   255
         Left            =   4440
         TabIndex        =   14
         Top             =   960
         Width           =   3015
      End
      Begin VB.Label Label3 
         Caption         =   "Grfico"
         Height          =   255
         Left            =   4440
         TabIndex        =   13
         Top             =   4320
         Width           =   735
      End
      Begin VB.Label Label4 
         Caption         =   "Sonido"
         Height          =   255
         Left            =   4440
         TabIndex        =   12
         Top             =   4680
         Width           =   735
      End
   End
End
Attribute VB_Name = "frmLocalidades"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const MAX_PROP_USR = 17 ' n mx. de propiedades de usuario
                                ' que caben en pantalla

Private Sub cmbBorrarUsr_Click()
    Dim i As Long, j As Long, k As Long, l As Long, n As Long
    Dim iOpc As Integer
    Dim sProp As String
    
    If Not HayPropUsrLoc Then
        Exit Sub
    End If
    
    For i = 0 To lblPropUsr.Count - 1
        If lblPropUsr(i).Tag = "X" Then
            sProp = lblPropUsr(i).Caption
            iOpc = MsgBox("Se va a borrar la propiedad " & _
              sProp & ". Quieres continuar?", _
              vbYesNo + vbQuestion, "Borrar propiedad de usuario")
            If iOpc = vbYes Then
                For j = NUM_LOCPROP_PREDEF To UBound(LocProp)
                    If UCase(LocProp(j).Nombre) = sProp Then
                        If j < UBound(LocProp) Then
                            For k = j To UBound(LocProp) - 1
                                LocProp(k) = LocProp(k + 1)
                                ' actualizamos la matriz de valores
                                ' de propiedades de la localidad
                                If bHayLoc Then
                                    For l = 0 To UBound(Localidades)
                                        Localidades(l).PropUsr(k - NUM_LOCPROP_PREDEF) = Localidades(l).PropUsr(k - NUM_LOCPROP_PREDEF + 1)
                                    Next
                                End If
                            Next
                        End If
                        If UBound(LocProp) < 1 Then
                            ReDim LocProp(0)
                        Else
                            ReDim Preserve LocProp(UBound(LocProp) - 1)
                        End If
                        ' actualizamos la matriz de valores
                        ' de propiedades de la localidad
                        If bHayLoc Then
                            n = UBound(LocProp) - NUM_LOCPROP_PREDEF
                            If n < 0 Then
                                For l = 0 To UBound(Localidades)
                                    ReDim Localidades(l).PropUsr(0)
                                Next
                            Else
                                For l = 0 To UBound(Localidades)
                                    ReDim Preserve Localidades(l).PropUsr(n)
                                Next
                            End If
                        End If
                        Exit For
                    End If
                Next

                BarraScrollUsr
                PropiedadesUsuario
                ActualizarDatosLoc
            End If
            Exit Sub
        End If
    Next
    
End Sub

Private Sub cmdArray_Click(index As Integer)
    
    Load frmEdArray
    frmEdArray.Inicializa txtPropUsr(index).Text
    frmEdArray.Show vbModal
    txtPropUsr(index).Text = frmEdArray.sArray
    BloqueaArray index
    Unload frmEdArray

End Sub

Private Sub cmdBorrar_Click()
    Dim c As String, sNombre As String
    Dim i As Long, lLocalidad As Long
    Dim iOpc As Integer
    
    If lstLocalidades.ListItems.Count < 1 Then
        Exit Sub
    End If

    ' coge nmero de la localidad que est seleccionada
    c = lstLocalidades.SelectedItem.key
    
    ' la clave tiene el formato Lnnn, donde 'nnn' es el nmero de la localidad
    lLocalidad = CLng(Mid(c, 2))
    If lLocalidad < 0 Then
        Exit Sub
    End If
    
    iOpc = MsgBox("Se va a borrar la localidad seleccionada. Quieres continuar?", _
      vbYesNo + vbQuestion, "AVISO")
    If iOpc <> vbYes Then
        Exit Sub
    End If
    
    sNombre = Localidades(lLocalidad).Nombre
    
    BorrarLocalidad lLocalidad
    ActualizarListaLoc
    ActualizarDatosLoc

    ' revisamos los objetos que tengan como contenedor esta localidad y los actualizamos
    For i = 0 To UBound(Objetos)
        If Objetos(i).TipoContenedor = OBJ_CONTLOC And Objetos(i).Contenedor = sNombre Then
            Objetos(i).Contenedor = ""
        End If
    Next
    
    ' revisamos los PSIs que estn en esta localidad y los actualizamos
    For i = 0 To UBound(PSIs)
        If PSIs(i).Localidad = sNombre Then
            PSIs(i).Localidad = ""
        End If
    Next

    ActualizarFormularios

End Sub

Private Sub cmdAceptar_Click()

    Unload Me

End Sub

Private Sub cmdModificar_Click()
    Dim c As String, sNombre As String, sAntNombre As String
    Dim i As Long, j As Long, lLocalidad As Long
    Dim iOpc As Integer
    
    If lstLocalidades.ListItems.Count < 1 Then
        Exit Sub
    End If

    ' coge nmero de la localidad que est seleccionada
    c = lstLocalidades.SelectedItem.key
    
    ' la clave tiene el formato Lnnn, donde 'nnn' es el nmero de la localidad
    lLocalidad = CLng(Mid(c, 2))
    If lLocalidad < 0 Then
        Exit Sub
    End If
    
    iOpc = MsgBox("Se va a modificar el nombre de la localidad seleccionada." & _
      " Este cambio puede afectar al cdigo del programa." & _
      " Quieres continuar?", _
      vbYesNo + vbQuestion, "AVISO")
    If iOpc <> vbYes Then
        Exit Sub
    End If
    
    ' recogemos el nuevo nombre
    sAntNombre = Localidades(lLocalidad).Nombre
    c = InputBox("Localidad", "Modificar nombre de localidad", sAntNombre)
    c = Trim(c)
    If InStr(c, " ") >= 1 Then
        MsgBox "El nombre de la localidad no es vlido.", vbOKOnly + vbExclamation, "Modificar nombre de localidad"
        Exit Sub
    End If
    If c = "" Then
        Exit Sub
    End If
    sNombre = QuitaAcentos(Trim(UCase(c)))
    
    ' comprobamos que el nombre no exista
    For i = 0 To UBound(Localidades)
        If i <> lLocalidad Then
            If Localidades(i).Nombre = sNombre Then
                MsgBox "El nombre est repetido.", vbOKOnly + vbExclamation, "Modificar nombre de localidad"
                Exit Sub
            End If
        End If
    Next
    
    ' cambiamos el nombre
    Localidades(lLocalidad).Nombre = sNombre
    lstLocalidades.SelectedItem.SubItems(1) = sNombre

    ' revisamos las conexiones a esta localidad y las actualizamos
    For i = 0 To UBound(Localidades)
        If Localidades(i).Conexiones(0).Localidad <> "" And Localidades(i).Conexiones(0).Verbo <> "" Then
            For j = 0 To UBound(Localidades(i).Conexiones)
                If Localidades(i).Conexiones(j).Localidad = sAntNombre Then
                    Localidades(i).Conexiones(j).Localidad = sNombre
                End If
            Next
        End If
    Next
    
    ' revisamos los objetos que tengan como contenedor esta localidad y los actualizamos
    For i = 0 To UBound(Objetos)
        If Objetos(i).TipoContenedor = OBJ_CONTLOC And Objetos(i).Contenedor = sAntNombre Then
            Objetos(i).Contenedor = sNombre
        End If
    Next
    
    ' revisamos los PSIs que estn en esta localidad y los actualizamos
    For i = 0 To UBound(PSIs)
        If PSIs(i).Localidad = sAntNombre Then
            PSIs(i).Localidad = sNombre
        End If
    Next

    ActualizarFormularios

End Sub

Private Sub cmdNueva_Click()
    Dim Lst As ListItem
    Dim c As String
    Dim n As Long

    GuardarDatosLoc

    c = InputBox("Localidad", "Aadir localidad")
    c = Trim(c)
    
    If InStr(c, " ") >= 1 Then
        MsgBox "El nombre de la localidad no es vlido.", vbOKOnly + vbExclamation, "Aadir localidad"
        Exit Sub
    End If

    If c = "" Then
        Exit Sub
    End If

    If Not NuevaLocalidad(c, "", "", False, False) Then
        Exit Sub
    End If
    n = lstLocalidades.ListItems.Count
    Set Lst = lstLocalidades.ListItems.Add(, "L" & CStr(n), CStr(n))
    Lst.SubItems(1) = Localidades(n).Nombre
    
    ' selecciona la localidad que acabamos de aadir
    Set lstLocalidades.SelectedItem = Lst
    ActualizarDatosLoc
    Lst.EnsureVisible

    ActualizarFormularios
    txtCorta.SetFocus

End Sub

Private Sub cmdNuevaUsr_Click()
    Dim c As String
    Dim i As Integer
    
    c = InputBox("Propiedad", "Aadir propiedad de usuario")
    c = Trim(c)

    If c = "" Then
        Exit Sub
    End If

    ' comprobamos si el nombre es vlido
    c = UCase(c)
    If Not CompruebaNombreProcVar(c) Then
        MsgBox "El nombre de la propiedad no es vlido.", vbOKOnly + vbCritical, "Aadir propiedad de usuario"
        Exit Sub
    End If
    
    ' comprobamos si ya existe
    For i = 0 To UBound(LocProp)
        If UCase(LocProp(i).Nombre) = c Or _
          c = LOC_PROP_NOMBRE Or _
          c = LOC_PROP_DESCCORTA Or _
          c = LOC_PROP_DESCLARGA Or _
          c = LOC_PROP_ILUMINADA Or _
          c = LOC_PROP_EXTERIOR Or _
          c = LOC_PROP_GRAFICO Or _
          c = LOC_PROP_SONIDO Or _
          c = LOC_PROP_USUARIO Then
            MsgBox "El nombre de la propiedad est repetido.", vbOKOnly + vbCritical, "Aadir propiedad de usuario"
            Exit Sub
        End If
    Next

    ' aadimos
    If LocProp(0).Nombre = "" Then
        i = 0
    Else
        i = UBound(LocProp) + 1
    End If
    
    ReDim Preserve LocProp(i)
    LocProp(i).Tipo = TIPO_PROP_VAR
    LocProp(i).Nombre = c
    i = lblPropUsr.Count
    If i = 1 And Not lblPropUsr(0).Visible Then
        lblPropUsr(0).Visible = True
        txtPropUsr(0).Visible = True
        cmdArray(0).Visible = True
        i = 0
    Else
        Load lblPropUsr(i)
        Load txtPropUsr(i)
        Load cmdArray(i)
        lblPropUsr(i).Top = lblPropUsr(i - 1).Top + lblPropUsr(i - 1).Height
        txtPropUsr(i).Top = lblPropUsr(i).Top
        cmdArray(i).Top = lblPropUsr(i).Top
        lblPropUsr(i).Visible = True
        txtPropUsr(i).Visible = True
        cmdArray(i).Visible = True
    End If
    
    lblPropUsr(i).Caption = c
    txtPropUsr(i).Text = ""
    BloqueaArray i
    
    ' actualizamos la matriz de valores de propiedades
    ' de usuario en las localidades
    If bHayLoc Then
        For i = 0 To UBound(Localidades)
            ReDim Preserve Localidades(i).PropUsr(UBound(LocProp) - NUM_LOCPROP_PREDEF)
        Next
    End If

    BarraScrollUsr
    VScroll1.value = VScroll1.Max
    
End Sub

Private Sub Form_Deactivate()

    GuardarDatosLoc

End Sub

Private Sub Form_Load()
    
    SSTab1.Tab = 0

    BarraScrollUsr
    PropiedadesUsuario
    ActualizarListaLoc

End Sub

Private Sub Form_LostFocus()

    GuardarDatosLoc

End Sub

Private Sub Form_Unload(Cancel As Integer)

    GuardarDatosLoc

End Sub

Private Sub lstLocalidades_ColumnClick(ByVal ColumnHeader As MSComctlLib.ColumnHeader)

    If ColumnHeader.index = 2 Then
        If lstLocalidades.Sorted Then
            lstLocalidades.Sorted = False
            ActualizarListaLoc
        Else
            lstLocalidades.SortKey = 1
            lstLocalidades.Sorted = True
        End If
    End If
    
End Sub

Public Sub ActualizarListaLoc()
    Dim Lst As ListItem
    Dim i As Long
    
    lstLocalidades.ListItems.Clear
    
    If Not bHayLoc Then
        Exit Sub
    End If

    For i = 0 To UBound(Localidades)
        Set Lst = lstLocalidades.ListItems.Add(, "L" & CStr(i), CStr(i))
        Lst.SubItems(1) = Localidades(i).Nombre
    Next
    
    ActualizarDatosLoc
    
End Sub

Private Sub ActualizarDatosLoc()
    Dim sLocalidad As String
    Dim i As Long

    txtCorta.Text = ""
    txtLarga.Text = ""
    chkIluminada.value = False
    chkExterior.value = False

    If Not bHayLoc Then
        Exit Sub
    End If

    ' coge la localidad que est seleccionada
    If lstLocalidades.ListItems.Count < 1 Then
        Exit Sub
    End If
    sLocalidad = lstLocalidades.SelectedItem.SubItems(1)
    
    For i = 0 To UBound(Localidades)
        If Localidades(i).Nombre = sLocalidad Then
            txtCorta.Text = Localidades(i).DescCorta
            txtLarga.Text = Localidades(i).DescLarga
            chkIluminada.value = IIf(Localidades(i).Iluminada, vbChecked, vbUnchecked)
            chkExterior.value = IIf(Localidades(i).Exterior, vbChecked, vbUnchecked)
            
            ' propiedades de usuario
            ActualizarPropUsr Localidades(i)

            txtGrafico.Text = Localidades(i).Grafico
            txtSonido.Text = Localidades(i).Sonido
            Exit Sub
        End If
    Next
    
End Sub

' guardamos los datos de la localidad que estamos editando
Public Sub GuardarDatosLoc()
    Dim sLocalidad As String
    Dim i As Long, j As Long, lNumProp As Long, lMaxProp As Long

    If Not bHayLoc Then
        Exit Sub
    End If
    
    ' coge la localidad que est seleccionada
    If lstLocalidades.ListItems.Count < 1 Then
        Exit Sub
    End If
    sLocalidad = lstLocalidades.SelectedItem.SubItems(1)
    
    For i = 0 To UBound(Localidades)
        If Localidades(i).Nombre = sLocalidad Then
            Localidades(i).DescCorta = txtCorta.Text
            Localidades(i).DescLarga = txtLarga.Text
            Localidades(i).Iluminada = IIf(chkIluminada.value = vbChecked, True, False)
            Localidades(i).Exterior = IIf(chkExterior.value = vbChecked, True, False)
            
            ' propiedades de usuario
            If HayPropUsrLoc Then
                lNumProp = UBound(LocProp) - NUM_LOCPROP_PREDEF
                If lNumProp < 0 Or LocProp(0).Nombre = "" Then
                    ReDim Localidades(i).PropUsr(0)
                Else
                    If lNumProp > UBound(Localidades(i).PropUsr) Then
                        ReDim Preserve Localidades(i).PropUsr(lNumProp)
                    End If
                    
                    lMaxProp = VScroll1.value + MAX_PROP_USR - 1
                    If lMaxProp > lNumProp Then
                        lMaxProp = lNumProp
                    End If
                    For j = VScroll1.value To lMaxProp
                        Localidades(i).PropUsr(j) = txtPropUsr(j - VScroll1.value).Text
                    Next
                End If
            End If
            
            Localidades(i).Grafico = txtGrafico.Text
            Localidades(i).Sonido = txtSonido.Text
            Exit Sub
        End If
    Next

End Sub

Private Sub lstLocalidades_ItemClick(ByVal Item As MSComctlLib.ListItem)

    ActualizarDatosLoc

End Sub

Private Sub lstLocalidades_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

    GuardarDatosLoc

End Sub

' actualiza los datos de los formularios que dependen de este
Private Sub ActualizarFormularios()

    If EstaCargado(frmObjetos) Then
        frmObjetos.ActualizarLoc
        frmObjetos.ActualizarDatosObj
    End If
    
    If EstaCargado(frmPSIs) Then
        frmPSIs.ActualizarLoc
        frmPSIs.ActualizarDatosPSI
    End If

    If EstaCargado(frmConex) Then
        frmConex.DibujaMapa
    End If
    
    If EstaCargado(frmLstLoc) Then
        frmLstLoc.ActualizarListaLoc
    End If

End Sub

Private Sub txtPropUsr_GotFocus(index As Integer)
    Dim i As Long
    
    For i = 0 To lblPropUsr.Count - 1
        lblPropUsr(i).ForeColor = &H80000012
        lblPropUsr(i).Tag = ""
    Next
    
    lblPropUsr(index).ForeColor = &HC0&
    lblPropUsr(index).Tag = "X"

End Sub

' actualiza los valores de las propiedades de usuario
Private Sub ActualizarPropUsr(Loc As Localidad)
    Dim i As Long, lMaxProp As Long, lNumProp As Long
    
    If Not HayPropUsrLoc Then
        Exit Sub
    End If
    
    ' ltima propiedad a visualizar
    lMaxProp = VScroll1.value + MAX_PROP_USR - 1
    lNumProp = UBound(LocProp) - NUM_LOCPROP_PREDEF
    If lNumProp < 0 Then
        lNumProp = 0
    End If
    If lMaxProp > lNumProp Then
        lMaxProp = lNumProp
    End If
    
    For i = VScroll1.value To lMaxProp
        txtPropUsr(i - VScroll1.value).Text = Loc.PropUsr(i)
        BloqueaArray i - VScroll1.value
    Next
    
End Sub

' crea las 'casillas' para las propiedades de usuario
Private Sub PropiedadesUsuario()
    Dim i As Long, lMaxProp As Long, lNumProp As Long
    Dim n As Integer

    ' primero borramos los controles que se hubiesen creado
    If lblPropUsr.Count > 1 Then
        For i = lblPropUsr.Count - 1 To 1 Step -1
            Unload lblPropUsr(i)
            Unload txtPropUsr(i)
            Unload cmdArray(i)
        Next
    End If
    lblPropUsr(0).Visible = False
    txtPropUsr(0).Visible = False
    cmdArray(0).Visible = False
    
    ' si hay definidas propiedades de usuario
    If HayPropUsrLoc Then
        ' ltima propiedad a visualizar
        lMaxProp = VScroll1.value + MAX_PROP_USR - 1
        lNumProp = UBound(LocProp) - NUM_LOCPROP_PREDEF
        If lNumProp < 0 Then
            lNumProp = 0
        End If
        If lMaxProp > lNumProp Then
            lMaxProp = lNumProp
        End If

        For i = VScroll1.value To lMaxProp
            If lblPropUsr(0).Visible Then
                n = lblPropUsr.Count
                Load lblPropUsr(n)
                Load txtPropUsr(n)
                Load cmdArray(n)
                lblPropUsr(n).Top = lblPropUsr(n - 1).Top + lblPropUsr(n - 1).Height
                txtPropUsr(n).Top = lblPropUsr(n).Top
                cmdArray(n).Top = lblPropUsr(n).Top
                lblPropUsr(n).Caption = LocProp(i + NUM_LOCPROP_PREDEF).Nombre
                txtPropUsr(n).Text = ""
                BloqueaArray n
                lblPropUsr(n).Visible = True
                txtPropUsr(n).Visible = True
                cmdArray(n).Visible = True
                
                lblPropUsr(n).ForeColor = &H80000012
                lblPropUsr(n).Tag = ""
            Else
                lblPropUsr(0).Caption = LocProp(i + NUM_LOCPROP_PREDEF).Nombre
                txtPropUsr(0).Text = ""
                BloqueaArray 0
                lblPropUsr(0).Visible = True
                txtPropUsr(0).Visible = True
                cmdArray(0).Visible = True
                
                lblPropUsr(0).ForeColor = &H80000012
                lblPropUsr(0).Tag = ""
            End If
        Next
    End If
    
End Sub

' ajusta la barra de scroll para las propiedades de usuario
Private Sub BarraScrollUsr()
    Dim lNumProp As Long

    lNumProp = UBound(LocProp) - NUM_LOCPROP_PREDEF + 1
    If lNumProp < 0 Then
        lNumProp = 0
    End If
    
    If lNumProp > MAX_PROP_USR Then
        VScroll1.Min = 0
        VScroll1.Max = lNumProp - MAX_PROP_USR
        VScroll1.Enabled = True
        If VScroll1.value > VScroll1.Max Then
            VScroll1.value = VScroll1.Max
        End If
    Else
        VScroll1.Min = 0
        VScroll1.Max = 0
        VScroll1.value = 0
        VScroll1.Enabled = False
    End If
    
End Sub

Private Sub txtPropUsr_Validate(index As Integer, Cancel As Boolean)

    GuardarDatosLoc
    Cancel = False

End Sub

Private Sub VScroll1_Change()

    PropiedadesUsuario
    ActualizarDatosLoc

End Sub

' bloquea un campo de texto si contiene un array, lo desbloquea si no
Private Sub BloqueaArray(i As Integer)

    If EsArray(txtPropUsr(i).Text) Then
        txtPropUsr(i).Locked = True
        txtPropUsr(i).BackColor = &HC0FFFF
        txtPropUsr(i).ForeColor = &HC0FFFF
    Else
        txtPropUsr(i).Locked = False
        txtPropUsr(i).BackColor = &H80000005
        txtPropUsr(i).ForeColor = &H80000012
    End If

End Sub


