/* UnQuill: Disassemble games written with the "Quill" adventure game system
    Copyright (C) 1996,1999  John Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <oz.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
/*
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
*/

#define TINY 1
#define CPM 1
#define YES_GETCH

/* Hi-Tech C for CP/M doesn't support const */
#define const

#define PATH_MAX 20

typedef unsigned char uchr;     /* for brevity */
typedef unsigned short ushrt;   /* -- ditto -- */

#define NIL  100
#define LOC  101
#define MSG  102
#define OBJ  103
#define SWAP 104
#define PLC  105

uchr zmem(ushrt);
ushrt zword(ushrt);
void clrscr(void);
void oneitem(ushrt,uchr);
void opch32(char);
void expch (uchr, ushrt *);
void expdict (uchr, ushrt *);

char present(uchr);
uchr doproc(ushrt,uchr,uchr);
void listat(uchr);
void initgame(ushrt);
void playgame(ushrt);
void sysmess(uchr);
uchr ffeq(uchr,uchr);
uchr condtrue(ushrt);
uchr autobj(uchr);
uchr runact(ushrt,uchr);
uchr cplscmp(ushrt, char *);
uchr matchword(char **);
void dec32(ushrt);
char yesno(void);
void savegame(void);
void loadgame(void);

/* Supported architectures */
#define ARCH_SPECTRUM 0
#define ARCH_CPC      1
#define ARCH_C64      2


#ifdef MAINMODULE
                          /* In the TINY version, we read in from the file 
                             as required, with two 1k caches of the common 
                             bits: */
ushrt b1base,b2base;      /* Spectrum addresses of buffers */
uchr b1full=0,b2full=0;   /* Do buffers contain data? */

char arch = ARCH_SPECTRUM;/* Architecture */
char oopt='T';            /* Output option */
char xpos=0;              /* Used in msg display */
char ypos=0;              /* Used in msg display */
char dbver=0;             /* Which format of database? 0 = early Spectrum
                           *                          10 = later Spectrum/CPC */
ushrt ofarg=0;            /* Output to file or stdout? */
ushrt vocab,dict;	  /* Spectrum address of vocabulary & dictionary */
char nobeep=0;            /* Peace and quiet? */
char running=0;           /* Actually playing the game? */
ushrt loctab;
ushrt objtab;             /* Tables of locations, objects, messages */
ushrt msgtab;
ushrt sysbase;		  /* Base of system messages */
ushrt conntab;            /* Connections table */
ushrt postab;             /* Object start positions table */
ushrt objmap;		  /* Word-to-object map */
ushrt proctab, resptab;	  /* Process and Response tables */
/* char *inname;  */            /* Input filename */ /*Modified by L.C*/

uchr fileid=0xFF;	  /* Save file identity byte */
uchr ramsave[0x101];	  /* RAM save buffer */
uchr flags[37];           /* The Quill flags, 0-36. */
#define TURNLO flags[31]  /* (31-36 are special */
#define TURNHI flags[32]  /* Meanings of the special flags */
#define VERB flags[33]
#define NOUN flags[34]
#define CURLOC flags[35]  /* flags[36] == 0 */
uchr objpos[255];         /* Positions of objects */
uchr maxcar;		  /* Max no. of portable objects */
uchr maxcar1;		  /* As maxcar - later games can change it on the fly */
#define NUMCAR flags[1]   /* Number of objects currently carried */
uchr nobj;                /* No. of objects */
uchr nsys;		  /* No. of system messages */
uchr alsosee=1;		  /* Message "You can also see" */
uchr estop;		  /* Emergency stop flag */

unsigned int old_addr = 0;

unsigned int infile;

uchr found = 0, skipc = 0, skipo = 0, skipm = 0, skipn = 0,skipl = 0,
             skipv = 0, skips = 0, skipu = 0, skipg = 0, nloc, nmsg;
uchr comment_out = 0;

ushrt mem_base;          /* Minimum address loaded from snapshot     */
ushrt mem_size;          /* Size of memory loaded from snapshot      */
unsigned short mem_offset;        /* Load address of snapshot in physical RAM */
char snapid[20];

#else /* def MAINMODULE */

extern uchr buf1[0x400];
extern uchr buf2[0x400];
extern ushrt b1base,b2base;      
extern uchr b1full,b2full; 

extern char oopt, xpos, ypos, dbver,nobeep,running,*inname;
extern ushrt ofarg,vocab,dict,loctab,objtab,msgtab,sysbase,conntab,objmap;
extern ushrt postab, proctab, resptab;
extern uchr comment_out;

extern uchr fileid,ramsave[0x101],flags[37];
#define TURNLO flags[31] 
#define TURNHI flags[32] 
#define VERB flags[33]
#define NOUN flags[34]
#define CURLOC flags[35]
#define NUMCAR flags[1]
extern uchr objpos[255],maxcar,maxcar1,nobj,nsys,alsosee,estop;		  /* Emergency stop flag */
extern int infile;

extern uchr skipc, skipo, skipm, skipn, skipl, skipv, skips, skipu, skipg;
extern uchr found, nloc, nmsg;
extern char arch;

extern ushrt mem_base;          /* Minimum address loaded from snapshot     */
extern ushrt mem_size;          /* Size of memory loaded from snapshot      */
extern short mem_offset;        /* Load address of snapshot in physical RAM */
extern char snapid[20];

#endif /* def MAINMODULE */

#ifndef SEEK_SET        /* Hi-tech C doesn't include SEEK_???. */
#define SEEK_SET 0
#endif

#if (CPM || __PACIFIC__) /* CP/M & Pacific don't support argv[0] */
#define AV0 "UNQUILL"
#else
#define AV0 argv[0]
#endif

#define AV10 argv[1][0]
#define AV11 argv[1][1]
