/* -------------------------- */
/*   Spectrum Screen module   */
/* -------------------------- */

/*
 * Copyright (C) 1998 Jose Luis Cebrian Pague
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#define MAX(a,b) ((a)<(b)?(b):(a))
#define MIN(a,b) ((a)>(b)?(b):(a))

struct SS_MODULE
{
    void (*ss_init)     () ;

    void (*ss_clear)    () ;
    void (*ss_move)	(int x, int y) ;
    void (*ss_plot)	(int mode) ;
    void (*ss_rmove)	(int incx, int incy) ;
    void (*ss_line)	(int incx, int incy, int mode) ;
    void (*ss_fill)	(int incx, int incy, char pattern[8]) ;
    void (*ss_attbl)	(int col, int row, int w, int h) ;
    void (*ss_putch)	(int col, int row, int set, unsigned char c, int mode) ;
    void (*ss_scroll)   (int row) ;
    void (*ss_render)	() ;
} ;

extern struct SS_MODULE * _ss_curr_mod ;

/* Available graphic modules */
extern struct SS_MODULE ss_lowres_mod ;
extern struct SS_MODULE ss_modern_mod ;

#define SS_MODE_DRAW 0
#define SS_MODE_OVER 1
#define SS_MODE_INVERSE 2
#define SS_MODE_NOTHING 2

extern void ss_clear    () ;
extern void ss_move	(int x, int y) ;
extern void ss_plot	(int mode) ;
extern void ss_rmove    (int incx, int incy) ;
extern void ss_line	(int incx, int incy, int mode) ;
extern void ss_fill	(int incx, int incy, char pattern[8]) ;
extern void ss_attbl    (int col, int row, int w, int h) ;
extern void ss_putch    (int col, int row, int set, unsigned char c, int m) ;
extern void ss_scroll   (int row) ;
extern void ss_render   () ;

extern void ss_init (struct SS_MODULE *mod) ;

extern int ss_attrib, ss_attribmask ;

/* Call the color functions with color=8 for "transparent color" setting.
 * Bright and flash can only be 0 or 1. Ink and paper color can be:
 *
 * 0	Black		00 00 00
 * 1	Blue		00 00 C0
 * 2	Red		C0 00 00
 * 3	Magenta		C0 00 C0
 * 4	Green		00 C0 00
 * 5	Yellow		00 C0 C0
 * 6			C0 00 C0
 * 7	White		C0 C0 C0
 */

extern void ss_ink      (int ink) ;
extern void ss_paper    (int paper) ;
extern void ss_bright   (int bright) ;
extern void ss_flash    (int flash) ;

#define SS_NUMUDG 19
#define SS_NUMSYSUDG 15
#define SS_NUMSHADES 16
#define SS_NUMCHAR 96
#define SS_NUMSET  8

extern unsigned char ss_udg [SS_NUMUDG] [8] ;
extern unsigned char ss_sys_udg [SS_NUMSYSUDG] [8] ;
extern unsigned char ss_shades [SS_NUMSHADES] [8] ;
extern unsigned char ss_charset [SS_NUMSET] [SS_NUMCHAR] [8] ;

/* The render can display the screen data in 24 bytes RGB mode or in
 * paletted 256 color mode. When ss_render() is called, it fills the
 * ss_render_* structs based in ss_render_mode value. Also, if the
 * ss_render_buffer is not allocated ot not big enough, it will
 * (re)allocate it via malloc() or realloc() */

#define SS_RENDER_24BPP 1
#define SS_RENDER_8BPP  2

extern int ss_render_mode ;

struct SS_RGB
{
    unsigned char r ;
    unsigned char g ;
    unsigned char b ;
} ;

extern struct SS_RGB ss_render_palette [256] ;

extern unsigned char * ss_render_buffer ;
extern unsigned int ss_render_buffer_size ;
extern unsigned int ss_render_buffer_width ;
extern unsigned int ss_render_buffer_height ;

/* Functions that save the rendered buffer into a graphics file */

extern int ss_render_save_ppm (char *filename) ;
extern int ss_render_save_png (char *filename) ;

#ifdef LIBGIF
extern int ss_render_save_gif (char *filename) ;
#endif

