#include <stdio.h>
#include <string.h>

#include "ss.h"

#define COORD_FACT 1

#define GR_COMMAND_MASK 0x07

#define GR_MOVE         0x00
#define GR_LINE         0X01
#define GR_FILL         0x02
#define GR_GOSUB        0x03
#define GR_PRINT        0x04
#define GR_PAPER        0x05
#define GR_INK          0x06
#define GR_END          0x07

static unsigned char zxmem[65536] ;
#define zxchar(c) (zxmem[c])
#define zxword(c) (*(unsigned short *)(zxmem+(c)))

static int nofill = 0 ;
static int notext = 0 ;
static int nocolor = 0 ;
static int nogosub = 0 ;
static int dump = 0 ;

static char *mode (char m)
{
    if ((m & 0x18) == 0x18) return "IO" ;
    if (m & 0x10) return "I" ;
    if (m & 0x08) return "O" ;
    return "" ;
}

void scr_graphics (int nro)
{
   int clr_base = zxword (0xFFF3), base = zxword (0xFFF1), x, y ;
   unsigned char *saveptr ;
   char fillmask[8] ;
   static char solidmask[8] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF } ;

   static int limit = 0 ;
   int i ;

   if (dump)
       printf ("\n---- LOC %d ----\n\n", nro) ;

   if (!limit)
     {
       if (!nocolor)
         {
           ss_ink( zxchar(clr_base+nro) & 0x07) ;
           ss_paper( (zxchar(clr_base+nro) & 0x38) >> 3) ;
         }
       ss_clear() ;
       ss_move (0, 16) ;
     }

   base = zxword(base+nro*2) ;

   if (limit == 16)
     {
       return ;
     }

   for (;;)
   {

      switch (zxchar(base) & GR_COMMAND_MASK)
      {
         case GR_MOVE:
            ss_move  (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * ((int)zxchar(base+1)  ),
                      COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * ((int)zxchar(base+2)+16  )) ;
	    if ((zxchar(base) & 0x18) == 0x18)
	      {
		if (dump) 
		{
		    printf ("        MOVE    %3d %3d\n", 
			zxchar(base+1), zxchar(base+2)) ;
		}

		ss_plot (SS_MODE_NOTHING) ;
	      }
	    else
	      {
		if (dump) 
		{
		    printf ("        PLOT    %3d %3d %s\n", 
			zxchar(base+1), zxchar(base+2), mode(zxchar(base))) ;
		}

		ss_plot ( zxchar(base) & 0x10 ? SS_MODE_INVERSE :
			  zxchar(base) & 0x08 ? SS_MODE_OVER    :
			  SS_MODE_DRAW) ;
	      }
            base += 3 ;
            break ;

         case GR_LINE:
            if ((zxchar(base) & 0x18) == 0x18)
	      {
		if (dump) 
		{
		    printf ("        RMOVE   %3d %3d\n", 
			zxchar(base+1), zxchar(base+2)) ;
		}

                ss_rmove  (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * (int)zxchar(base+1),
                           COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * (int)zxchar(base+2)) ;
	      }
	    else
	      {
		if (dump) 
		{
		    printf ("        LINE    %3d %3d %s\n", 
			zxchar(base+1), zxchar(base+2), mode(zxchar(base))) ;
		}

                ss_line  (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * (int)zxchar(base+1),
                          COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * (int)zxchar(base+2),
			  zxchar(base) & 0x10 ? SS_MODE_INVERSE :
			  zxchar(base) & 0x08 ? SS_MODE_OVER    :
			  SS_MODE_DRAW) ;
	      }
            base += 3 ;
            break ;

         case GR_FILL:
            if (zxchar(base) & 0x10)
            {
	       if (dump) printf ("        ATTBL   %3d %3d %3d %3d %3d\n", zxchar(base), zxchar(base+1), zxchar(base+2), zxchar(base+3), zxchar(base+4)) ;
	       ss_attbl    (zxchar(base+3), 23-zxchar(base+1)-zxchar(base+4),
			     zxchar(base+2)+1, zxchar(base+1)+1) ;
               base += 5 ;
            }
            else if (zxchar(base) & 0x20)
            {
	       if (dump) printf ("        SHADE   %3d %3d %3d %3d\n", zxchar(base), zxchar(base+1), zxchar(base+2), zxchar(base+3)) ;
	       for (i = 0 ; i < 8 ; i++)
		 {
		   fillmask[i] = ( ss_shades[zxchar(base+3) & 0x0F][i]
				 | ss_shades[zxchar(base+3) / 16][i] ) ;
		   if (zxchar(base) & 0x10) fillmask[i] ^= 0xFF ;
		 }

	       if (!nofill)
               ss_fill  (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * zxchar(base+1),
                         COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * zxchar(base+2),
			 fillmask) ;
	       else
	       {
		       ss_rmove (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * zxchar(base+1),
				 COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * zxchar(base+2));
		       ss_plot (SS_MODE_DRAW) ;
		       ss_rmove  (-COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * zxchar(base+1),
				 -COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * zxchar(base+2));
	       }
               base += 4 ;
            }
            else
            {
	       if (dump) printf ("        FILL    %3d %3d %3d\n", zxchar(base), zxchar(base+1), zxchar(base+2)) ;
	       if (!nofill)
               ss_fill   (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * zxchar(base+1),
                          COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * zxchar(base+2),
			  solidmask) ;
	       else
	       {
		       ss_rmove (COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * zxchar(base+1),
				 COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * zxchar(base+2));
		       ss_plot (SS_MODE_DRAW) ;
		       ss_rmove (-COORD_FACT * (zxchar(base) & 0x40 ? -1:1) * zxchar(base+1),
				 -COORD_FACT * (zxchar(base) & 0x80 ? -1:1) * zxchar(base+2));
	       }
               base += 3 ;
            }
            break ;

         case GR_GOSUB:
	    if (dump) printf ("        GOSUB   %3d\n", zxchar(base+1)) ;
	    if (!nogosub)
	      {
	        limit++ ;
                scr_graphics (zxchar(base+1)) ;
	        limit-- ;
	      }
            base += 2 ;
            break ;

	 case GR_PRINT:
	    if (dump) printf ("        TEXT    AT (%3d %3d) SET %3d CHAR %3d\n", 
		    zxchar(base+2), zxchar(base+3), zxchar(base)>>5, zxchar(base+1)) ;
	    if (!notext)
	    ss_putch (zxchar(base+2), zxchar(base+3),
		      zxchar(base)>>5, zxchar(base+1), 
		      zxchar(base) & 0x10 ? SS_MODE_INVERSE :
		      zxchar(base) & 0x08 ? SS_MODE_OVER    :
		      SS_MODE_DRAW) ;
	    base += 4 ;
	    break ;

         case GR_PAPER:
	    if (dump) printf ("        PAPER   %3d\n", zxchar(base)) ;
	    if (nocolor)
	      {
		base++ ;
		break ;
	      }
	    if (zxchar(base) & 0x80)
	      {
                ss_bright ((zxchar(base)&0x78) >> 3) ;
	      }
	    else
	      {
                ss_paper ((zxchar(base)&0x78) >> 3) ;
	      }
            base ++ ;
            break ;

         case GR_INK:
	    if (dump) printf ("        INK     %3d\n", zxchar(base)) ;
	    if (nocolor)
	      {
		base++ ;
		break ;
	      }
	    if (zxchar(base) & 0x80)
	      {
                ss_flash ((zxchar(base)&0x78) >> 3) ;
	      }
	    else
	      {
                ss_ink ((zxchar(base)&0x78) >> 3) ;
	      }
            base ++ ;
            break ;

         case GR_END:
	    if (dump) printf ("        END\n") ;
	    if (dump)
	       printf ("\n---- END LOC %d ----\n\n", nro) ;

            return ;

         default:
            printf ("Unknown command %d\n", zxchar(base) & GR_COMMAND_MASK) ;
            return ;
      }
   }
}
int load_snapshot (char *fname1)
{
    char fname[256], header[128] ;
    unsigned short headsize ;
    FILE *file ;
    long fsize ;

    strcpy (fname, fname1) ;
    file = fopen (fname, "rb") ;
    if (!file)
    {
        strcat (fname, ".sna") ;
        file = fopen (fname, "rb") ;
        if (!file)
        {
            strcpy (fname, fname1) ;
            strcat (fname, ".sp") ;
            file = fopen (fname, "rb") ;
            if (!file)
            {
                strcpy (fname, fname1) ;
                strcat (fname, ".z80") ;
                file = fopen (fname, "rb") ;
                if (!file)
                {
                    puts ("Error reading file") ;
                    return 0 ;
                }
            }
        }
    }

    fseek (file, 0, SEEK_END) ;
    fsize = ftell(file) ;
    fseek (file, 0, SEEK_SET) ;

    switch (fsize)
    {
        case 49179:
            fseek (file, 0x1C1B, SEEK_SET) ;
            fread (zxmem+0x5C00, 0xA400, 1, file) ;
            break ;
        case 49190:
            fseek (file, 0x1C26, SEEK_SET) ;
            fread (zxmem+0x5C00, 0xA400, 1, file) ;
            break ;
        case 65535:
            fread (zxmem, 65535, 1, file) ;
            break ;
        default:
#ifdef Z80
            fread (header, 30, 1, file) ;
            if (header[12] == 255) header[12] = 1 ;
            if (header[6] == 0 && header[7] == 0)
            {
                fread ((void *)&headsize, 2, 1, file) ;
                if (headsize < 128)
                {
                    fread (header, headsize, 1, file) ;
                    if (header[4] == 0)
                    {
                        if (load_z80 (file)) ;
                        break ;
                    }
                    puts ("This is not a 48K Z80 file") ;
                    fclose (file) ;
                    return 0 ;
                }
            }
            else
                if (load_oldz80(file))
                    break ;
#endif
            puts ("This is not a SNA file") ;
            fclose (file) ;
            return 0 ;
    }
    fclose (file) ;

    if (zxchar(0x9437) != 0x10)
    {
        puts ("This is not a PAW datafile") ;
        return 0 ;
    }
    return 1 ;
}

void usage()
{
    puts ("pawgr version 0.9, Copyright (C) 1999 Jose Luis Cebrian Pague\n"
	  "pawgr comes with ABSOLUTELY NO WARRANTY; see README for details\n\n"
	  "Use: pawgr [options] filename locno\n\n"
	  "Loads a spectrum snapshot (SNA format) of a PAW adventure,\n"
	  "then renders a locality graphic into a graphic file.\n\n"
	  "Debug options:\n"
	  "   -nofill        Disable region fill/shading commands\n"
	  "   -notext        Disable text command\n"
	  "   -nocolor       Disable INK/PAPER commands\n"
	  "   -nogosub       Disable GOSUB command\n"
	  "   -dump          Dump commands to stdout\n"
	  "Output file options:\n"
	  "   -ppm           Use Portable pixmap format (.ppm)\n"
#ifdef LIBGIF
	  "   -gif           Use Compuserve Graphics Interchange format (.gif)\n"
#endif
	  "   -png           Use PNG is Not Gif format (.png) (default)\n"
	  "   -o filename    Output file. No extension required\n") ;
}

int main (int argc, char *argv[])
{
    int i, key, nro = 0, n_charsets ;
    int x, y ;
    int filename_ok = 0 ;
    int locno_ok = 0 ;
    char format[16] = ".png" ;
    
    char outputfile[128] = "" ;

    if (argc < 2)
    {
	usage() ;
        return 0 ; 
    }
    
    if (argc > 1)
    {
	    for (i = 1 ; i < argc ; i++)
	    {
		    if (!strcmp (argv[i], "-nofill"))
			    nofill = 1 ;
		    else if (!strcmp (argv[i], "-notext"))
			    notext = 1 ;
		    else if (!strcmp (argv[i], "-nocolor"))
			    nocolor = 1 ;
		    else if (!strcmp (argv[i], "-nogosub"))
			    nogosub = 1 ;
		    else if (!strcmp (argv[i], "-dump"))
			    dump = 1 ;
		    else if (!strcmp (argv[i], "-png"))
			    strcpy (format, ".png") ;
#ifdef LIBGIF
		    else if (!strcmp (argv[i], "-gif"))
			    strcpy (format, ".gif") ;
#endif
		    else if (!strcmp (argv[i], "-ppm"))
			    strcpy (format, ".ppm") ;
		    else if (!strcmp (argv[i], "-o") && i < argc-1)
		    {
			i++ ;
			strcpy (outputfile, argv[i]) ;
		    }
		    else if (!filename_ok)
		    {
			filename_ok = 1 ;
			if (!load_snapshot(argv[i]))
			    return 1 ;
			if (!outputfile[0])
			{
			    strcpy (outputfile, argv[i]) ;
			    if (strchr(outputfile, '.'))
				*strchr(outputfile,'.') = 0 ;
			}

		    }
		    else if (!locno_ok)
		    {
			nro = atoi(argv[i]) ;
			locno_ok = 1 ;
		    }
	    }
    }

    if (!filename_ok)
    {
	fprintf (stderr, "Error: no snapshot to load\n") ;
	usage() ;
	return 1 ;
    }
    if (!locno_ok)
    {
	fprintf (stderr, "Error: no locality number to render\n") ;
	usage() ;
	return 1 ;
    }

    n_charsets = zxchar (0x9449) ;
    for (i = 1 ; i <= n_charsets ; i++)
	memcpy (ss_charset[i], zxmem+zxword(0x944A)+768*(i-1), SS_NUMCHAR*8) ; 
    memcpy (ss_udg, zxmem+0x9300, sizeof(ss_udg)) ;
    memcpy (ss_shades, zxmem+0x9300+19*8, sizeof(ss_shades)) ;

    ss_init (&ss_lowres_mod) ;
    
    scr_graphics (nro) ;

    if (!strchr (outputfile, '.'))
        strcat (outputfile, format) ;

    ss_render () ;
    if (strcmp (format, ".png") == 0)
	ss_render_save_png (outputfile) ;
#ifdef LIBGIF
    if (strcmp (format, ".gif") == 0)
	ss_render_save_gif (outputfile) ;
#endif
    if (strcmp (format, ".ppm") == 0)
	ss_render_save_ppm (outputfile) ;
}
