# hdgr.exe makefile
# for djgpp

TARGET=hdgr.exe

# PORT_NAME is for file-naming:
PORT_NAME=alleg

COMPILE=gcc
LINK=gcc

SOURCE_DIR=c:/hugo/source
NONPORTABLE_DIR=c:/hugo/source/djgpp

OBJ_EXT=o
NONPORTABLE_OBJS=he$(PORT_NAME).$(OBJ_EXT) hd$(PORT_NAME).$(OBJ_EXT) \
hejpeg.$(OBJ_EXT) hesound.$(OBJ_EXT)

DEFINES=-DALLEGRO -DDEBUGGER
WFLAGS=-Wall
OFLAGS=-O3
#DFLAGS=-g3
CFLAGS=-I$(SOURCE_DIR) -Ic:/gcc/jpeg -Ic:/gcc/mikmod/source \
$(WFLAGS) $(OFLAGS) $(DFLAGS) $(DEFINES) -c
LFLAGS=-L/gcc/allegro/lib/djgpp -Lc:/gcc/jpeg -Lc:/gcc/mikmod/source
LIBS=-lalleg -ljpeg -lmik

OBJS=he.$(OBJ_EXT) heexpr.$(OBJ_EXT) hemisc.$(OBJ_EXT) \
heobject.$(OBJ_EXT) heparse.$(OBJ_EXT) heres.$(OBJ_EXT) \
herun.$(OBJ_EXT) heset.$(OBJ_EXT) \
hd.$(OBJ_EXT) hddecode.$(OBJ_EXT) hdmisc.$(OBJ_EXT) \
hdtools.$(OBJ_EXT) hdupdate.$(OBJ_EXT) hdval.$(OBJ_EXT) \
hdwindow.$(OBJ_EXT) stringfn.$(OBJ_EXT) \
$(NONPORTABLE_OBJS)

$(TARGET): $(OBJS)
	$(LINK) $(LFLAGS) -o $(TARGET) $(OBJS) $(LIBS)


# Portable sources:

he.$(OBJ_EXT): $(SOURCE_DIR)/he.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/he.c

heexpr.$(OBJ_EXT): $(SOURCE_DIR)/heexpr.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heexpr.c

hemisc.$(OBJ_EXT): $(SOURCE_DIR)/hemisc.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hemisc.c

heobject.$(OBJ_EXT): $(SOURCE_DIR)/heobject.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heobject.c

heparse.$(OBJ_EXT): $(SOURCE_DIR)/heparse.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heparse.c

heres.$(OBJ_EXT): $(SOURCE_DIR)/heres.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heres.c

herun.$(OBJ_EXT): $(SOURCE_DIR)/herun.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/herun.c

heset.$(OBJ_EXT): $(SOURCE_DIR)/heset.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heset.c

hd.$(OBJ_EXT): $(SOURCE_DIR)/hd.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hd.c

hddecode.$(OBJ_EXT): $(SOURCE_DIR)/hddecode.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hddecode.c

hdmisc.$(OBJ_EXT): $(SOURCE_DIR)/hdmisc.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hdmisc.c

hdtools.$(OBJ_EXT): $(SOURCE_DIR)/hdtools.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hdtools.c

hdupdate.$(OBJ_EXT): $(SOURCE_DIR)/hdupdate.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hdupdate.c

hdval.$(OBJ_EXT): $(SOURCE_DIR)/hdval.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hdval.c

hdwindow.$(OBJ_EXT): $(SOURCE_DIR)/hdwindow.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hdwindow.c

stringfn.$(OBJ_EXT): $(SOURCE_DIR)/stringfn.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/stringfn.c


# Non-portable sources:

he$(PORT_NAME).$(OBJ_EXT): $(NONPORTABLE_DIR)/he$(PORT_NAME).c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/he$(PORT_NAME).c

hc$(PORT_NAME).$(OBJ_EXT): $(NONPORTABLE_DIR)/hc$(PORT_NAME).c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hc$(PORT_NAME).c

hejpeg.$(OBJ_EXT): $(NONPORTABLE_DIR)/hejpeg.c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hejpeg.c

hesound.$(OBJ_EXT): $(NONPORTABLE_DIR)/hesound.c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hesound.c
