/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <dos.h>

#include "screen.h"

void lglk_screen_gotoxy(unsigned x, unsigned y) {
	union REGS r;
	           
	r.x.ax = 0x0200;	                      
	r.x.bx = 0;	                      
	r.x.dx = (y << 8) | x;

	int86(0x10, &r, &r);
}

void lglk_screen_put(unsigned x, unsigned y, unsigned char attr, char c) {
	int far *screen;
	
	screen = MK_FP(0xB800, 2 * ((y * 80) + x));
	*screen = (c & 0xff) | (attr << 8);
}

void lglk_screen_clear() {
	int far *screen;
	int at;

	screen = MK_FP(0xB800, 0);
	for(at = 0; at < 80 * 25; at++) {
		screen[at] = ' ' | 0x1700;
	}
}

void lglk_screen_close() {
	int far *from, far *to;
	int at;
	
	to = MK_FP(0xB800, 0);
	from = MK_FP(0xB800, 80 * 2);
	
	for(at = 0; at < 80 * 24; at++) {
		to[at] = from[at];
	}   
	
	for(at = 80 * 24; at < 80 * 25; at++) {
		to[at] = ' ' | 0x0700;
	}
	lglk_screen_gotoxy(0, 24);
}
       	