/* bwindow.h - definitions for the buffered window routines */

/* buffered window structure */
typedef struct {
    WindowPtr bw_window;
    int bw_x,bw_y;		/* cursor position */
    int bw_xinc;		/* x increment */
    int bw_yinc;		/* y increment */
    int bw_ascent;		/* font ascent */
    Rect bw_bounds;		/* bounds rectangle */
    int bw_h,bw_w;		/* height and width */
    char *bw_topline;		/* top line */
    char *bw_curline;		/* current line */
    char *bw_buffer;		/* text buffer */
    char *bw_linebuf;		/* line buffer */
    int *bw_linepos;		/* character positions */
    int bw_linelen;		/* line length */
    void (*bw_input)(char *buf);/* input handler */
} BWindow,*BWindowPtr;

/* prototypes */
void BWInit(BWindowPtr bw,WindowPtr w,Rect *bounds);
void BWRedraw(BWindowPtr bw);
void BWClear(BWindowPtr bw);
void BWPutC(BWindowPtr bw,int ch);
void BWKey(BWindowPtr bw,int ch);
void BWPosition(BWindowPtr bw,int x,int y);
void BWEraseChar(BWindowPtr bw);
void BWNextLine(BWindowPtr bw,char **pline);
void BWScrollUp(BWindowPtr bw);
void BWIdle(void);
void BWCursorOn(BWindowPtr bw);
void BWCursorOff(void);