/* Execute.h - interpreter definitions */
/*
	Copyright (c) 1993, by David Michael Betz
	All rights reserved
*/

/* opcodes */
#define OP_BRT		0x01	/* branch on true */
#define OP_BRF		0x02	/* branch on false */
#define OP_BR		0x03	/* branch unconditionally */
#define OP_T		0x04	/* load top of stack with t */
#define OP_NIL		0x05	/* load top of stack with nil */
#define OP_PUSH		0x06	/* push nil onto stack */
#define OP_NOT		0x07	/* logical negate top of stack */
#define OP_ADD		0x08	/* add two numeric expressions */
#define OP_SUB		0x09	/* subtract two numeric expressions */
#define OP_MUL		0x0A	/* multiply two numeric expressions */
#define OP_DIV		0x0B	/* divide two numeric expressions */
#define OP_REM		0x0C	/* remainder of two numeric expressions */
#define OP_LT		0x0D	/* less than */
#define OP_LEQ		0x0E	/* less than or equal */
#define OP_EQ		0x0F	/* equal */
#define OP_NEQ		0x10	/* not equal */
#define OP_GEQ		0x11	/* greater than or equal */
#define OP_GT		0x12	/* greater than */
#define OP_LIT		0x13	/* load literal */
#define OP_VAR		0x14	/* load a variable value */
#define OP_SET		0x15	/* set the value of a variable */
#define OP_GETP		0x16	/* get the value of an object property */
#define OP_SETP		0x17	/* set the value of an object property */
#define OP_RETURN	0x18	/* return from interpreter */
#define OP_CALL		0x19	/* call a function */
#define OP_ARG		0x1A	/* load an argument value */
#define OP_ASET		0x1B	/* set an argument value */
#define OP_TFRAME	0x1C	/* push a temporary variable frame */
#define OP_TPOP		0x1D	/* pop a temporary variable frame */
#define OP_CONS		0x1E	/* make a cons cell */
#define OP_CAR		0x1F	/* get the car of a cons cell */
#define OP_SETCAR	0x20	/* set the car of a cons cell */
#define OP_CDR		0x21	/* get the cdr of a cons cell */
#define OP_SETCDR	0x22	/* set the cdr of a cons cell */
#define OP_VSIZE	0x23	/* get the size of a vector */
#define OP_VREF		0x24	/* get an element of a vector */
#define OP_VSET		0x25	/* set an element of a vector */
#define OP_NUMBERP	0x26	/* number predicate */
#define OP_STRINGP	0x27	/* string predicate */
#define OP_SYMBOLP	0x28	/* symbol predicate */
#define OP_CONSP	0x29	/* cons predicate */
#define OP_VECTORP	0x2A	/* vector predicate */
#define OP_OBJECTP	0x2B	/* object predicate */
#define OP_METHODP	0x2C	/* method predicate */
#define OP_CMETHODP	0x2D	/* cmethod predicate */
#define OP_PACKAGEP	0x2E	/* package predicate */
#define OP_NULLP	0x2F	/* null predicate */
#define OP_CALLNEXT	0x30	/* call next method */

ObjectPtr getp(ObjectPtr obj,ObjectPtr tag);
ObjectPtr setp(ObjectPtr obj,ObjectPtr tag,ObjectPtr val);
void PrintValue(ObjectPtr val);
