/* Drool.h - definitions for the little story telling language */
/*
	Copyright (c) 1993, by David Michael Betz
	All rights reserved
*/

#include "objects.h"
#include "Streams.h"

#define CheckNIL(x)	do { if ((x) == nil) InsufficientMemory(); } while (0)

/* prototypes for Compiler.c */
void InitCompiler(long csize,long lsize);
void InitCompilerVariables(void);
void ProtectCompilerVariables(void);
void Compile(StreamHandle s);

/* prototypes for Execute.c */
void Execute(ObjectPtr fcn);

/* prototypes for Functions.c */
void InitBuiltInFunctions(void);

/* prototypes for Scan.c */
void InitScan(StreamHandle s);
int token(void);
void stoken(int tkn);

/* prototypes for StorySpeak.c */
void TranscriptPutC(int ch);
void InsufficientMemory(void);
void Fatal(Str255 msg);

/* prototypes for Junk.c */
char *osalloc(long size);
void osfree(char *);
void oscheck(int);
void error(char *,...);
void info(char *,...);
void fatal(char *,...);
