{ ------------------------------------------------------------------------ }
{ --------------------------- Unidad PALETAS ----------------------------- }
{ ------------------------ Alberto Salazar Palomo ------------------------ }
{ ------------------------- Navigator Soft 1997 -------------------------- }
{ ------------------------------------------------------------------------ }
unit Paletas;

INTERFACE

  Type    RGBrec = record
                         red,
                         green,
                         blue: byte;
                   end;

          Paleta = Array[0..255] of RGBrec;

  Var RGB256:Paleta;

Procedure GetRGB(Col:byte; Var R,G,B:Byte);
Procedure SetRGB(Col,R,G,B:Byte);
Procedure GrayColor(Var P:Paleta;Ci,Cf:Byte);
Procedure TonePalette(Var P:Paleta;Ci,Cf:Byte;red,green,blue:real;R,G,B:Boolean); { para poner en una ados }
Procedure PaletteRange(VAR P:Paleta;Ci,Cf,R,G,B:Byte); { varia el color de los colores de la paleta actual }
Procedure BlackPal;
Procedure ArrayPal(P:PALETA);
Procedure PalArray(Var P:Paleta);
Procedure SetSpeedFade(Speed:Byte);                  {1:Slow; 15 Fast}
Procedure FadeOff(Ci,Cf:Byte;Time:Integer);
Procedure Fadeto(pal:paleta; Ci,Cf:Byte; time:integer);
Procedure Cicle(Var P:Paleta;I,F:Integer);

implementation

uses dos,crt;

Var SpeedFade:Byte;

procedure GetRGB; Assembler;
          Asm
             cli
             Mov Dx,03c7h
             Mov Al,Col
             Out Dx,Al

             Mov Dx,03c9h
             In Al,Dx
             Mov Byte Ptr [R],Al
             In Al,Dx
             Mov Byte Ptr [G],Al
             In Al,Dx
             Mov Byte Ptr [B],Al
             Mov Dx,3dah

             @Espera1:
                      In Al,Dx
                      Test Al,8
             Jz @Espera1

          End;


Procedure SetRGB; Assembler;
          Asm
             cli
             Mov Dx,03c8h
             Mov Al,Col
             Out Dx,Al
             Inc Dx
             Mov Al,R
             Out Dx,Al
             Mov Al,G
             Out Dx,Al
             Mov Al,B
             Out Dx,Al
          end;

procedure GrayColor;
          begin
               Tonepalette (p,Ci,Cf,0.3,0.59,0.11,True,True,True);
          end;

Procedure TonePalette;
          var a: integer;
              tono:Byte;
          begin
          for a:=Ci to Cf do
          begin
               Tono:=trunc(red*p[a].red+green*p[a].green+blue*p[a].blue);
               If Tono>63 Then Tono:=63;
               if R Then p[a].red:=Tono Else p[a].red:=0;
               if G Then p[a].green:=Tono Else p[a].green:=0;
               if B Then p[a].blue:=Tono Else p[a].blue:=0;
          end;
          end;

Procedure PaletteRange(VAR P:PAleta;Ci,Cf,R,G,B:Byte);
          Var i:Byte;
          Begin
               for i:=ci to cf Do
               Begin
                    P[i].red:=R;
                    P[i].green:=G;
                    P[i].blue:=B;
               End;
          End;

Procedure ArrayPal(P:Paleta); Assembler;
          Asm
             Push Ds
             Push Si

             Lds Si,P

             Mov Cx,0300h

          @Bucle:

              Mov Dx,3dah
              @Espera0:
                       In Al,Dx
                       Test Al,8
              Jz @Espera0

              Xor Bl,Bl
          @L1:

              Mov Dx,3c8h
              Mov Al,Cl
              Out Dx,Al

              Inc Dx
              Lodsb
              Out Dx,Al
              Lodsb
              Out Dx,Al
              Lodsb
              Out Dx,Al
              Inc Bl
              Inc Cl

              Cmp Bl,85

           Jne @L1

              Dec Ch
              Cmp Ch,0

           Jne @Bucle

               Mov Dx,3c8h
               Mov Al,255
               Out Dx,Al

               Inc Dx
               Lodsb
               Out Dx,Al
               Lodsb
               Out Dx,Al
               Lodsb
               Out Dx,Al

               Pop Si
               Pop Ds

           End;

Procedure BlackPal;
          Var i:Byte;
          Begin
               For i:=0 to 255 do SetRGB(i,0,0,0)
          End;

Procedure PalArray; Assembler;
          Asm
             CLI
             XOR AL,AL
             MOV DX,3C7h
             OUT DX,AL
             LES DI,P
             MOV CX,768
             MOV DX,3C9h
          @L1:
             IN AL,DX
             STOSB
             LOOP @L1
             STI
          End;

Procedure FadeOff;
          Var A,B:Integer;
              PAL:Paleta;
          Begin
               PalArray(PAL);
               For A:=0 to (63 Div SpeedFade) Do Begin
                   For B:=Ci to Cf Do Begin
                       With PAL[B] Do
                       Begin
                            If red>SpeedFade Then Dec(red,SpeedFade) Else Red:=0;
                            If green>SpeedFade Then Dec(green,SpeedFade) Else Green:=0;
                            If blue>SpeedFade then Dec(blue,SpeedFade) Else Blue:=0;
                       End;
                   End;
                   ArrayPal(PAL); Delay(Time);
               End;
               for a:=0 to cf Do
               Begin
                    Pal[a].red:=0;
                    Pal[a].green:=0;
                    Pal[a].blue:=0;
               End;
               ArrayPal(Pal);
          End;

Procedure FadeTo;
          Var A,B:Integer;
              Pal1:Paleta;
          Begin
               palarray (pal1);
               For A:=0 to (63 Div SpeedFade) Do
               Begin
                   For B:=Ci to Cf Do
                   Begin
                        If Pal1[B].red<Pal[B].red Then
                        Begin
                             if Integer(Pal1[B].red+SpeedFade)<63 Then Inc(Pal1[B].red,SpeedFade);
                             If Pal1[B].red>Pal[B].red Then Pal1[B].red:=Pal[B].red
                        End;

                        If Pal1[B].green<Pal[B].green Then
                        Begin
                             if Integer(Pal1[B].green+SpeedFade)<63 Then Inc(Pal1[B].green,SpeedFade);
                             If Pal1[B].green>Pal[B].green Then Pal1[B].green:=Pal[B].green
                        End;

                        If Pal1[B].blue<Pal[B].blue then
                        Begin
                             if Integer(Pal1[B].blue+SpeedFade)<63 Then Inc(Pal1[B].blue,SpeedFade);
                             If Pal1[B].blue>Pal[B].blue Then Pal1[B].blue:=Pal[B].blue
                        End;

                        If Pal1[B].red>Pal[B].red Then
                        Begin
                             if (Pal1[B].red>SpeedFade) then dec(Pal1[B].red,SpeedFade);
                             If (Pal1[B].red<Pal[B].red) or (Pal1[B].red>63) Then Pal1[B].red:=Pal[B].red
                        End;

                        If Pal1[B].green>Pal[B].green Then
                        Begin
                             if (Pal1[B].green>SpeedFade) then dec(Pal1[B].green,SpeedFade);
                             If (Pal1[B].green<Pal[B].green) or (Pal1[B].green>63) Then Pal1[B].green:=Pal[B].green
                        end;

                        If Pal1[B].blue>Pal[B].blue then
                        Begin
                             if (Pal1[B].blue>SpeedFade) then dec(Pal1[B].blue,SpeedFade);
                             If (Pal1[B].blue<Pal[B].blue) or (Pal1[B].blue>63) Then Pal1[B].blue:=Pal[B].blue
                        End;
                   End;
                   ArrayPal(PAL1); Delay(Time);
               End;
               for b:=ci to cf Do Pal1[b]:=Pal[b];
               ArrayPal(Pal1);
          End;

Procedure Cicle;
          Var D:RgbRec;
              A:Integer;
          Begin
               If I<F Then
               Begin
                  D:=P[I];
                  For A:=I To F-1 Do P[A]:=P[A+1];
                  P[F]:=D;
               End
                  Else
               Begin
                  D:=P[I];
                  For A:=I DownTo F+1 Do P[A]:=P[A-1];
                  P[F]:=D;
               End;
          End;

Procedure SetSpeedFade;
          Begin
               SpeedFade:=Speed;
          End;


Begin
     SpeedFade:=1;
end.