/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// ObjectDialog.cpp : implementation file
//

#include "stdafx.h"
#include "WinAce.h"
#include "ObjectDef.h"
#include "ObjectDialog.h"
#include "ObjectList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectDialog dialog


CObjectDialog::CObjectDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CObjectDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjectDialog)
	//}}AFX_DATA_INIT
}


void CObjectDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectDialog)
	DDX_Control(pDX, IDC_OBJLIST, m_objList);
	DDX_Control(pDX, IDC_COMBO1, m_comboBox);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectDialog, CDialog)
	//{{AFX_MSG_MAP(CObjectDialog)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_OBJLIST, OnGetdispinfoObjlist)
	ON_BN_CLICKED(IDC_BUTTON1, OnSetValue)
	ON_NOTIFY(NM_CLICK, IDC_OBJLIST, OnClickObjlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectDialog message handlers

void CObjectDialog::setData(CObjectList *objList, int maxLoc)
{
 p_objList = objList;
 locationCount = maxLoc;
}

BOOL CObjectDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_objList.SetExtendedStyle( LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP );

	m_objList.SetItemCount( p_objList->GetObjectCount() );

	wchar_t temp[5];

	for ( int counter=0; counter <= locationCount; counter++ )
	{
		wsprintf( temp,_T("%i"),counter );
		m_comboBox.InsertString(counter+3, CString(temp) );
	}
	
	// TODO: Add extra initialization here

	m_objList.InsertColumn(0,_T("Object Number"),LVCFMT_LEFT,100);
	m_objList.InsertColumn(1,_T("Description (short)"),LVCFMT_LEFT,100);
	m_objList.InsertColumn(2,_T("Object Location"),LVCFMT_LEFT,100);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CObjectDialog::OnGetdispinfoObjlist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	LV_ITEM* item = &pDispInfo->item;

	if (item->mask & LVIF_TEXT) //valid text buffer?
	{
		wchar_t buffer[10]=_T("\0\0\0\0\0\0\0\0\0");

		if ( item->iSubItem == 0 )
		{
		    wsprintf( pDispInfo->item.pszText, _T("%d"), item->iItem);
			//::mbstowcs(  (wchar_t *)pDispInfo->item.pszText,buffer, 6 );
			item->mask =  LVIF_DI_SETITEM;

			
		}
		
		if ( item->iSubItem == 1 )
		{
		    wsprintf( pDispInfo->item.pszText, _T("%s"), p_objList->GetObjectDescShort( item->iItem ));
		//	::mbstowcs(  (unsigned short*)pDispInfo->item.pszText,buffer, 6 );
			
		}

		if ( item->iSubItem == 2 )
		{
			int location = p_objList->GetObject( item->iItem )->GetLocation();
			switch ( location )
			{
			case 254:
				wsprintf( pDispInfo->item.pszText, _T("%s"), _T("Carried") );
				break;
			case 252:
				wsprintf( pDispInfo->item.pszText, _T("%s"), _T("Nowhere") );
				break;
			case 253:
				wsprintf( pDispInfo->item.pszText, _T("%s"), _T("Worn") );
				break;
			default:
				wsprintf( pDispInfo->item.pszText, _T("%d"),location  );
			}
		//	::mbstowcs(  (unsigned short*)pDispInfo->item.pszText,buffer, 6 );
			
		}

    }

		*pResult = 0;
}

void CObjectDialog::OnSetValue() 
{
	// TODO: Add your control notification handler code here
	if ( selection != -1 )
	{
		int newLoc = 0;

		switch ( m_comboBox.GetCurSel() )
		{
		case 0: newLoc = 254;
				break;
		case 1: newLoc = 253;
				break;
		case 2: newLoc = 252;
				break;
		default:
				newLoc = m_comboBox.GetCurSel()-3;
		}

		p_objList->GetObject(selection)->SetLocation( newLoc );
		m_objList.RedrawItems( selection, selection );
		
	}

}

void CObjectDialog::OnClickObjlist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	selection = m_objList.GetSelectionMark();
		
	if ( selection != -1 )
	{
		int objLocation = p_objList->GetObject( selection )->GetLocation();
		int comboSelection = 0;
			switch ( objLocation )
			{
			case 252:
				comboSelection = 2;
				break;
			case 253:
				comboSelection = 1;
				break;
			case 254:
				comboSelection = 0;
				break;
			default:
				comboSelection = objLocation+3;
			}
		m_comboBox.SetCurSel( comboSelection );

	}

	
	*pResult = 0;
}
