/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

#include <stdio.h>
#include <conio.h>
#include <iostream>

#include "stdafx.h"
#include "cadv_main.hpp" 

CAdvMain::~CAdvMain()
{	
	if ( parser != NULL ) delete parser;
	if ( Kernel != NULL ) delete Kernel;
	if ( undoCache != NULL ) delete undoCache;
	if ( Objects != NULL ) delete Objects;
}

CAdvMain::CAdvMain()
{
	parser=NULL;
	Kernel=NULL;
	undoCache=NULL;
	Objects = NULL;
}

int CAdvMain::Load(const wchar_t *filename)
{
	parser = new CParser;
	Objects = new CObjectList( parser );
	

	CString player_command;
	CFile  f;

	//Set Up Test Data

	if( !f.Open( (LPCTSTR)filename, CFile::modeRead) ) 
	{
		return -1;
	}
	CArchive ar( &f, CArchive::load );

	parser->InitVocab( ar );// Read Vocabulary From Archive
	SysMsg.Serialize ( ar );// Read System Messages
	UserMsg.Serialize( ar );// Read user Messages
	Objects->Serialize( ar );// Read Object Definitions
	GameMap.Serialize( ar );// Read Games Map
	undoCache = new CUndoCache(5);
	Kernel = new CKernel( &GameMap, &Flags, &SysMsg, &UserMsg, Objects , parser, undoCache); //Configure Kernel
	Objects->Flags = &Flags;//Configure Objects
	Objects->SysMsgs = &SysMsg;
	Kernel -> InitProcessTables( ar );
	//	OutStream.ClearScreen(); //Reset Screen;
	ar >> Kernel -> Registered;
	ar >>Debugable;
	Restart();

	return 0;
}



void CAdvMain::Restart()
{


	Objects->Reset(); //Reset All Objects TO Start State
	Flags.Reset();
	undoCache->Empty();

	status=PROC_DESC;
	parser->first_input=true;


}


void CAdvMain::DescribeRoom()
{
	int status = PROC_DESC;
	while ( status == PROC_DESC )
	{


		//	OutStream.ClearScreen();
		bool Dark = ( ( Flags.GetFlag(0) != 0 ) && (Objects->GetObject(0)->Absent( Flags.GetFlag( FL_LOCATION ) )));

		if ( Dark )
			OutStream.WriteDesc( SysMsg.GetMessage(0),  Flags.GetFlag(40) );
		else
			OutStream.WriteDesc( GameMap.GetDescription( Flags.GetFlag( FL_LOCATION ) ),  Flags.GetFlag(40) );

		status=Kernel->DoProcessTbl(1,-1,-1);//Scan Process Table 1	

		if (!Dark )
		{
			PrintObjects();
		}

		Flags.DecFlag(2);

		if ( Flags.GetFlag(0) != 0 ) 
		{
			Flags.DecFlag(3); //its dark
			Flags.DecFlag(9);
		}

		if ( ( Flags.GetFlag(0) != 0 ) && (Objects->GetObject(0)->Absent( Flags.GetFlag( FL_LOCATION ) )) )
		{
			Flags.DecFlag(4);
			Flags.DecFlag(10);
		}

		//if ( status == PROC_DESC ) return status;
	}
}

int CAdvMain::PreInput()
{

	//if ( status == PROC_LOAD ) return status;
	//bool Dark = ( ( Flags.GetFlag(0) != 0 ) && (Objects.GetObject(0)->Absent( CurrentLocation )));


	status=Kernel->DoProcessTbl(2,-1,-1);//scan process Table 2

	//OutStream.Write("<BR>");
	//SysMsg.PrintMessage(3,"");


	return status;

}


int CAdvMain::ProcessInput( CString input )
{

	//////////////////////////////////////////////////////////////////////////////
	//SEARCH PROCESS TABLE 2
	//GET PHRASE

	int newroom;
	wchar_t *player_input = input.GetBuffer();

	SavePosition();

    parser->parse( player_input ); //parse the current line...


	do
	{
		

		Flags.SetFlag( FL_NOUN1, parser->noun1 ); //set the flags accordingly
		Flags.SetFlag( FL_VERB, parser->verb );
		Flags.SetFlag( FL_PREP, parser->preposition );
		Flags.SetFlag( FL_NOUN2, parser->noun2 );
		Flags.SetFlag( FL_ADJECTIVE2, parser->adjective2 );
		Flags.SetFlag( FL_ADJECTIVE1, parser->adjective1 );
		Flags.SetFlag( FL_ADVERB, parser->adverb );


		if ( parser -> noun1 != -1 ) 
		{
			Objects->SetCurrentObject(); //if there is a recognised noun ... is it a object
		}



		status = -1;

		status = Kernel->DoProcessTbl(0, parser->verb, parser->noun1 ); //Scan Process Table 0
		if ( status == PROC_QUIT ) return status;
		if ( status == PROC_RESTART) return status;
		if ( status == PROC_LOAD) return status;

		if ( status != PROC_AGAIN )
		{
			Flags.DecFlag(5);
			Flags.DecFlag(6);
			Flags.DecFlag(7);
			Flags.DecFlag(8);
			Flags.DoAutoDecs();
			Flags.IncFlag(31); //turns taken
		}



		//SEARCH CONNECTIONS
		if ( parser->verb == -1 )
		{
			SysMsg.PrintMessage( 6, _T(""), parser );
		}
		else
		{
			if ( (parser->verb < 15) && (status == -1 ) )
			{
				newroom = GameMap.MapLocation( Flags.GetFlag( FL_LOCATION ), parser->verb );
				if ( (newroom == -1) && (status == -1 ) )
				{	
					SysMsg.PrintMessage( 7, _T(""), parser);
				}
				else
				{
					Flags.SetFlag(FL_LOCATION,newroom);
					status=PROC_DESC;
				}
			}
			else
			{
				if ( (status == PROC_COND_EXIT) || (status == -1 ) )
				{
					SysMsg.PrintMessage( 8,_T(""), parser );
				}
			}
		}
	}
	while ( status == PROC_AGAIN );

	parser->first_input=false;
	return status;

}



void CAdvMain::PrintObjects()
{
	int ObjectsHere=0;
	int counter;
	CString temp;

	for ( counter=0; counter < Objects->MaxObjects; counter++ )
	{
		if ( (Objects->GetObject(counter)->Location) == Flags.GetFlag( FL_LOCATION )) 
		{
			if ( ObjectsHere==0)
		 {
			 SysMsg.PrintMessage(1,_T(""), parser );
			 temp = Objects->GetObjectDesc(counter);
			 temp.SetAt(0, tolower( temp[0] ) );
			 temp=temp;
			 OutStream.Write(temp);
			 ObjectsHere=1;
		 }
			else
		 {
			 OutStream.Write(CString(", "));
			 temp = Objects->GetObjectDesc(counter);
			 temp.SetAt(0, tolower( temp[0] ) );
			 temp=temp;
			 OutStream.Write(temp);
		 }
		}
	}
	if (ObjectsHere==1)
	{
		OutStream.Write(CString("."));
	}
}

void CAdvMain::DebugMode()
{
//No longer supported
}

void CAdvMain::SavePosition()
{
	CMemFile *f = new CMemFile();

	CArchive *ar = new CArchive( f, CArchive::store);

	Objects->GameSerialize( *ar );
	Flags.Serialize( *ar );

	ar->Flush();
	ar -> Close();
	//f->Close();

	delete ar;

	undoCache->Push(f);

}



