/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// MessageList.h: interface for the CMessageList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MESSAGELIST_H__94E53307_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_MESSAGELIST_H__94E53307_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class COutputStream;
class CParser;

class CMessageList : public CObject 
{

DECLARE_SERIAL( CMessageList )

public:
	bool validate( int MessageNo );
	int PrintMessage(int Message, CString CurrentObject, CParser *parser );
	CMessageList();
	virtual ~CMessageList();
	CString GetMessage( int );
	void SetMessage( int, CString );
	int PrintRawMessage(int Message, CString CurrentObject);
	CString FormatMessage( CString Message, CParser *parser );
	virtual void Serialize ( CArchive &ar );

	int MaxMessages;

private:
	CArray<CString, CString> Messages;
	COutputStream *OutStream;


};

#endif // !defined(AFX_MESSAGELIST_H__94E53307_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
