package zpplet.ops;

import java.io.IOException;

import zpplet.machine.ZMachine;
import zpplet.misc.*;

public class ZInstruction4
		extends ZInstruction3
	{
	protected final static int SCREEN_UNSPLIT = -1;
	protected final static int SCREEN_NOUNSPLIT = -2;

	public ZInstruction4(ZMachine zm)
		{
		super(zm);
		}

	protected void initOps()
		{
		super.initOps();

		ops[25] = new OP_CALL(); // CALL_2S
		ops[136] = new OP_CALL(); // CALL_1S
		ops[188] = new OP_NOP(); // SHOW_STATUS
		//ops[224] = new OP_CALL(); // CALL_VS
		ops[236] = new OP_CALL(); // CALL_VS2
		ops[237] = new OP_ERASE_WINDOW();
		ops[238] = new OP_ERASE_LINE();
		ops[239] = new OP_SET_CURSOR();
		ops[240] = new OP_GET_CURSOR();
		ops[241] = new OP_SET_TEXT_STYLE();
		ops[242] = new OP_BUFFER_MODE();
		ops[246] = new OP_READ_CHAR();
		ops[247] = new OP_SCAN_TABLE();
		}

	class OP_ERASE_WINDOW
			implements IOP
		{
		public void x()
			{
			doEraseWindow();
			}
		}

	class OP_ERASE_LINE
			implements IOP
		{
		public void x()
			{
			doEraseLine();
			}
		}

	class OP_SET_CURSOR
			implements IOP
		{
		public void x()
			{
			if (zm.curw == zm.w[1])
				zm.curw.moveCursor(o[1], o[0]);
			}
		}

	class OP_GET_CURSOR
			implements IOP
		{
		public void x()
			{
			zm.curw.flush();
			zm.setWord(o[0], zm.curw.getCursorY());
			zm.setWord(o[0] + 2, zm.curw.getCursorX());
			}
		}

	class OP_SET_TEXT_STYLE
			implements IOP
		{
		public void x()
			{
			zm.curw.setStyle(o[0]);
			}
		}

	class OP_BUFFER_MODE
			implements IOP
		{
		public void x()
			{
			zm.w[0].setBufferMode(o[0] != 0);
			}
		}

	class OP_READ_CHAR
			implements IOP
		{
		public void x()
				throws ZError
			{
			zm.curw.flush();
			zm.curw.resetLineCount();
			if (noperands < 2)
				o[1] = 0;
			if (noperands < 3)
				o[2] = 0;

			zm.s.repaint();
			int ch = zm.getInput(false, o[1], o[2]);
			if (ch == ZChars.ABORT)
				throw new ZError(null); // terminating
			doStore(ch);
			}
		}

	class OP_SCAN_TABLE
			implements IOP
		{
		public void x()
			{
			int r = scanTable();
			doStore(r);
			doBranch(r != 0);
			}
		}
	
	int scanTable()
		{
		int advance = 2;
		int location = o[1];
		int lastloc;
		int len = o[2];
		boolean words = true;

		if (noperands == 4)
			{
			advance = o[3] & 0x7F;
			words = (o[3] & 0x80) != 0;
			}
		if (words)
			{
			lastloc = location + len * 2;
			while (location < lastloc)
				{
				if (zm.getWord(location) == o[0])
					return location;
				location += advance;
				}
			}
		else
			// bytes
			{
			lastloc = location + len;
			while (location < lastloc)
				{
				if (zm.getByte(location) == o[0])
					return location;
				location += advance;
				}
			}
		return 0;
		}

	/* 
	 * Overridable methods follow
	 */

	protected void doSave()
		{
		try
			{
			String fname = zm.s.getFileName("Save Game", true);
			if (fname != null)
				{
				(new ZState(zm)).saveQuetzalFile(fname);
				doStore(1);
				return;
				}
			}
		catch (IOException e)
			{}
		doStore(0);
		}

	protected void doRestore()
		{
		try
			{
			String fname = zm.s.getFileName("Load Game", false);
			if (fname != null)
				{
				(new ZState(zm)).loadQuetzalFile(fname);
				doStore(2); // this actually is completing a SAVE operation
				return;
				}
			}
		catch (Exception e)
			{}
		doStore(0);
		}
	
	protected void doEraseWindow()
		{
		short n = (short)o[0];
		if (n == SCREEN_UNSPLIT)
			{
			zm.s.clear();
			doSplitWindow(0);
			zm.w[0].moveCursor(1, zm.w[0].getLines());
			}
		else if (n == SCREEN_NOUNSPLIT)
			{
			zm.s.clear();
			zm.w[0].moveCursor(1, 1);
			zm.w[1].moveCursor(1, 1);
			}
		else
			{
			zm.w[o[0]].clear();
			if (o[0] == 0)
				zm.w[0].moveCursor(1, zm.w[0].getLines());
			else
				zm.w[o[0]].moveCursor(1, 1);
			}
		}
	
	protected void doEraseLine()
		{
		if (o[0] == 1)
			zm.curw.eraseLine();
		}
	}