package zpplet.data;

import zpplet.machine.ZMachine;

public class ZDictionary // services V1-3
	{
	protected ZMachine zm;
	protected int addr;
	protected String separators;
	protected int entry_length;
	protected int nentries;
	protected int wtable_addr;
	
	public ZDictionary(ZMachine zm)
		{
		this.zm = zm;
		addr = zm.hd.getDictionaryAddr();

		// get separators
		int n = zm.getByte(addr);
		char[] separray = new char[n];
		for (int i = 0; i < n; i++)
			separray[i] = (char)zm.getByte(addr + i + 1);
		separators = new String(separray);

		entry_length = zm.getByte(addr + n + 1);
		nentries = zm.getWord(addr + n + 2);
		wtable_addr = addr + n + 4;
		}

	protected ZDictionary()
		{}

	protected boolean addToken(int textaddr, int wordaddr, int wordlength,
			int parseaddr, boolean keepUnknown)
		{
		if (zm.getByte(parseaddr) == zm.getByte(parseaddr + 1))
			return true; // full

		int[] encword = zm.zc.encode(wordaddr, wordlength, 2);
		int encint = (encword[0] << 16) | encword[1];

		int first = 0;
		int last = nentries - 1;
		int middle = (last + first) / 2;

		int dictloc, dictint;

		while (true)
			{
			dictloc = wtable_addr + (middle * entry_length);
			dictint = zm.getWord(dictloc) << 16 | zm.getWord(dictloc + 2);
			if (encint < dictint)
				{
				if (first == middle)
					break;
				last = middle - 1;
				middle = (first + middle) / 2;
				}
			else if (encint > dictint)
				{
				if (last == middle)
					break;
				first = middle + 1;
				middle = (middle + last + 1) / 2;
				}
			else
				break;
			}

		if (encint != dictint)
			dictloc = 0;

		if ((dictloc != 0) || keepUnknown)
			{
			int parseentry = parseaddr + (zm.getByte(parseaddr + 1)) * 4 + 2;
			zm.setWord(parseentry, dictloc);
			zm.setByte(parseentry + 2, wordlength);
			zm.setByte(parseentry + 3, wordaddr - textaddr + 1);
			zm.setByte(parseaddr + 1, zm.getByte(parseaddr + 1) + 1);
			}
		return (zm.getByte(parseaddr) == zm.getByte(parseaddr + 1)); // full?
		}

	public void tokenize(int textaddr, int len, int parseaddr, boolean keepUnknown)
		{
		if (zm.getByte(parseaddr) < 6)
			System.err.println("Parse buffer less than 6 words");

		zm.setByte(parseaddr + 1, 0);

		int wstart = textaddr;
		int wlen = 0;
		boolean pbfull = false;
		for (int i = 0; (i < len) && !pbfull; i++)
			{
			char ch = (char)zm.getByte(textaddr + i);
			if (separators.indexOf(ch) >= 0)
				{
				if (wlen > 0)
					addToken(textaddr, wstart, wlen, parseaddr, keepUnknown);
				pbfull = addToken(textaddr, wstart + wlen, 1, parseaddr, keepUnknown);
				wstart += wlen + 1;
				wlen = 0;
				}
			else if (ch == ' ')
				{
				if (wlen > 0)
					addToken(textaddr, wstart, wlen, parseaddr, keepUnknown);
				wstart += wlen + 1;
				wlen = 0;
				}
			else
				wlen++;
			}

		if (!pbfull && (wlen > 0))
			addToken(textaddr, wstart, wlen, parseaddr, keepUnknown);

		//debugDumpTokens(parseaddr, textaddr);
		}

/*	private void debugDumpTokens(int addr, int text)
		{
		int n = zm.getByte(addr + 1);
		System.out.print("tokens: ");
		for (int i = 0; i < n; i++)
			{
			int dictaddr = zm.getWord(addr + 2 + i * 4);
			int len = zm.getByte(addr + 2 + i * 4 + 2);
			int textaddr = text + zm.getByte(addr + 2 + i * 4 + 3);
			if (zm.hd.getVersion() <= 4)
				textaddr -= 1;
			else
				textaddr -= 2;
			if (dictaddr == 0)
				{
				System.out.print("'");
				for (int j = 0; j < len; j++)
					System.out.print((char)zm.getByte(textaddr + j));
				System.out.print("'? ");
				}
			else
				{
				try
					{
					String s = zm.getStringAt(dictaddr);
					System.out.print("'" + s + "' ");
					}
				catch (Exception e)
					{}
				}
			}
		System.out.println(";");
		}*/
	}