/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.awt.image.BufferedImage;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.iff.FormChunk;
import org.zmpp.iff.WritableFormChunk;
import org.zmpp.media.MediaCollection;
import org.zmpp.media.PictureManager;
import org.zmpp.media.PictureManagerImpl;
import org.zmpp.media.SoundEffect;
import org.zmpp.media.SoundSystem;
import org.zmpp.media.SoundSystemImpl;
import org.zmpp.vm.Cpu;
import org.zmpp.vm.CpuImpl;
import org.zmpp.vm.GameData;
import org.zmpp.vm.Input;
import org.zmpp.vm.InputFunctions;
import org.zmpp.vm.InputImpl;
import org.zmpp.vm.InstructionDecoder;
import org.zmpp.vm.Machine;
import org.zmpp.vm.Output;
import org.zmpp.vm.OutputImpl;
import org.zmpp.vm.PortableGameState;
import org.zmpp.vm.SaveGameDataStore;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.ScreenModel6;
import org.zmpp.vm.StatusLine;
import org.zmpp.vm.StoryFileHeader;
import org.zmpp.vm.ZObject;
import org.zmpp.vmutil.PredictableRandomGenerator;
import org.zmpp.vmutil.RandomGenerator;
import org.zmpp.vmutil.RingBuffer;
import org.zmpp.vmutil.UnpredictableRandomGenerator;

public class MachineImpl
implements Machine {
    private static final int NUM_UNDO = 5;
    private GameData gamedata;
    private RandomGenerator random;
    private StatusLine statusLine;
    private ScreenModel screenModel;
    private SaveGameDataStore datastore;
    private RingBuffer<PortableGameState> undostates;
    private InputFunctions inputFunctions = new InputFunctions(this);
    private SoundSystem soundSystem;
    private PictureManager pictureManager;
    private Cpu cpu;
    private Output output;
    private Input input;

    public GameData getGameData() {
        return this.gamedata;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Output getOutput() {
        return this.output;
    }

    public Input getInput() {
        return this.input;
    }

    public void initialize(GameData gameData, InstructionDecoder instructionDecoder) {
        this.gamedata = gameData;
        this.random = new UnpredictableRandomGenerator();
        this.undostates = new RingBuffer(5);
        this.cpu = new CpuImpl(this, instructionDecoder);
        this.output = new OutputImpl(gameData, this.cpu);
        this.input = new InputImpl(this);
        MediaCollection<SoundEffect> mediaCollection = null;
        MediaCollection<BufferedImage> mediaCollection2 = null;
        int n = 0;
        if (gameData.getResources() != null) {
            mediaCollection = gameData.getResources().getSounds();
            mediaCollection2 = gameData.getResources().getImages();
            n = gameData.getResources().getRelease();
        }
        this.soundSystem = new SoundSystemImpl(mediaCollection);
        this.pictureManager = new PictureManagerImpl(n, mediaCollection2);
        this.resetState();
    }

    public short random(short s) {
        if (s < 0) {
            this.random = new PredictableRandomGenerator(-s);
            return 0;
        }
        if (s == 0) {
            this.random = new UnpredictableRandomGenerator();
            return 0;
        }
        return (short)(this.random.next() % s + 1);
    }

    public void warn(String string) {
        System.err.println("WARNING: " + string);
    }

    public void restart() {
        this.restart(true);
    }

    public void quit() {
        this.cpu.setRunning(false);
        this.output.print(new ZsciiString("*Game ended*"));
        this.closeStreams();
        this.screenModel.redraw();
    }

    public void start() {
        this.cpu.setRunning(true);
    }

    public void tokenize(int n, int n2, int n3, boolean bl) {
        this.inputFunctions.tokenize(n, n2, n3, bl);
    }

    public short readLine(int n, int n2, int n3) {
        return this.inputFunctions.readLine(n, n2, n3);
    }

    public short readChar(int n, int n2) {
        return this.inputFunctions.readChar(n, n2);
    }

    public SoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    public PictureManager getPictureManager() {
        return this.pictureManager;
    }

    public void setSaveGameDataStore(SaveGameDataStore saveGameDataStore) {
        this.datastore = saveGameDataStore;
    }

    public void updateStatusLine() {
        if (this.gamedata.getStoryFileHeader().getVersion() <= 3 && this.statusLine != null) {
            short s = this.cpu.getVariable(16);
            ZObject zObject = this.gamedata.getObjectTree().getObject(s);
            String string = this.gamedata.getZCharDecoder().decode2Zscii(this.gamedata.getMemoryAccess(), zObject.getPropertiesDescriptionAddress(), 0).toString();
            short s2 = this.cpu.getVariable(17);
            short s3 = this.cpu.getVariable(18);
            if (this.gamedata.getStoryFileHeader().isEnabled(StoryFileHeader.Attribute.SCORE_GAME)) {
                this.statusLine.updateStatusScore(string, s2, s3);
            } else {
                this.statusLine.updateStatusTime(string, s2, s3);
            }
        }
    }

    public void setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
    }

    public void setScreen(ScreenModel screenModel) {
        this.screenModel = screenModel;
    }

    public ScreenModel getScreen() {
        return this.screenModel;
    }

    public ScreenModel6 getScreen6() {
        return (ScreenModel6)this.screenModel;
    }

    public boolean save(int n) {
        if (this.datastore != null) {
            PortableGameState portableGameState = new PortableGameState();
            portableGameState.captureMachineState(this, n);
            WritableFormChunk writableFormChunk = portableGameState.exportToFormChunk();
            return this.datastore.saveFormChunk(writableFormChunk);
        }
        return false;
    }

    public boolean save_undo(int n) {
        PortableGameState portableGameState = new PortableGameState();
        portableGameState.captureMachineState(this, n);
        this.undostates.add(portableGameState);
        return true;
    }

    public PortableGameState restore() {
        if (this.datastore != null) {
            PortableGameState portableGameState = new PortableGameState();
            FormChunk formChunk = this.datastore.retrieveFormChunk();
            portableGameState.readSaveGame(formChunk);
            if (this.verifySaveGame(portableGameState)) {
                this.restart(false);
                portableGameState.transferStateToMachine(this);
                return portableGameState;
            }
        }
        return null;
    }

    public PortableGameState restore_undo() {
        if (this.undostates.size() > 0) {
            PortableGameState portableGameState = this.undostates.remove(this.undostates.size() - 1);
            this.restart(false);
            portableGameState.transferStateToMachine(this);
            System.out.printf("restore(), pc is: %4x\n", this.cpu.getProgramCounter());
            return portableGameState;
        }
        return null;
    }

    private boolean verifySaveGame(PortableGameState portableGameState) {
        StoryFileHeader storyFileHeader = this.gamedata.getStoryFileHeader();
        int n = storyFileHeader.getChecksum();
        if (n == 0) {
            n = this.gamedata.getCalculatedChecksum();
        }
        return portableGameState.getRelease() == storyFileHeader.getRelease() && portableGameState.getChecksum() == n && portableGameState.getSerialNumber().equals(storyFileHeader.getSerialNumber());
    }

    private void closeStreams() {
        this.input.close();
        this.output.close();
    }

    private void resetState() {
        this.output.reset();
        this.soundSystem.reset();
        this.cpu.reset();
        if (this.gamedata.getStoryFileHeader().getVersion() >= 4) {
            this.gamedata.getStoryFileHeader().setEnabled(StoryFileHeader.Attribute.SUPPORTS_TIMED_INPUT, true);
            this.gamedata.getStoryFileHeader().setInterpreterNumber(6);
            this.gamedata.getStoryFileHeader().setInterpreterVersion(1);
        }
    }

    private void restart(boolean bl) {
        StoryFileHeader storyFileHeader = this.gamedata.getStoryFileHeader();
        boolean bl2 = storyFileHeader.isEnabled(StoryFileHeader.Attribute.FORCE_FIXED_FONT);
        boolean bl3 = storyFileHeader.isEnabled(StoryFileHeader.Attribute.TRANSCRIPTING);
        this.gamedata.reset();
        this.resetState();
        if (bl) {
            this.screenModel.reset();
        }
        storyFileHeader.setEnabled(StoryFileHeader.Attribute.TRANSCRIPTING, bl3);
        storyFileHeader.setEnabled(StoryFileHeader.Attribute.FORCE_FIXED_FONT, bl2);
    }
}

