/*
** Arr_hint.t contains the solutions to all the puzzles, as well as some
** miscellaneous menu items
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

top_menu: menuItem
    title = "Arrival Menu"
    myContents = [instruct_menu hint_menu]
;


/*
 * The instructions & other info
 */
instruct_menu: submenuItem
    title = "Instructions and information"
    myContents = [special_commands, credit_where_its_due, legalese,
        version_info, alias_info, competition_info]
;

special_commands: longTopicItem
    title = "Special commands"
    myContents = { commandsVerb.describeMe; }
;

credit_where_its_due: longTopicItem
    title = "Credit where it&rsquo;s due"
    myContents = { creditsVerb.describeMe; }
;

legalese: longTopicItem
    title = "Fine print"
    myContents = {
        "<b>Copyright Information</b>
            \b\tThis game, <b>Arrival</b>, is copyright &copy; 1998 by
            Stephen Granade.
        \b<b>Licensing Information</b>
            \b\tI place the following terms and conditions on copying and
            distributing <b>Arrival</b>: You may copy and distribute
            <b>Arrival</b> in whatever format you choose, as long as it (and
            especially its copyright information) is not altered. You may
            not distribute this game for a fee which is greater than the
            cost of distribution. Distribution of this game constitutes
            acceptance of this license.
        \b<b>A Legal Dodge</b>
            \b\tBecause this game is offered free of charge, there is no
            warranty attached to it. Whatever happens to your computer while
            playing <b>Arrival</b> is your problem to deal with. ";
    }
;

version_info: longTopicItem
    title = "Version information"
    myContents = {
        "This is the second version, compiled on 23 Dec 98. It
            fixes several
            bugs (most notably, mom now responds to objects you show her) and
            adds a few refinements.
        \bThe first version was compiled on 30 Sept 98 for the 4th Annual
            Interactive Fiction Competiton. It placed 4th in a field of
            27 entrants. ";
    }
;

alias_info: longTopicItem
    title = "What was up with Samantha Clark?"
    myContents = {
        "You may have seen or played a version of <b>Arrival</b> which had
            the name <q>Samantha Clark</q> attached to it. Never fear: that
            was me, entering the contest under a pseudonym.
        \bI used a pseudonym so that people wouldn&rsquo;t have preconceived
            notions about this game. My previous game, <i>Losing Your
            Grip</i>, was very different from this one, and since most people
            were only going to get a two-hour look at <b>Arrival</b>, I wanted
            them to start off with as blank a slate as possible.
        \bThe name was chosen to honor different members of my family.";
    }
;

competition_info: longTopicItem
    title = "About the 4th Annual Interactive Fiction Competition"
    myContents = {
        "Every year, the readers of the Usenet newsgroups
            <b>rec.arts.int-fiction</b> and
            <b>rec.games.int-fiction</b> hold a competition. Folks like me
            write short adventure games and submit them; folks like you
            judge the games, ranking them on a scale of 1 to 10. After
            several weeks everyone votes, the votes are counted, and the
            rankings of the games are published.
        \bThe rules are fairly simple. You may play this game for two hours;
            after that time, you must assign it a score between 1 and 10,
            using whatever judging method you like. I recommend
            automatically giving <b>Arrival</b> a 10 when you&rsquo;re done.
            After that you
            can keep playing, but you cannot change your rating after the
            two-hour mark.
        \bOnce you&rsquo;ve played and ranked as many games as possible,
            submit your votes. There is a form for submitting votes
            at the competition web site.
        \bThat&rsquo;s it. To read the full rules, submit votes,
            or find other competiton games, take a look at the competition
            web site, located at http://www.ifcompetition.org.
        \b[Note that, at this point, the voting deadline has passed, and
            <b>Arrival</b> placed 4th in the competition. Woo-hoo!] ";
    }
;

/*
 * The hints
 */
hint_menu: submenuItem
    title = "Hints for Arrival"
    myContents = [prologue_menu]
;

/*
 * Prologue hints
 */
prologue_menu: submenuItem
    title = "Prologue"
    myContents = [what_first]
;

what_first: topicItem
    title = "I can&rsquo;t leave the kitchen, so what can I do?"
    myContents = [
'Haven&rsquo;t you heard that good things come to those who wait?'
'The kitchen will become important later. Right now, there&rsquo;s not
 much you can do except look around and wait a bunch of turns until something
 exciting finally does happen.'
'Let me be explicit:\ type Z about twelve times and you&rsquo;ll be able
 to leave the kitchen.'
    ]
;

/*
 * House & Backyard hints
 */
house_menu: submenuItem
    title = "The House and Backyard"
    myContents = [getting_collectible purpose other_purpose]
;

getting_collectible: topicItem
    title = "I can&rsquo;t get one of my parents&rsquo; knick-knacks for the
        aliens!"
    myContents = [
'Before you can get a collectible, you are going to have to distract your
mom and your dad.'
'I&rsquo;m going to tell you how to get dad out of the room first, then
how to get mom out. In both cases, the solution involves messing up
something they work with.'
'Dad&rsquo;s big pride is the backyard. Take a look out there.'
'See those big lights? Dad sure is proud of them.'
'When Zigurt and Floban came out of their ship, did you notice them
squinting?'
'They don&rsquo;t like bright light.'
'If, after they go back into their ship, you turn up the lights,
they&rsquo;ll come out and break one of them.'
'If you tell dad about the broken light, he&rsquo;ll go out to inspect it.'
'Now for your mom. She wants you to wash the dishes, right?'
'Well, go wash a bunch of dishes.'
'Notice how that stack of clean dishes shakes?'
'If you wash enough, you&rsquo;ll be told that you can get the stack shaking
even more with a little work.'
'Once you&rsquo;ve washed about four dishes, push the stack. They will begin
to sway.'
'Now get out of the room. They&rsquo;ll fall, and mom will come running.
Just make sure not to run into her after she finds the broken dishes, as
she&rsquo;s sure to punish you.'
'Now all you need do is time it so that both mom and dad are out of the room
at the same time. Get the aliens to break one of the
lights, get the dishes to fall, and tell dad about the broken light just
as mom leaves. Then you can get one of the knick-knacks.'
    ]
;

energy_field: topicItem
    title = "How can I get past the energy field?"
    myContents = [
'The energy field blocks energy and matter.'
'It will, however, pass tachyons and high-energy neutrinos.'
'Too bad there&rsquo;s no way for you to become either.'
'In short, you can&rsquo;t get through the field. If you wait long enough,
it&rsquo;ll go away.'
    ]
;

purpose: topicItem
    title = "Where do I get the aliens their stuff?"
    myContents = [
'They listed three things: Ho-Hos, rock salt, and a memento.'
'Have you looked around the house yet?'
'All three things can be found inside.'
'Your mom can give you a hint as to where to find the rock salt and the
Ho-Hos, if you ask her about them.'
'While you&rsquo;re talking to your mom, take a look around the living
room. You should be able to find a memento for the aliens.'
'An obvious place to find the rock salt and the Ho-Hos is in the kitchen.'
'Have you looked in the cabinets?'
'The food can be found in the kitchen cabinets. For a memento, find a way
to snag one of the knick-knacks.'
    ]
;

other_purpose: topicItem
    title = "Should I give the aliens what they want?"
    myContents = [
'Have you seen old B-movies? The aliens are always up to no good.'
'In other words, you shouldn&rsquo;t run give them what they want right
away.'
'Explore the ship some and see what you can do.'
'I&rsquo;ll give you a hint:\ it has to do with disabling the ship. More
updates as the situation warrants.'
    ]
;

/*
 * Ship hints
 */
ship_menu: submenuItem
    title = "Inside the Ship"
    myContents = [plate_hint read_console remove_panel getting_book hold_hint
        console_use_hint walkthru_hint]
;

plate_hint: topicItem
    title = "What&rsquo;s this strange metal plate for?"
    myContents = [
'Have you looked at the plate?'
'It looks as if many creatures have rubbed it in the past.'
'Try rubbing the plate.'
'When you rub the plate, you will be connected to the ship&rsquo;s computer,
which will give you a map of the place.'
'Also, there is some information buried in the computer&rsquo;s spiel which
you might find useful. Read carefully.'
    ]
;

read_console: topicItem
    title = "How can I read the control console in the Bridge?"
    myContents = [
'Naturally, the aliens have labelled everything in their own language.'
'What you need is a way to translate between their language and yours.'
'Remember that book Floban had?'
'It&rsquo;s a translation book.'
'He still has it. You need to go get it from him.'
'It&rsquo;s with him in the Rec Room.'
'Once you&rsquo;ve gotten the translation book, you&rsquo;ll be able to
understand the controls on the one unlocked Bridge console.'
    ]
;

remove_panel: topicItem
    title = "How do I unlock the password panel using the colored shapes?"
    myContents = [
'You could try to unlock it by poking each of the shapes at random, hoping
to stumble across the answer.'
'However, a better way might be to be able to read the note on the panel.'
'If you don&rsquo;t know what to do to be able to read the note, perhaps
you should consult the hint about reading the control console.'
'If you&rsquo;re impatient, though, I&rsquo;ll tell you what it says.'
'In short, it says that the panel is broken, and the only way to unlock
it is to hit it.'
'Well, what are you waiting for? HIT PANEL.'
    ]
;

getting_book: topicItem
    title = "Floban won&rsquo;t let me take anything from the Rec Room
        counter!"
    myContents = [
'Floban won&rsquo;t let you take anything of his out of the Rec Room as long
as he&rsquo;s there.'
'Ergo, you must get him out of the room.'
'Stand around in the Rec Room for a while and watch what Floban does.'
'He keeps taking pills from the pill bottle.'
'You need to do something with the pill bottle.'
'Before you can do anything to the bottle, you have to be able to get it.'
'To do that, you have to be where Floban can&rsquo;t see you.'
'Take a closer look at the counter.'
'See that space behind the counter?'
'Try entering that space. Once you&rsquo;ve done that, you can play with
things on the counter with impunity.'
'Unfortunately, just taking the pill bottle won&rsquo;t get him to leave.'
'You have to do something else to the bottle.'
'Have you found anything which seems like it belongs to the pill bottle?'
'If not, you need to visit the hold. Go there before looking at the next
 clue.'
'Presumably you now have the lid to the pill bottle. Hint, hint.'
'Well, put the lid on the pill bottle while you&rsquo;re hiding in the
 space behind the counter.'
'Once Zigurt and Floban leave, you can grab the translation book.'
    ]
;

hold_hint: topicItem
    title = "Is there anything to do in the hold?"
    myContents = [
'Oh, my, yes.'
'Take a look at the junk.'
'You could probably find something if you worked at it.'
'Have you tried searching the junk?'
'Search the junk a couple of times and see what turns up.'
    ]
;

console_use_hint: topicItem
    title = "What do the controls on the Bridge control console do?"
    myContents = [
'I assume you&rsquo;ve looked at all the controls.'
'They all have to do with the ship&rsquo;s fuel tank.'
'The button opens the cover to the fuel tank&rsquo;s opening. Once you press
it, the tank will be accessible from the bottom of the ship.'
'The lever controls whether the fuel tank opening is set to intake or
outflow.'
'If the lever is set to intake, you can fill the tank through the opening.'
'The gauge records the fuel level.'
    ]
;

walkthru_hint: topicItem
    title = "Okay, I give up! How do I stop the aliens?"
    myContents = [
'Don&rsquo;t read any further until you&rsquo;re absolutely sure you are not
going to be able to figure out what to do on your own.'
'You are not going to be able to keep the aliens from taking off. Instead,
you are going to have to damage their ship so that they can&rsquo;t carry
out their plans.'
'You have access to their fuel systems using the console on the bridge.'
'If you read the ship&rsquo;s web page, you should also know that the aliens
don&rsquo;t like water.'
'To top it off, there is a faucet available in the backyard.'
'I&rsquo;ve now given you
all the elements you need to cripple the ship. You can either try to put
them together yourself, or read on to let me tell you the exact details.'
'First, get the translation book from Floban.'
'Second, get the hose from the pile of junk in the Hold. You&rsquo;ll
have to do some searching to get it.'
'Go to the Bridge. If you haven&rsquo;t taken care of the password panel,
push the button, then hit the panel which pops out of the console.'
'Push the button on the console to open the fuel
tank&rsquo;s cover, then push the lever to set the tank to <q>intake.</q>',
'In the backyard, attach the hose to the faucet, then put the hose in the
opening under the ship.'
'Turn on the faucet to fill the fuel tank with water and you&rsquo;re
done. The saucer will now explode shortly after takeoff.'
    ]
;

