*****************************************************************************
**                                                                         **
**            DISTRESS: Version 1.7 Walkthrough and Solutions              **
**                      Written by Mike Snyder (C) 2005                    **
**                                                                         **
*****************************************************************************

 This document has been divided into five parts, for your convenience.

    1) Walkthrough

        A "chatty" solution to the game. It points out the in-game cues
        that are meant to spur you to the correct actions as you play.

    2) Typical Run

        This is a solution based on the walkthrough above. If you cut and
        paste it into a .REC text file, Hugo's PLAYBACK command will even
        run through the entire thing, solving the game command by command.
        Actually, this could be called the "ideal" run instead.

    3) Speed Run

        This is another solution compatible with Hugo's PLAYBACK command,
        but it doesn't take a realistic approach to solving the game. It
        does just the bare minimum - assuming prior knowledge -- to win.

    4) Comments

        I have included some additional comments that might be of interest,
        especially after you beat the game. I mention some alternate verb
        phrasing, some optional actions, and I discuss some about how the
        game works (how/why things happen when they do, and so forth).

    5) Game Map

       A text map of the game area, small though it is, has been included.


******* 1: WALKTHROUGH ******************************************************


 As you get started, be sure to read and understand your surroundings. Most
 things have "examine" (or "x" or "look at") descriptions, and often, parts
 of first-level objects can be further examined. You can probably spend too
 many turns just familiarizing yourself with everything around, but at least
 the first time through, it's probably worthwhile.

 In particular, you'll want to look at the pod wreckage, Covegn, Huchess,
 the rocks in the distance, the hatch, the beacon post, the crash netting,
 and the rod (heating core spike). You can even look at the ground, the
 sky, and in various directions, but that's not generally necessary.

 Also, be sure to examine yourself. You'll want to know who you are, right?

 Notice, when looking at the beacon, that you didn't turn on the distress
 signal. Your first inclination may be to do so -- and you should.

 When you examine the pod wreckage, you'll notice sharp edges. This is
 meant to cue you to one of two possible solutions to a puzzle, shortly.

 When you examine (or search) the netting, you'll find a piece that you
 can take. If you searched, you'll take it automatically. For convenience,
 a search is implied if you just try taking the netting before finding the
 smaller piece. Look at it, after you have it.

 When you examine Huchess, you get a strong cue to remove the rod from his
 shoulder, and a tip that you'll need a way to bandage the wound. Trying to
 examine the spike directly will further urge you in the right direction.

 If you haven't found the piece of netting yet, you might be inclined to try
 taking back the bandages (made from your uniform) mentioned in the intro.
 Or, you might try using Covegn's or Huchess's uniform for additional
 bandages. You might even try removing your undersuit. Those things can be
 referenced, but the puzzle -- while not really difficult -- is not this.

 Now that you have netting, and you've examined it for a clue that it's like
 fabric, you might already know what to try next. Take the spike from the
 Lieutenant's shoulder (just GET-ing it is easiest, but you can also pull it
 from Huchess, remove it from his shoulder, take it out of his wound, etc).

 Moment by moment (more accurately, turn by turn), Huchess has been getting
 a little worse. Assuming you remove the spike without waiting until he is
 already almost dead, he'll suddenly get a LOT worse. You just have a few
 turns to take action.

 Again, there are various phrasing for bandaging his wound, ranging from
 "put... on..." to "bandage shoulder with..." to "tie... around..." Unless
 you have already tried using the netting for another purpose, this may be
 the first time you're clued to the fact that it's too big to work with.
 but it's a fabric, after all. Its description, showing that this piece was
 previously ripped along its edges, might be enough to plant the right seed.

 You'll need to rip or cut it further. You can do this now, or before you
 even pull the spike, if you tear it on the sharp edges (of the wreckage).
 However, the spike works well enough for the purpose, too, and even though
 you don't have many turns to bandage Huchess, you can still do it now. Just
 wrap the resulting ribbons (note that you won't use them all - some remain)
 around his wounds, and now Huchess is stable.

 Now that you have the spike, examine it. Try turning it on (or pushing the
 lever). If you used it to cut the netting, you've established that it's
 at least sharp enough to cut or tear things. But now you know it can get
 too hot to hold as well -- another, very particular use. Don't worry that
 there seems to be no way to keep it on right now.

 Meanwhile, you have probably heard howling from the east. You might be
 inclined to wait around for something to happen -- especially if this is
 not your first play-through, or if you feel stuck and think that you're
 supposed to confront the creature so soon. As much of an annoyance as it
 may be that "wait" is restricted, it's really for your own good. Check the
 "comments" section for a little more about what I mean, and why the "wait"
 command is restricted even though it's bound to irk many players.

 If you looked at the rocks and spires in the distance, you'll know that the
 closest are to the south. You can find a large arch now, by going that way.
 However, at this point, you don't need to. If you do, you can at least get
 further clues that will help you later, but that's your call. What the rock
 has to offer, you don't need yet, so it doesn't matter. If you do, return to
 the north when you're done.

 When you examine the hatch (or look under it, or even search), you'll see
 Covegn's palmtop terminal. You won't find it by just looking at Covegn (it
 was out of view until you took a more active approach, or focused your
 efforts on the hatch), but you *can* also find it by searching her. If
 the thought never occurred to you, don't worry. A later event would have
 brought it into the open, even if you had done nothing.

 It's not important at this point, but you'll probably want to try turning
 it on at least once. It helps provide an incentive later, to head to the
 northern crash site, even though early attempts will report that you don't
 have a reason (yet) to do so. This is basically half of a clue.

 If you've spent enough time on looking around and helping Huchess, you may
 notice that a sheet of vellum blows away from an unseen spot among the
 scattered scraps of netting. If you saw this on prior play-throughs, you
 might be inclined to search the netting, finding it early. That works, if
 you already took a piece of netting (otherwise, that's what you find first).
 Regardless, it's going to blow away. Finding it again is the puzzle.

 Don't worry if it blew away on its own (you didn't search to find it), and
 the message was lost among the other events that happen while you play.
 It's important enough that reminders will appear periodically.

 Head west (now that there is a reason), to discover that you can't see
 anything out in the darkness. You can try getting the vellum (even though
 it's dark, and finding it is impossible) for another clue. You need a light.

 Return east to the crash site. Did you already look at the rocks and spires
 in the distance? It's not required, but it's a hint as to why you can go
 south, and what the significance may be. Once you go south, there isn't much
 doubt. You come upon a rock arch, and that's all you'll find there.

 Examine it. This could be done earlier, even before the vellum blows away,
 if you prefer. In fact, it's probably more likely that you'll go south in
 the process of experimentation, discovering the nature of the rock, than it
 is that you'll wait until now. Anyway, Covegn's research is important.

 If you try to get the whole rock (not that you would), you'll get a clue
 disguised in a "you can't do that..." kind of way. More importantly, the
 cracks are a clue. You can get a shard from the rock in a number of ways,
 all involving the spike. Trying to hit the rock without using anything is
 a prompt in the right direction. Hit it with the spike, or chisel it, or
 even cut it, or pry the cracks, or... you should be able to figure it out.

 You now have all you need from there, so return north to the crash site.

 The shard is a very slight glow, which further supports the clues you may
 already have noticed. Somehow, this shard may be used as a light source.
 The key bit is Covegn's research -- the shard can convert direct heat into
 light. You can try putting it on the beacon post, but the beacon isn't hot.

 If you already pushed the spike's lever (or alternately, tried to turn on
 the spike, which works too), you know it can get hot. If you haven't, then
 it should still make sense, since it's a spike from the pod's heating core.
 The spike and the shard are a perfect match -- you need something capable
 of holding down the spike's lever to heat it up, and you need direct heat
 to make the shard glow. Tie netting to the spike and to the shard (several
 ways to do this, including implicitly tying the shard to the spike, if you
 have netting ribbons in your inventory). Now the shard will glow, and you
 can carry the pair around by the strip of netting.
 
 Go west and retrieve the lost vellum. Read it, and return to the east (or
 return to the east, and then read it).

 By now, you will probably have noticed one or more "phantoms" -- strange
 happenings that don't seem to be real, but which depict seemingly real
 events. The latest phantom has shown Huchess, not long after the crash,
 trying to get your attention. The vellum -- which you now have -- was taken
 by the wind and lost in the strewn netting. You have his decryption code
 now, or at least part of it. This is the other half of a clue -- the first
 coming when you tried to turn on the palmtop terminal.

 In short, you now have a good enough reason to make the trip to the north.
 If you can get within range of a PrimeCom console -- knowing that there
 might still be one aboard the wrecked Sirius Dream -- the terminal may work.
 If so, you may be able to decrypt the message on the vellum -- the message
 the phantom Huchess seemed to think was important enough to share.

 North of the crash site, you have an opportunity to turn back. Did you
 forget anything? You should have the spike/shard combo for light (if you
 don't, you can't go any farther), the few netting ribbons that remain,
 the sheet of vellum, and the palmtop terminal. Huchess should still be
 alive, even though the dead body of Covegn has by now been taken. You did
 remember to turn on the distress signal, right? If you didn't, a further
 clue is given here, which may prompt you to take care of it before you go.

 This is a pivotal point. You can continue if those things aren't all true,
 but you'll be on a plot branch that will ultimately end in your demise, no
 matter what else you might do from this point forward. Even if you do, you
 may at least pick up on clues that give insight into what you might have
 done differently, which will help the next time around. For the purposes of
 describing the ideal session, be sure you've done everything.

 When you go north again, the creature will bound into view, and it's on
 the offensive. If you've encountered it already, you probably know what to
 expect. If not, now is a good chance to get your first "look" at it. At any
 rate, this is a tightly-timed part, and unless you've been  very observant
 or you're going strictly by this walkthrough, you may not survive this
 encounter the first couple of times. It's a puzzle, after all.

 Try to get away by going north. You'll find that it's not possible with the
 creature so near and so alert. You've been given a possibly subtle cue,
 though, that you could try turning the tables by going on the offensive.
 Try stabbing it with the spike. You can't, because it's still tied to the
 shard and hot -- you can't touch it. So, untie the spike so it will cool,
 and then try. This works, and now the creature is momentarily confused.

 Go north until the creature catches up again (three times north). The shard
 is beginning to fade, but as long as you haven't been sight-seeing along
 the way, you can stab the creature again and then continue on to the
 northern wreckage. The creature will keep its distance now -- for a time.

 Now that you're here, check to see if the terminal will come on. It does,
 but only for a moment, because it isn't charged and the slot for its
 reserve cell is empty. If you looked at the scraps and debris before this,
 you will have been clued to finding something there, once you are in need
 of something in particular (otherwise, you'd likely never spot one useful
 thing out of so much junk). Even if you didn't, look now (or even search
 it). Something useful is indeed found in the debris -- a power cell.

 Put it into the terminal (or the slot) to provide power. You do have
 another option here, but it's more difficult and it stops working after a
 couple of times. You could tie the shard to the spike again (so it glows),
 untie it, and hold the shard to the solar receptor (on the terminal). This
 will bring it a slight, temporary charge.

 By this point, you may also have checked out the rest of your surroundings:
 the huge, burning wreckage of the Sirius Dream and the puddle of fuel in
 particular. You can try taking the fuel, or interacting with the puddle in
 other ways (try throwing things into it), but it's not important yet. Just
 know that it's there, and what it might help with later.

 Turn on the terminal. The instructions are clear: touch the screen now to
 activate the menu. You have six options from which to choose. The first
 option will never work for you -- sorry. It's not so much a red herring, as
 a means of showing that the terminal probably has a host of features that
 would only be available to the command crew (otherwise, it's not a very
 useful device). Remember the decryption code is not an access code.

 You can try decrypting the vellum now (option 3). Huchess's code was not
 complete, so that won't work. Provided you turned on the distress signal,
 though, you can monitor the other crash site (option 2). The terminal has
 been damaged, so you're going to have to touch the screen again, to return
 to the main menu each time. If Huchess is still alive (and he will be, if
 he was alive when you left -- the creature followed you away), you'll see
 him wake up for a moment. He'll notice the distress signal is on, so he's
 going to try communicating, with the hopes that somebody is coming to the
 rescue and will recognize what he's trying to say.

 He falls unconscious again, but you now have the complete code. Use option
 3 again, to decrypt the message. This requires manually typing in the full
 message (thankfully, it's simply implied that you take several minutes to
 do so, without requiring further action on your part). The creature is
 going to get restless, and it will choose this time to attack. If you have
 waited too long, it may have attacked earlier, at which time it wasn't
 quite so frantic and will not be in a position to make its death possible.

 When it attacks now, though, it's going to step in the puddle of fuel. You
 have a couple of turns to dispatch it, by igniting the fuel. If you haven't
 already tied the shard back to the spike, do so now. Toss it into the
 puddle, or at the creature, and he'll go up in a blazing fireball. If you
 wait too long, he's out of the fuel, and you're going to die.

 You could try stabbing the creature instead, then making a break south, to
 get away from it. The problem with that is, you will need to untie the spike
 here, which means the shard will begin to dim. Plus, you may find that after
 you stab the creature twice, it gets wise to the tactic. What this means is,
 it's not possible to make it back to the southern wreckage alive.

 The creature is dead, but it left you wounded. Remember how you helped
 Huchess? Wrap or tie netting around your wounds (or, in general, around
 yourself), or "bandage" the wounds. Don't take long, or you won't survive.

 If you experimented more with the terminal already, or if you do so now, you
 will have noticed that some of the options don't work at all. The cue here
 is that the capacitive sensitivity is diminished -- but maybe it will still
 respond to pressure (the resistive underlay), such as that from a stylus.

 By its death, the creature has solved this problem. One of its fangs has
 cracked and fallen to the ground. Get it, and use it to touch the screen.
 If you don't specify that you're touching with the tooth, though, it's not
 implied. Once you do that, you have access to all menu options (except the
 first one), and you're moments away from the truth.

 Decryption will finally work, and now you know why the Captain changed
 course to come here. If it's not clear, yes -- you caused a paradox.

 How? Try option 5 on the terminal, for further information. This should
 leave very little unanswered. For fun, check the crew roster (option 4),
 but at this point, you've finished what you came here for.

 The only thing left to do is to monitor the video from the other crash site
 again. As this is probably not the most logical of actions at this point,
 you're cued to it. If you try going south now, you're encouraged to use the
 distress signal as a means of monitoring the other site, since you're still
 in no shape to make the long hike. If it doesn't occur to you to try going
 south now, that's cued as well. The immediate danger is over, so you may
 feel inclined to seek something to do. Periodically, you'll hear noises from
 the distant south. This encounter is almost over.

 At the menu, select option 2. What follows is the "best" ending possible.
 Yeah, it's bleak, but it's also hopeful -- and at least you're still alive.


******* 2: TYPICAL RUN ******************************************************


 The following is intended to show a logical solution to the game. It's a
 longer session than the speed run, but it demonstrates the actions that
 you might realistically take, in order to solve the game. At the core,
 this is a game meant to be played more than once, striving for survival.
 However, this run shows a best-case scenario play-through, where it all
 falls into place by keen observation and impressive intuition.

 NOTE: To make this solution work with the Hugo "PLAYBACK" verb, a special
       implementation of "TOUCH" was used when selecting terminal options.
       This skips the terminal menu entirely, by using TOUCH OPTION (NUM).

 X ME
 X WRECKAGE
 X COVEGN
 X HUCHESS
 X SPIKE
 X ROCKS
 S
 X ARCH
 N
 X BEACON
 TURN ON SIGNAL
 X HATCH
 GET TERMINAL
 TURN IT ON
 X NETTING
 REMOVE SPIKE FROM SHOULDER
 GET NETTING
 BANDAGE WOUND WITH NETTING
 CUT NETTING WITH SPIKE
 TIE NETTING AROUND SHOULDER
 X SPIKE
 PUSH LEVER
 GET SPIKE
 W
 GET VELLUM
 E. S.
 X CRACKS
 PRY CRACKS WITH SPIKE
 N
 PUT SHARD ON POST
 TIE NETTING TO SPIKE
 TIE SHARD TO SPIKE
 W
 GET VELLUM
 READ IT
 E
 TURN ON TERMINAL
 N. N.
 X CREATURE
 N
 STAB CREATURE WITH SPIKE
 REMOVE NETTING FROM SPIKE
 STAB CREATURE
 N. N. N.
 STAB CREATURE
 N. N. N.
 X DEBRIS
 X PUDDLE
 GET FUEL
 TURN ON TERMINAL
 X DEBRIS
 GET CELL
 PUT IT INTO SLOT
 TURN ON TERMINAL
 TOUCH OPTION 3
 TOUCH OPTION 2
 TOUCH OPTION 3
 TIE SPIKE TO SHARD
 DROP SPIKE INTO PUDDLE
 X ME
 WRAP NETTING AROUND MY WOUNDS
 X CREATURE
 GET TOOTH
 TOUCH OPTION 3 WITH TOOTH
 TOUCH OPTION 4 WITH TOOTH
 TOUCH OPTION 5 WITH TOOTH
 S
 TOUCH OPTION 2 WITH TOOTH


******* 3: SPEED RUN ********************************************************


 The following is intended to show a quick solution to the game, relying on
 information that ordinarily wouldn't present itself without more examining
 and experimentation. Basically, this is an expert solution -- a speed run.

 NOTE: To make this solution work with the Hugo "PLAYBACK" verb, a special
       implementation of "TOUCH" was used when selecting terminal options.
       This skips the terminal menu entirely, by using TOUCH OPTION (NUM).

 GET NETTING
 CUT IT ON EDGES
 GET SPIKE
 WRAP WOUND
 PUSH BUTTON
 S
 HIT ROCK WITH SPIKE
 TIE SHARD TO SPIKE
 N
 SEARCH COVEGN
 TURN IT ON
 SEARCH NETTING
 W
 GET VELLUM
 READ IT
 E. N. N.
 UNTIE SPIKE
 STAB CREATURE
 N. N. N.
 STAB CREATURE
 N. N. N.
 TIE SHARD TO SPIKE
 TURN ON TERMINAL
 SEARCH DEBRIS
 PUT CELL IN TERMINAL
 TURN ON TERMINAL
 TOUCH OPT 2
 TOUCH OPT 3
 THROW SPIKE AT CREATURE
 BANDAGE ME
 GET FANG
 TOUCH OPT 3 WITH FANG
 TOUCH OPT 5 WITH FANG
 TOUCH OPT 2 WITH FANG


******* 4: COMMENTS *********************************************************


 -- For convenience, Lieutenant Huchess can be referred to as "man" and
 Ensign Covegn "woman". Of course, once referenced, "him" and "her" work too.

 -- I found that the "animated" version of the terminal menu didn't work
 quite right in some versions of Hugo, so it's disabled whenever graphics
 are disabled (regardless of the platform). An undocumented feature also
 exists, to make it possible to "PLAYBACK" a .REC file by not requiring
 that the menu appear at all (see earlier). You can even turn the animated
 menus on or off if needed, by typing "SETMENU ON" or "SETMENU OFF".

 -- More complex actions do provide a variety of recognized commands. For
 instance, you can simply get the spike, or remove it from Huchess, pull it
 from his wound or his shoulder, etc. There are various ways to tie the spike
 and the shard together, ranging from the one-liner "tie shard to spike"
 (if you have the netting ribbons), to wrapping netting around the spike
 first and then tying the shard in later. The same goes for bandaging the
 spike wound, getting a shard, etc.

 -- Chances are, most "guess the verb" situations will be the result of
 trying something that just won't work, no matter *how* you try rephrase it.
 I have implemented as much "extra" stuff as I could in the time allowed,
 based on beta logs

 -- Also "touch anywhere on terminal" does work. :)

 -- Early versions of Distress were a frustration to beta testers, because
 it became obvious that the creature would eventually appear by waiting. Many
 aspects of the game weren't clued as well (and there were no hints), so
 this seemed like the only thing that would move things forward. But when
 the creature appears -- except at the end -- you can't kill it. So, waiting
 was forcing a confrontation that could only lead to failure. With that in
 mind, I restricted "wait" to make it more obvious that waiting isn't the
 answer. This was also a frustration, because it still seemed important for
 the creature to appear, but now it was harder to force. In the end, I left
 the "wait" restrictions, but I tried to give enough in-game cues and hints
 to (hopefully) keep players from getting so hopelessly stuck that waiting
 for the creature seemed like the right course of action. I hope it works.

 -- The idea was that players should be encouraged to survive -- not go up
 against this creature so soon. At any rate, cues are meant to show this.
 Also, nothing important happens that can only happen by waiting, as the
 Speed Run should show.

 -- The game is meant to be fair, by providing clues and cues that should
 make wrong actions hint at the correct ones. However, it wasn't meant to
 always be winnable -- only to help the player understand what actions might
 help make it winnable. I know it would be a more popular game if this were
 not the case, but the game was meant to convey a sense of urgency,
 consequences, and difficulty. I don't think those things would be possible
 if it was impossible to die, or if it were always possible to win, no matter
 what. For this, I think Distress is likely to be a love-it-or-hate-it game.

 -- To some degree, I think we as IF players have grown soft. :)

 -- Timing plays an important part in the game. While at the crash site, the
 creature comes closer only once very five turns (and it doesn't always make
 itself known -- just periodically). When you are away from the crash site,
 it's much bolder. Every turn brings it a little closer. It will always go
 for Covegn first. The only way you can die that early is to antagonize it.
 It comes back after that, and sooner, since it's not as far away as before.
 The second time, it'll take Huchess -- whether he's already dead or not.
 Even though it won't kill you yet (unless, again, you keep stabbing it), if
 you reach this point, you'll be unable to "win" the game later. Huchess is
 still key to decrypting the vellum.

 -- Some things can be found early, by searching. The game was designed to
 not require it, though. If Covegn is taken by the creature, the terminal is
 left behind, and now it's moved enough that you notice it in the room. After
 a few turns, the vellum will blow away if you haven't yet found it.

 -- This was a game I had in mind for many years. I had never worked out the
 details, but I knew that it would involve survival after crash-landing on
 an alien planet. I also knew the ending. In fact, that was the hook -- the
 point of the story -- the twist. The original concept, though called for
 more survival and little or no horror. After working on it night after night
 from sundown to almost sun-up (the joys of being a new parent), I realized
 that the game was darker, more sinister, and without a truly happy ending.

 -- A mistake I made with last year's "Trading Punches" was to rely too much
 on subtlety. Even after beating the game, some players didn't catch on to
 the true nature and origin of the Incenders -- or understand that Gavenn's
 father wasn't killed *by* the dactylworm. I tried to be sure, with Distress,
 that the ending not only resolved the story, but also explained just how
 it all came to pass. That's where Covegn's research, seen near the end,
 came about. It's hard to say if the explanation will make the experience
 better, or merely downplay what might have been a mystery when the vellum
 is finally decrypted. I'm interested to find out how that worked for people.

 -- The biggest controversy, if I'm guessing, will probably be the ability
 to make the game unwinnable, and require restarting. Well -- if you didn't
 save earlier in a good state, it will require restarting. But the game is
 short, and in very few moves it's easy to catch up (see Section #3, the
 Speed Run). All in all, I hope the positive reviews outweigh the negative.


******* 5: GAME MAP *********************************************************

      Be sure you're using a fixed-width font when you view this map.

    +-------------------------------------------------------------------+
    |                                                                   |
    |                            (Sirius Dream Wreckage)                |
    |                                    |                              |
    |                                    O (Chase Stop #6)              |
    |                                    |                              |
    |                                    |                              |
    |                                    O (Chase Stop #5)              |
    |           N                       /                               |
    |                                  |                                |
    |           ^                      O (Chase Stop #4)                |
    |           |                      |                                |
    |     W <---o---> E                |                                |
    |           |                      O (Chase Stop #3)                |
    |           v                     /                                 |
    |                                |                                  |
    |           S                    O (Chase Stop #2)                  |
    |                                |                                  |
    |                                |                                  |
    |                                O (Chase Stop #1)                  |
    |                               /                                   |
    |                               |                                   |
    |                          (Trench Begins)                          |
    |                               |                                   |
    |                                \                                  |
    |                                 |                                 |
    |        (West)______             |                                 |
    |        (Area)      \_____(Pod Four Wreckage)                      |
    |                               |                                   |
    |                               |                                   |
    |                                \                                  |
    |                             (Nearest Rock)                        |
    |                                                                   |
    +-------------------------------------------------------------------+
