##########################################################################
#
#
# Little girl in the big world. An Interactive Fiction story file.
# Designed to be compiled and run with StoryFactory.
#
# Written and declared public domain by Peter Wendrich 2003.
#
#
##########################################################################
#
# Process verbs
#
##########################################################################

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseAsk {
  _assumePlayer
  isActorAlice /if
  /else
    findNoun
    /get $noun /if
      /get $noun /to $actor 
    /else
      &objectAlice /to $actor
    /then
    /dup /fetch &about /eqif
      [+1]
      findNoun
      &tell /to $verb
    /else
      /dup /fetch &to /eqif
        [+1]
        parseVerb
      /then
    /then    
  /then

}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseBite {
  _assumePlayer
  &bite /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseClimb {
  _assumeAlice
  /dup /fetch &on /eqif
    [+1]
    &climbon /to $verb
    findNoun
  /then  
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseClose {
  _assumeAlice
  &close /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseDrop {
  _assumeAlice
  &drop /to $verb
  findNoun
}

sub parseEnter {
  _assumePlayer
  &enter /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseExamine {
  _assumePlayer
  /2 /to $hint_look
  &examine /to $verb
  findNoun
#  /drop

}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseFill {
  _assumeAlice
  &fill /to $verb
  /dup /fetch &up /eqif [+1] /then
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseGet {
  _assumeAlice
  /dup /fetch &on /eqif
    [+1]
    &climbon /to $verb
  /else
    &get /to $verb
  /then
  findNoun
}


#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseHint {
  &_hint /to $action
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseJump {
  _assumeAlice
  /dup /fetch &on /eqif
    [+1]
    &jumpon /to $verb
    findNoun
  /else
    &jump /to $verb
  /then
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseKiss {
  _assumeAlice
  &kiss /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseLook {
  _assumePlayer

  # look at -> examine
  /dup /fetch &at /eqif
    [+1] parseExamine
    /ret
  /then

  /get $hint_look /nif
    /1 /to $hint_look
  /then
  /dup /fetch &in /eqif
    [+1]
    &lookin /to $verb
    findNoun
  /else
    /1 /to $showExits
    &look /to $verb
    # allow ` look around '
    /dup /fetch &around /eqif [+1] /then
    /get $actor _findRoom /to $noun
  /then
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseMove {
  _assumeAlice
  &move /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseNibble {
  _assumePlayer
  &nibble /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseOpen {
  _assumeAlice
  &open /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parsePlay {
  _assumeAlice
  /dup /fetch &with /eqif [+1] /then
  &play /to $verb
  
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parsePlug {
  _assumeAlice
  # allow ' plug in '
  /dup /fetch &in /eqif [+1] /then
  &plug /to $verb
  
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parsePull {
  _assumeAlice
  &pull /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parsePush {
  _assumeAlice
  &push /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parsePut {
  _assumeAlice
  /dup /fetch &on /eqif
    [+1] &wear /to $verb
    findNoun
  /else
    findNoun
    /dup /fetch &on /eqif
      [+1] &putxon /to $verb
      findSecond
    /else
      /dup /fetch &in /eqif
        [+1] &putxin /to $verb
        findSecond
      /else
        &drop /to $verb
      /then
    /then
  /then
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseRead {
  _assumePlayer
  &read /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseStand {
  _assumeAlice
  /dup /fetch &on /eqif
    [+1]
    &climbon /to $verb
    findNoun
  /then  
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseTell {
  _assumeAlice
  /dup /fetch &about /eqif
    [+1]
    &tell /to $verb
    findNoun
  /then
}


#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseTurnOn {
  _assumeAlice
  &turnon /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseTurnOff {
  _assumeAlice
  &turnoff /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseTurn {
  /dup /fetch &on  /eqif [+1] parseTurnOn  /ret /then
  /dup /fetch &off /eqif [+1] parseTurnOff /ret /then

  _assumeAlice
  /dup findNoun
  /dup /fetch &on  /eqif [+1] &turnon  /to $verb /swap /drop /ret /then
  /dup /fetch &off /eqif [+1] &turnoff /to $verb /swap /drop /ret /then
  /drop
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseScore {
  &printScores /to $action
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseWake {
  _assumePlayer

  # allow ' wake up '
  /dup /fetch &up /eqif [+1] /then
  
  &wake /to $verb
  findNoun

  # allow ' wake ... up '
  /dup /fetch &up /eqif [+1] /then

  # make actor target if no other target
  #_nonoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseWatch {
  _assumeAlice
  &watch /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseUndress {
  _assumeAlice
  &undress /to $verb
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseWear {
  _assumeAlice
  &wear /to $verb
  findNoun
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseXyzzy {
  &showXyzzy /to $action
}

#
# compass
#
sub _downString {
  d
}
sub parseDown {
  _assumePlayer
  &d /to $verb
  &_downString findNoun /drop
}

sub _upString {
  u
}
sub parseUp {
  _assumePlayer
  &u /to $verb
  &_upString findNoun /drop
}

sub _northString {
  n
}
sub parseNorth {
  _assumePlayer
  &n /to $verb
  &_northString findNoun /drop
}

sub _eastString {
  e
}
sub parseEast {
  _assumePlayer
  &e /to $verb
  &_eastString findNoun /drop
}

sub _southString {
  s
}
sub parseSouth {
  _assumePlayer
  &s /to $verb
  &_southString findNoun /drop
}

sub _westString {
  w
}
sub parseWest {
  _assumePlayer
  &w /to $verb
  &_westString findNoun /drop
}

sub compassTable {
# compass
  down    parseDown
  up      parseUp
  north   parseNorth
  east    parseEast
  south   parseSouth
  west    parseWest
  d       parseDown
  u       parseUp
  n       parseNorth
  e       parseEast
  s       parseSouth
  w       parseWest
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseGo {
  /dup [+1] /over /fetch &compassTable _switchTable /if
    /swap /drop
  /else
    /drop
  /then
}

#
# verb , parse word
sub verb_table {  
  about   parseAbout
  ask     parseAsk
  bite    parseBite
  climb   parseClimb
  close   parseClose
  drop    parseDrop
  enter   parseEnter
  examine parseExamine
  fill    parseFill
  get     parseGet
  go      parseGo
  help    parseAbout
  hint    parseHint
  jump    parseJump
# hit
# kill
  kiss    parseKiss
# lick
  look    parseLook
  move    parseMove
  nibble  parseNibble
  open    parseOpen
  play    parsePlay
  plug    parsePlug
  pull    parsePull
  push    parsePush
  put     parsePut
  read    parseRead
# shake
  score   parseScore
  stand   parseStand
  switch  parseTurn
  tell    parseTell
  toggle  parseTurn
  turn    parseTurn
  turnon  parseTurnOn
  turnoff parseTurnOff
  undress parseUndress
  wake    parseWake
  watch   parseWatch
  wear    parseWear
  walk    parseGo
  xyzzy   parseXyzzy

# shortcuts
  l       parseLook
  x       parseExamine
}

#
# ( parsepos -- parsepos )
sub parseVerb {
  /dup [+1] /over /fetch &verb_table _switchTable /if
    /swap /drop
  /else
    /drop parseGo
  /then
}
