##########################################################################
#
#
# Little girl in the big world. An Interactive Fiction story file.
# Designed to be compiled and run with StoryFactory.
#
# Written and declared public domain by Peter Wendrich 2003.
#
#
##########################################################################
#
# Alice's bedroom
#
##########################################################################


#
# input
#   addr of parent
# output
#   object hold by parent
#
sub holdingObject {
  &objectWorld /do
    /dup /0 /neqwhile
    # check if object is child of parent
    /over /over [+1] /fetch /eqif
      /swap /drop /ret
    /then
    /fetch
  /loop
  /swap /drop
}


#
# input
#   addr of parent
# output
#   object hold by parent
#
sub wearingObject {
  &objectWorld /do
    /dup /0 /neqwhile
    # check if object is worn by parent
    /over /over [+2] /fetch /eqif
      /swap /drop /ret
    /then
    /fetch
  /loop
  /swap /drop
}


object objectAliceBedroom {
  name: bedroom room
  location: objectWorld
  run {
    /dup &look /eqif
      Alice's bedroom ^ ^
      a typical girl's bedroom with bright colors like pink and yellow and plenty of toys scattered around .
      /self _look_child
      /drop /tret
    /then
    /dup &name    /eqif Alice's bedroom /drop /tret /then
    /drop /fret
  }
}

object objectAliceBed {
  name: bed
  location: objectAliceBedroom
  run {
    /dup &climbon /eqif
      isActorAlice /if
        &ALICE_standingOnBed changeMode
        /drop /tret
      /then
    /then
    /dup &look /eqif
      a bed with a large wooden drawer stands in the southwest corner .
      /self _look_child
      /drop /tret
    /then
    /dup &name /eqif the bed /drop /tret /then

#    /dup &examine /eqif
#      a small wooden table is attached to the bed .
#      /drop /tret
#    /then
    /drop /fret
  }
}

object objectOpenDrawer {
  name: large wooden drawer
  location: objectVoid
  run {
    /dup &close /eqif
      isActorAlice /if
        &ALICE_openDrawerBed changeMode
        &objectVoid /self [+1] /store
        &objectAliceBedroom &objectClosedDrawer [+1] /store         
        done .
        /drop /tret
      /then
    /then
    /dup &examine /eqif
      the drawer is open . ^
      /self holdingObject /if
        in the drawer you see : /self _look_child
      /else
        the drawer is empty .
      /then
      /drop /tret
    /then
    /dup &name /eqif the large wooden drawer /drop /tret /then
    /dup &open /eqif
      isActorAlice /if
        the drawer is already open .
        /drop /tret
      /then
    /then
    /dup &tell /eqif
      isActorAlice /if
        `` it contains my clothes '', says Alice .
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

object objectClosedDrawer {
  name: large wooden drawer
  location: objectAliceBedroom
  run {
    /dup &close /eqif
      isActorAlice /if
        the drawer is already closed .
        /drop /tret
      /then
    /then
    /dup &examine /eqif the drawer is closed . /drop /tret /then
    /dup &name /eqif the large wooden drawer /drop /tret /then
    /dup &open /eqif
      isActorAlice /if
        &ALICE_openDrawerBed changeMode
        &objectVoid /self [+1] /store
        &objectAliceBedroom &objectOpenDrawer [+1] /store         
        done .
        /drop /tret
      /then
    /then
    /dup &tell /eqif
      isActorAlice /if
        `` it contains my clothes '', says Alice .
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

object objectTableAliceBedroom {
  name: small wooden table
  location: objectAliceBedroom
  run {
    /dup &examine /eqif
      /1 /to $hintExamineTable
      a small table to place some small objects on . /self _look_child
      /drop /tret
    /then
    /dup &look    /eqif a small wooden table stands next to the bed . /drop /tret /then
    /dup &name    /eqif the small wooden table /drop /tret /then
    /drop /fret
  }
}

object alarmClockBroken {
  name: broken digital alarm - clock alarmclock radio watch
  location: objectVoid
  sub _AliceSaysBroken {
    with a annoyed voice Alice declares : `` that is not funny , it is broken you know ! ''
  }
  run {
    /dup &examine /eqif isActorAlice /if _AliceSaysBroken /else small pieces of glass and plastic and some wires connected to what is left of the alarm-clock can be found under the table . /then /drop /tret /then
    /dup &look    /eqif a broken alarm-clock lies in pieces under the table . /drop /tret /then
    /dup &name    /eqif the broken alarm-clock /drop /tret /then
    /dup &plug    /eqif isActorAlice /if _AliceSaysBroken /else better not connect this pile of junk to the mains . /then /drop /tret /then
    /dup &push    /eqif isActorAlice /if `` I will not touch it '', says Alice , `` looks very dangerous and scary with all these metal and glass parts . '' /else better leave it where it is . it might have sharp edges . /then /drop /tret /then
    /dup &read    /eqif isActorAlice /if _AliceSaysBroken /else it is impossible to read the display , because the alarm-clock is transformed into a abstract piece of art consisting of glass , copper and plastic fragments . /then /drop /tret /then
    /dup &turnoff /eqif isActorAlice /if _AliceSaysBroken /else we can be pretty sure it is already off . /then /drop /tret /then
    /dup &turnon  /eqif isActorAlice /if _AliceSaysBroken /else in the current state the alarm-clock is in , you would be very surpriced if it would ever going to work again . /then /drop /tret /then
    /drop /fret
  }
}

object alarmClock {
  name: digital alarm - clock alarmclock radio watch
  location: objectTableAliceBedroom
  sub _alarmClockExamine {
    a fairly standard digital clock with alarm function and AM/FM radio . you can not recall ever hearing the alarm and wonder what it sounds like . it could be a high pitched sound or a boring dull hum .
    probably it is a dull hum , because that is easy to generate by using the alternating frequency of the power line to drive the speaker normally used for the radio . however it may use the radio instead , to wake up it's owner . without turning the alarm on however , you will never know .
  }
  sub _alarmClockMove {
    /self [+1] /fetch &objectTableAliceBedroom /eqif
      the alarm-clock drops from the table and with a loud bang it hits the ground .
      &objectVoid /self [+1] /store
      &objectAliceBedroom &alarmClockBroken [+1] /store
      &ALICE_sitOnBed changeMode
      naughtyScore
#      /get $aliceMode /nif Alice wakes up due to the loud sound next to her bed . /then
#      &ALICE_sitOnBed /to $aliceMode
    /then
  }
  sub _alarmClockLook {
#    /self [+1] /fetch &objectTableAliceBedroom /eqif
      a alarm-clock can be seen on the table .
#    /then
  }
  sub _alarmClockTurnon {
    /1 /to $hintTurnOnAlarm
    after pressing some of it's buttons it becomes apparent that the alarm-clock is not going to work .
    closer inspection reveals some blank copper at the end of the powercable , obviously somebody has been chewing on this cable .
    ofcourse you feel really innocent and have absolutely no idea who that can be . . .
  }
  run {
    /dup &bite    /eqif it tastes funny . /drop /tret /then
    /dup &examine /eqif _alarmClockExamine /drop /tret /then
    /dup &look    /eqif _alarmClockLook /drop /tret /then
    /dup &move    /eqif _alarmClockMove /drop /tret /then
    /dup &name    /eqif the alarm-clock /drop /tret /then
    /dup &plug    /eqif that could be very dangerous with that damaged power cord . /drop /tret /then
    /dup &push    /eqif _alarmClockMove /drop /tret /then
    /dup &pull    /eqif _alarmClockMove /drop /tret /then
    /dup &read    /eqif isActorAlice /if Alice says `` it has stopped working a long time ago . '' /else even without looking you know it displays 23:13 . /then /drop /tret /then
    /dup &turnoff /eqif it is not on . /drop /tret /then
    /dup &turnon  /eqif _alarmClockTurnon /drop /tret /then
    /drop /fret
  }
}

object alarmClockCable {
  name: power cord cable
  location: alarmClock
  run {
    /dup &examine /eqif
      a black power cord about one meter in length , with at the end some blank copper visible instead of a plug .
      /drop /tret
    /then
    /dup &name    /eqif the power cord of the alarm-clock /drop /tret /then
    /dup &plug    /eqif that could be very dangerous with that damaged power cord . /drop /tret /then
    /dup &pull    /eqif _alarmClockMove /drop /tret /then
    /drop /fret
  }
}

object objectCage {
  name: metal animal cage
  location: objectAliceBedroom
  run {    
    /dup &climbon /eqif
      isActorAlice /if
        &ALICE_standingOnCage changeMode
        /drop /tret
      /then
    /then
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &enter /eqif
      isActorAlice /if
        `` it is too small for me '', says Alice .
      /else
        actually it doesn't feel right to go living in that cage again .
      /then
      /drop /tret
    /then
    /dup &examine /eqif
      yup , it is definitely a metal animal cage . 
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        &ALICE_standingInRoom changeMode
        /get $actor /self [+1] /store
        `` gee that thing is heavy '', says Alice , but she manage to pick it up .
        /drop /tret
      /then
    /then
    /dup &look /eqif
      a metal animal cage stands on the floor 
      /self [+1] /fetch &objectAliceBedroom /eqif
        against the north wall
      /then .
      /drop /tret
    /then
    /dup &name    /eqif the metal animal cage /drop /tret /then
    /drop /fret
  }
}

object objectDollhouse {
  name: large dollhouse doll house
  location: objectAliceBedroom
  run {
    /dup &look    /eqif a large dollhouse can be found in the southeast corner of the room . /drop /tret /then
    /dup &examine /eqif
      /1 /to $flagExaminedDollhouse
      the dollhouse is a small model of the real house the owner lives in .
      considering it is a toy house , it is a pretty big thing . unfortunately
      the dolls seem to be missing .
      /drop /tret
    /then
    /dup &name    /eqif the large dollhouse /drop /tret /then
    /dup &play    /eqif
      isActorAlice /if
        &objectAlice holdingObject &objectDolls /eqif
          &ALICE_standingInRoom changeMode
          Alice plays with her dollhouse .

          /get $goalAlicePlayWithDollhouse /nif
            /1 /to $goalAlicePlayWithDollhouse
            entertainmentScore
          /then
        /else
          `` I need my dolls '', says Alice .
        /then
        /drop /tret
      /then
    /then
    /dup &tell    /eqif
      isActorAlice /if
        `` my father build it for me as a present for my first birthday after we moved . it is the same as the real house , only smaller . it even has real working lights ! '', Alice says with a big smile .
        /get $goalAliceFindsDolls /nif
          but the smile quickly disappears from her face , `` I don't know where my dolls are . ''
        /then
        /drop /tret
      /then
    /then
    /dup &turnon /eqif
      the lights inside the dollhouse will be turned on as integral part of the playing experience and don't need to be turned on independently .
      /drop /tret
    /then
    /drop /fret
  }
}

object objectPlayer {
  name: me
  location: objectAliceBedroom
  run {
    /dup &examine /eqif
      isActorPlayer /if
        yeah it is me !
        /drop /tret
      /then
      isActorAlice /if
        she looks at you for a moment . ^
        `` I see nothing special ... well accept you talking and stuff '', says Alice .
        /drop /tret
      /then
    /then
    /dup &name    /eqif me /drop /tret /then
    /dup &tell    /eqif
      isActorAlice /if
        `` you are my ... pet . a white rabbit . '' ^
        `` I don't know where you are born , it is ... ehh you ehh are a present '' ^
        Alice thinks for a while ... ^ ^
        `` I think you first speak when you ate some of these yellow pills , which I got when I was sick '', says Alice while looking at you with a `` see I do know stuff '', look .
        /drop /tret
      /then
    /then
    /drop /fret
  }
  actor {
#    /dup &get /eqif
#      it is too big .
#      /drop /tret
#    /then
    /dup &drop /eqif
      /get $noun /if
        /self holdingObject /get $noun /neqif
          you are not holding displayNounName .
          /drop /tret
        /then
      /then
    /then
    /dup &wake /eqif
      /get $noun /nif
        although it may sound strange , this is not a dream .
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

object objectGreenBox {
  name: large green plastic box
  location: objectAliceBedroom
  sub _greenBoxExamine {
  }
#  sub _greenBoxDispatchrun {
#    look _greenBoxLook
#    examine _greenBoxExamine
#  }
#  run {
#    &_greenBoxDispatchAfter _switchTable
#    /drop /fret
#  }
  run {
    /dup &climbon /eqif
      isActorAlice /if
        &ALICE_standingOnGreenBox changeMode
        /drop /tret
      /then
    /then
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &examine /eqif
      isActorAlice /if
        it is my green toy box .
      /else
        a solid looking box which can be used to store small toys , so mom will not trip over them all the time while cleaning the house .
      /then
      /self holdingObject /if
        the box contains :
        /self _look_child
      /else
        the box is empty .
      /then
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        &ALICE_standingInRoom changeMode
        /get $actor /self [+1] /store
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif a large green plastic box stands on the floor . /drop /tret /then
    /dup &lookin /eqif
      /self holdingObject /if
        the box contains :
        /self _look_child
      /else
        the box is empty .
      /then
      /drop /tret
    /then
    /dup &name /eqif the green box /drop /tret /then
    /drop /fret
  }
}

object objectKey {
  name: rusty key
  location: objectGreenBox
  run {
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &examine /eqif
      a small rusty key which probably belongs to a chest or box .
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        &ALICE_standingInRoom changeMode
        /get $actor /self [+1] /store
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif a rusty key . /drop /tret /then
    /dup &name /eqif the rusty key /drop /tret /then
    /drop /fret
  }
}

#object objectCoco {
#  name: plastic toy parrot bird coco
#  location: objectGreenBox
#  run {
#    inside coco code
#    /drop /fret
#  }
#}

#object objectRing {
#  name: toy ring
#  location: objectGreenBox
#  run {
#    inside ring after
#      $verb &examine /eqif
#        $actor &objectAlice /eqif
#          this is a barbie party ring for ehh... big barbies like me .
#          {contents}
#        /else
#          cheap looking plastic ring which mom payed way to much money on because it came packaged together with a barbie . it is probably called something like ` barbie party ring (tm) for big little girls ' .
#          {contents}
#        /then
#      /then
#    /drop /fret
#  }
#}

object objectAlice {
  name: little girl Alice
  location: objectAliceBed
  sub _aliceBite {
    /get $aliceMode &ALICE_sleepOnBed /eqif
      `` auwww ! '', yells Alice , `` what are you doing you stupid rat ? '' .
      &ALICE_sitOnBed changeMode
      somehow Alice seems to dislike the ` friendly ' bite you gave in her ear , but atleast she is awake now .
    /else
      let's not eat her now but save her for later . *grin*
    /then
  }
  sub _aliceKiss {
    /get $aliceMode &ALICE_sleepOnBed /eqif
      she ain't snow-white, so the famous wake up kiss won't going to happen .
    /then
  }
  sub _aliceWake {
    /get $aliceMode &ALICE_sleepOnBed /eqif
      /get $wakeupTry /if
        no response from little Alice .
      /else
        she rolls over and falls in an even deeper
        sleep . some more violence is needed to wake
        her up this time ( always the same with these kids , normally
        they wake you up in the middle of a nice afternoon nap for
        things like `` look I ' ve made a neclace out of sugar cubes !
        '', but the one or two times you need them , even a cannon shot
        by their ears would not give any noticable effect . ofcourse you
        love her very much , but would have appreciated it if she would
        wake up now ) . ^
        /1 /to $hintWakeupAlice
        /1 /to $wakeupTry
      /then
    /else
      Alice is already awake .
    /then
  }
  sub aliceLook {
    Alice

    /get $aliceMode &ALICE_sleepOnBed /eqif
      is quietly sleeping on the bed
    /then
    /get $aliceMode &ALICE_sitOnBed /eqif
      sits on the bed
    /then
    /get $aliceMode &ALICE_standingInRoom /eqif
      is here
    /then
    /get $aliceMode &ALICE_openDrawerBed /eqif
      is here sitting on the ground by the bed
    /then
    /get $aliceMode &ALICE_standingOnBed /eqif
      is here standing on the bed
    /then
    /get $aliceMode &ALICE_standingByDoor /eqif
      is here standing by the door
    /then
    /get $aliceMode &ALICE_standingOnGreenBox /eqif
      is here standing on the green box
    /then
    /get $aliceMode &ALICE_standingOnCage /eqif
      is here standing on the animal cage
    /then
    /self holdingObject /dup /if
      holding &name /swap [+3] /fetch /execute
    /then /drop
    .
  }
  run {
    /dup &bite    /eqif isActorAlice /nif _aliceBite /drop /tret /then /then
    /dup &examine /eqif
      aliceLook ^
      /self wearingObject
      /dup /nif she is naked . /then
      /dup &objectPajama /eqif she is wearing a pink pajama . /then
      /dup &objectDress /eqif she is wearing a white dress . /then
      &objectUnderwear /eqif she is only wearing underwear . /then

      /drop /tret
    /then
    /dup &kiss    /eqif _aliceKiss /drop /tret /then
    /dup &look    /eqif 
      aliceLook
      /drop /tret
    /then
    /dup &name    /eqif Alice /drop /tret /then
    /dup &nibble  /eqif isActorAlice /nif _aliceBite /drop /tret /then /then
    /dup &wake    /eqif _aliceWake /drop /tret /then
    /drop /fret
  }
  actor {
    /get $aliceMode &ALICE_sleepOnBed /eqif
      she doesn't respond , probably because she is asleep  .
      /drop /tret
    /then
    /dup &climbon /eqif
      /self holdingObject /dup /get $noun /eqif
        `` I'm holding &name /swap [+3] /fetch /execute /drop , so I need to drop it first before I can climb on it . '', says Alice .
        /drop /tret
      /then
      /drop
    /then
    /dup &drop /eqif
      /get $noun /if
        /self holdingObject /get $noun /neqif
          `` I'm not holding displayNounName '', says Alice .
          /drop /tret
        /then
      /then
    /then
    /dup &get /eqif
      /self holdingObject /dup /if
        `` I'm already holding &name /swap [+3] /fetch /execute /drop '', says Alice .
        /drop /tret
      /then
      /drop
    /then
    /dup &jump /eqif
      /get $aliceMode &ALICE_standingOnBed /eqif
        `` jumping on the bed is fun '', says Alice .
        /get $goalJumpOnBed /nif
          /1 /to $goalJumpOnBed
          naughtyScore
        /then
        /drop /tret
      /then
    /then
    /dup &open /eqif
      /get $noun /if
        /self holdingObject /dup /if
          /dup &objectKey /neqif
            `` it is easier for me to open displayNounName without holding &name /swap [+3] /fetch /execute /drop '', says Alice with an innocent voice .
            /drop /tret
          /then
        /then
        /drop
      /then
    /then
#    /dup &play /eqif
#      /get $noun /if
#        /self holdingObject /dup /if
#          `` it is easier playing with displayNounName without holding &name /swap [+3] /fetch /execute /drop '', says Alice .
#          /drop /tret
#        /then
#        /drop
#      /then
#    /then
    /dup &undress /eqif
      # only undress when not naked
      /self wearingObject /dup /if
        # only undress with both hands free
        /self holdingObject /dup /if
          `` it is easier for me to undress without holding &name /swap [+3] /fetch /execute /drop '', says Alice .
          /drop
          /drop /tret
        /then /drop
        
        Alice takes off &name /over [+3] /fetch /execute /drop
        /self /over [+1] /store   /0 /swap [+2] /store
        /drop /tret
      /then
      `` I'm naked '', says Alice .
      /drop /drop /tret
    /then
    /dup &wear /eqif
      /self holdingObject /dup /if
        /dup /get $noun /neqif
          `` it is easier for me to dress without holding &name /swap [+3] /fetch /execute /drop '', says Alice .
          /drop /tret
        /then
      /then /drop
    /then
    /drop /fret
  }
}

object objectFreddy {
  name: Freddy brown teddy bear
  location: objectAliceBed
  run {
    /dup &examine /eqif it is a brown teddy bear apparently called Freddy . Alice likes playing with it . /drop /tret /then
    /dup &get /eqif
      isActorAlice /if
        `` I only play with Freddy when I go to bed '', says Alice .
        /drop /tret
      /then
      isActorPlayer /if
        better leave the bear alone or Alice will get upset . she can't sleep well without holding Freddy .
        /drop /tret
      /then
    /then
    /dup &look /eqif
      /get $aliceMode &ALICE_sleepOnBed /eq /get $aliceMode &ALICE_sitOnBed /eq /or /if
        a brown teddy bear is laying beside her .
      /else
        a brown teddy bear can be seen on the bed .
      /then
      /drop /tret
    /then
    /dup &name /eqif Freddy /drop /tret /then
    /dup &play /eqif 
      isActorAlice /if
        /get $goalPlayWithTeddy /if
          `` no , maybe later '', says Alice .
          /drop /tret
        /else
          &ALICE_sitOnBed changeMode
          Alice plays with her teddy bear . she seems to have fun with it .
          /1 /to $goalPlayWithTeddy
          entertainmentScore
          /drop /tret
        /then
      /then
    /then
    /drop /fret
  }
}

object objectDress {
  name: white dress
  location: objectOpenDrawer
  run {
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        /get $actor /self [+1] /store
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif a white dress . /drop /tret /then
    /dup &name /eqif the white dress /drop /tret /then
    /dup &wear /eqif
      isActorAlice /if
        &objectPajama [+2] /fetch &objectAlice /eqif
          `` I'm already wearing a pajama . '', says Alice .
          /drop /tret
        /then
        &objectVoid /self [+1] /store
        &objectAlice /self [+2] /store
        Alice puts on the white dress .
        /get $goalPutOnDress /nif
          /1 /to $goalPutOnDress
          educationScore
        /then
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

object objectUnderwear {
  name: underwear
  location: objectOpenDrawer
  run {
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        /get $actor /self [+1] /store
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif some underwear . /drop /tret /then
    /dup &name /eqif the underwear /drop /tret /then
    /dup &wear /eqif
      isActorAlice /if
        &objectPajama [+2] /fetch &objectAlice /eqif
          `` I'm already wearing a pajama . '', says Alice .
          /drop /tret
        /then
        &objectVoid /self [+1] /store
        &objectAlice /self [+2] /store
        Alice puts on the underwear .
        /get $goalPutOnUnderwear /nif
          /1 /to $goalPutOnUnderwear
          educationScore
        /then
        /drop /tret
      /then
    /then
    /drop /fret
  }
}

object objectPajama {
  name: pink pajama
  location: objectVoid
  worn: objectAlice
  run {
    /dup &drop /eqif
      /get $actor _findRoom /self [+1] /store
      done .
      /drop /tret
    /then
    /dup &get /eqif
      isActorAlice /if
        /get $actor /self [+1] /store
        done .
        /drop /tret
      /then
    /then
    /dup &look /eqif a pink pajama . /drop /tret /then
    /dup &name /eqif the pink pajama /drop /tret /then
    /dup &wear /eqif
      isActorAlice /if
        &objectDress [+2] /fetch &objectAlice /eqif
          `` I'm already wearing a white dress . '', says Alice .
          /drop /tret
        /then
        &objectVoid /self [+1] /store
        &objectAlice /self [+2] /store
        Alice puts on the pajama .
        /drop /tret
      /then
    /then
    /drop /fret
  }
}


