#if !defined(tree_included)
#define tree_included
/*
// Abstract:
//	TREE.H---Balanced Binary Tree Routines
//
//	The Balanced Binary Tree Routines C include file defines the
//	interface to the Balanced Binary Tree Routines.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	11 November 1990
//
// History:
// V01-001	Derek S. Nickel		11-NOV-1990
//	Original.
//
*/

typedef unsigned long cond_value;
typedef unsigned long mask_longword;

extern const cond_value lib$_normal;
extern const cond_value lib$_keyalrins;
extern const cond_value lib$_keynotfou;

extern cond_value insert_tree(
	void **treehead,
	void *symbol,
	mask_longword *flags,
	int (*compare_rtn)(const void *a, const void *b, const void *c),
	int (*allocate_rtn)(const void *a, void **b, const void *c),
	void **new_node,
	void *user_data );

extern cond_value lookup_tree(
	void **treehead,
	void *symbol,
	int (*compare_rtn)(const void *a, const void *b, const void *c),
	void **new_node );

extern cond_value traverse_tree(
	void **treehead,
	int (*action_rtn)(const void *node, const void *user_data),
	void *user_data );

extern cond_value post_order_traversal(
	void **treehead,
	int (*action_rtn)(const void *node, const void *user_data),
	void *user_data );

#endif
