#include "dis48.h"

char	*OpStr1[8] = {
	"a, @d0", "a, @d1", "@d0, a", "@d1, a",
	"c, @d0", "c, @d1", "@d0, c", "@d1, c"
};

char *
#ifdef ANSI
Instr1(char *mem, NAddr *addr, char *out)
#else
Instr1(mem, addr, out)
char	*mem;
NAddr	*addr;
char	*out;
#endif
{
	Nybble	n;
	Nybble	fn;
	char	*p;
	char	c;
	
	switch (n = GetNybble(mem, (*addr)++)) {
	case 0:
	case 1:
		p = AppendStr(out, "move.w\t\t");
		fn = GetNybble(mem, (*addr)++);
		c = (fn < 8) ? 'a' : 'c';
		fn = (fn & 7) + '0';
		if (n == 0)
			APPEND_CHAR(p, c);
		else {
			APPEND_CHAR(p, 'r');
			APPEND_CHAR(p, fn);
		}
		
		APPEND_COMMA(p);
		if (n == 0) {
			APPEND_CHAR(p, 'r');
			APPEND_CHAR(p, fn);
			
		} else
			APPEND_CHAR(p, c);
		
		break;
		
	case 2:
		p = AppendStr(out, "swap.w\t\t");
		n = GetNybble(mem, (*addr)++);
		APPEND_CHAR(p, (n < 8) ? 'a' : 'c');
		APPEND_COMMA(p);
		APPEND_CHAR(p, 'r');
		APPEND_BDIGIT(p, n & 7);
		break;
	
	case 3:
		n = GetNybble(mem, (*addr)++);
		p = AppendStr(out, (n & 2) ? "swap" : "move");
		APPEND_CHAR(p, '.');
		APPEND_CHAR(p, (n < 8) ? 'a' : '4');
		APPEND_TAB(p);
		APPEND_TAB(p);
		APPEND_CHAR(p, (n & 4) ? 'c' : 'a');
		APPEND_COMMA(p);
		APPEND_CHAR(p, 'd');
		APPEND_BDIGIT(p, n & 1);
		break;
		
	case 4:
	case 5:
		p = AppendStr(out, "move");
		fn = GetNybble(mem, (*addr)++);
		if (n == 4) {
			APPEND_CHAR(p, '.');
			APPEND_CHAR(p, (fn < 8) ? 'a' : 'b');
			APPEND_TAB(p);
		
		} else {
			n = GetNybble(mem, (*addr)++);
			if (fn < 8)
				p = AppendField(p, n);
				
			else {
				APPEND_CHAR(p, '.');
				p = Append16(p, n);
				APPEND_TAB(p);
			}
		}
		
		if ((p - out) < 8)
			APPEND_TAB(p);
			
		p = AppendStr(p, OpStr1[fn & 7]);
		break;
	
	case 6:
	case 7:
		p = AppendStr(out, "add.a\t\t");
		APPEND_IMMMARK(p);
		p = Append16(p, GetNybble(mem, (*addr)++));
		APPEND_COMMA(p);
		APPEND_CHAR(p, 'd');
		APPEND_BDIGIT(p, n & 1);
		break;
		
	default:
		c = (n < 0xc) ? '0' : '1';
		if ((n & 3) == 0) {
			p = AppendStr(out, "sub.a\t\t");
			APPEND_IMMMARK(p);
			p = Append16(p, GetNybble(mem, (*addr)++));
		
		} else {
			p = AppendStr(out, "move.");
			switch (n & 3) {
			case 1: n = 2; break;
			case 2: n = 4; break;
			case 3: n = 5; break;
			}
			
			APPEND_BDIGIT(p, n);
			APPEND_TAB(p);
			APPEND_TAB(p);
			p = AppendImmNyb(p, mem, addr, n);
		}
		
		APPEND_COMMA(p);
		APPEND_CHAR(p, 'd');
		APPEND_CHAR(p, c);
		break;
	}
	
	TERMINATE(p);
	return(p);
}
