/*****************************************************************
 |  Program name:  bundle.c
 |----------------------------------------------------------------
 |  accept standard input and write to a device named on the command
 |  line. The total bytes on the device and the buffer size are
 |  given on the command line. When the device is full, prompt
 |  for a new medium in the device and continue.
 |
 |  Command form:
 |   bundle [ device [ Dsize [ Bsize ]]]
 |----------------------------------------------------------------
 |  Author: Bill Davidsen, 8/16/86
 |  Version 1.6
 |  Last modified: 3/6/87
 |  Version 1.6M for Minix Operating System
 |  Modified by Tapani Lindgren <nispa@hutcs.hut.fi> 87-12-28
 |----------------------------------------------------------------
 |  Copyright 1986,87 by Bill Davidsen. This code may be used for
 |  personal or commercial purposes. It may be freely distributed
 |  in source form providing this notice is kept intact.
 *****************************************************************/

#include "bundle.h"

static char *SCCS = "@(#) bundle 1.6M";
     
     usage()
{
  fprintf (stderr, "Usage:\n bundle [ device [ DevSize [ BufSize ]]]\n");
  fprintf (stderr, "Where size may be bytes (as 5120) or k (as 5k)\n");
  exit (1);
}

main (argc, argv)
     int  argc;
     char *argv[];
{
  char *devname;		/* device name */
  char *buffer,		/* i/o buffer */
  *malloc ();
  register  long left;	/* room left in the buffer */
  long  bufsize, devsize;	/* buffer and device size */
  long  devleft = 0;		/* room left on device */
  int  istat,			/* stdin read status */
  ostat,			/* device write status */
  dev,			/* device name from open */
  MediaNum = 1;		/* sequential media # */
  FILE *tty, *fopen ();
  long getsize ();		/* get size from argument */
  
  /* validate arguments */
  if (argc > 4) usage();
  
  if (argc > 1) devname = argv[1]; else devname = DEF_DNAME;
  if (argc > 2) devsize = getsize (argv[2]); else devsize = DEF_DSIZE;
  debug ("Device size %ld", devsize);
  if (argc > 3) bufsize = getsize (argv[3]); else bufsize = DEF_BSIZE;
  debug (", buffer size %ld\n", bufsize);
  if (devsize < 1 || devsize < bufsize)
    { /* invalid specification of size */
      fprintf (stderr, "Invalid buffer and/or device size\n");
      exit (1);
    }
  
  /* open the terminal for prompt */
  tty = fopen ("/dev/tty", "r");
  if (tty == NULL)
    { /* mystery failure */
      fprintf (stderr, "Unable to open /dev/tty for prompt\n");
      exit (1);
    }
  
  /* open the buffer */
  buffer = malloc (bufsize);
  debug ("Buffer allocated\n", 0);
  if (buffer == NULL)
    { /* can't mallocate */
      fprintf (stderr, "Can't allocate space for the buffer\n");
      exit (1);
    }
  
  /* see if you can open the device */
  fprintf (stderr, "Mount media #1 on %s and press RETURN\n", devname);
  while (getc (tty) != '\n');
  dev = open (devname, 1);
  if (dev < 0)
    { /* invalid name */
      fprintf (stderr, "Can't access device %s\n", devname);
      exit (1);
    }
  devleft = devsize; /* set media ready */
  debug ("Enter copy loop\n\n", 0);
  
  /* main copy loop */
  while (istat = fread (buffer, 1, (int) bufsize, stdin))
    { /* until EOF */
      debug ("Input read size %d\n", istat);
      
      if (devleft < istat)
	{ /* change media */
	  close (dev);
	  fprintf (stderr, "\007Mount media #%d on %s and press RETURN\n",
		  ++MediaNum, devname);
	  while (getc (tty) != '\n');
	  dev = open (devname, 1);
	  devleft = devsize;
	}
      
      /* write the buffer */
      ostat = write (dev, buffer, bufsize);
      debug ("Output write size %d\n", ostat);
      
      if (bufsize != ostat)
	{ /* error on write */
	  fprintf (stderr, "Error on device write!\n");
	  exit (1);
	}
      devleft -= ostat;
    }
}

/*
  |  Procedure:  getsize
  |-
  |  Convert the size string to bytes. If the last character is
  |  'k', multiply by 1024
  */

long
  getsize (string)
char *string;
{
  register int  len = strlen (string);
  register long val = atol (string);
  
  if (string[len - 1] == 'k')
    val *= 1024;
  
  return val;
}
