/*
 * C compiler
 * ==========
 *
 * Copyright 1989, 1990, 1991 Christoph van Wuellen.
 * Credits to Matthew Brandt.
 * All commercial rights reserved.
 *
 * This compiler may be redistributed as long there is no
 * commercial interest. The compiler must not be redistributed
 * without its full sources. This notice must stay intact.
 *
 * History:
 *
 * 1989   starting an 68000 C compiler, starting with material
 *        originally by M. Brandt
 * 1990   68000 C compiler further bug fixes
 *        started i386 port (December)
 * 1991   i386 port finished (January)
 *        further corrections in the front end and in the 68000
 *        code generator.
 *        The next port will be a SPARC port
 */


#include <sys/types.h>
#include <sys/times.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#ifndef _CONFIG_H
#include "config.h"
#endif

/* the tokens returned from lexical analysis */

enum e_sym {
    cconst, iconst, lconst, sconst, rconst, plus, minus,
    divide, lshift, rshift, modop, eq, neq, lt, leq, gt,
    geq, assign, asplus, asminus, astimes, asdivide, asmodop,
    asuparrow,
    aslshift, asrshift, asand, asor, autoinc, autodec, hook, compl,
    comma, colon, semicolon, uparrow, openbr, closebr, begin, end,
    closepa, pointsto, dot, lor, land, not, or, and,
    star, openpa, id, kw_int,
    kw_void, kw_char, kw_float, kw_double, kw_struct, kw_union,
    kw_enum, kw_const, kw_volatile, kw_signed,
    kw_long, kw_short, kw_unsigned, kw_auto, kw_extern,
    kw_register, kw_typedef, kw_static, kw_goto, kw_return,
    kw_sizeof, kw_break, kw_continue, kw_if, kw_else, kw_for,
    kw_do, kw_while, kw_switch, kw_case, kw_default,
    uconst, eof
};

/* storage classes */

enum e_sc {
    sc_static, sc_auto, sc_global, sc_external, sc_type, sc_const,
    sc_member, sc_label, sc_ulabel, sc_typedef, sc_parms
};

/* basic data types */

enum e_bt {
    bt_char, bt_short, bt_long, bt_float, bt_double, bt_pointer,
    bt_ulong, bt_struct, bt_union, bt_func,
    bt_void, bt_uchar, bt_ushort, bt_bitfield, bt_variable
};

/* these form the string literal pool */

struct slit {
    struct slit    *next;
    char           *str;
    unsigned short  label;
    short           len;
};

/* a symbol table */

struct stab {
    struct sym     *head;
    struct sym     *tail;
};

/* structure defining a data type */

struct typ {
    struct stab     lst;
    struct typ     *btp;
    char           *sname;
    long            size;
    enum e_bt       type;
/*
 * The following four chars may be unsigned -- no harm.
 * They could be ints without restriction -- this is to save memory
 */
    char            val_flag;
    char            st_flag;
    char            bit_width;
    char            bit_offset;
};
#define UNKNOWN_SIZE	-1		/* value of 'size' if not known */

/* a symbol table entry */

struct sym {
    struct sym     *next;
    struct sym     *prev;
    char           *name;
    struct typ     *tp;
    union {
	long            i;
	unsigned long   u;
	char           *s;
    }
                    value;
    enum e_sc       storage_class;
    int             used;
};

#define TYP	struct typ
#define TABLE	struct stab

#define MAX_ERROR_COUNT 200
#define MAX_STRLEN	1500
#define MAX_ID_LEN	50
#define MAX_PARAMS	100
#define REG_LIST	20
#define AUTO_LIST	100

/* alignment sizes */

#ifdef MC68000
/*
 * MC68000 is a 16-bit processor. Word alignment is OK in all cases
 */
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	2
#define AL_POINTER	2
#define AL_FLOAT	2
#define AL_DOUBLE	2
#define AL_STRUCT	2
#define AL_FUNC		2

#define AL_DEFAULT	2	/* alignment suitable for all types */
#endif /* MC68000 */

#ifdef MC68010
/*
 * MC68010 is a 16-bit processor. Word alignment is OK in all cases
 */
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	2
#define AL_POINTER	2
#define AL_FLOAT	2
#define AL_DOUBLE	2
#define AL_STRUCT	2
#define AL_FUNC		2

#define AL_DEFAULT	2	/* alignment suitable for all types */
#endif /* MC68010 */

#ifdef MC68020
/*
 * perhaps not necessary, but useful: 32-bit alignment for 32-bit types
 */
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	4
#define AL_POINTER	4
#define AL_FLOAT	4
#define AL_DOUBLE	4
#define AL_STRUCT	4
#define AL_FUNC		4

#define AL_DEFAULT	4	/* alignment suitable for all types */
#endif /* MC68020 */

#ifdef MC68030
/*
 * perhaps not necessary, but useful: 32-bit alignment for 32-bit types
 */
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	4
#define AL_POINTER	4
#define AL_FLOAT	4
#define AL_DOUBLE	4
#define AL_STRUCT	4
#define AL_FUNC		4

#define AL_DEFAULT	4	/* alignment suitable for all types */
#endif /* MC68030 */

#ifdef MC68040
/*
 * perhaps not necessary, but useful: 32-bit alignment for 32-bit types
 */
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	4
#define AL_POINTER	4
#define AL_FLOAT	4
#define AL_DOUBLE	4
#define AL_STRUCT	4
#define AL_FUNC		4

#define AL_DEFAULT	4	/* alignment suitable for all types */
#endif /* MC68040 */

#ifdef INTEL_386
/*
 * perhaps not necessary, but useful: 32-bit alignment for 32-bit types
 */
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	4
#define AL_POINTER	4
#define AL_FLOAT	4
#define AL_DOUBLE	4
#define AL_STRUCT	4
#define AL_FUNC		4

#define AL_DEFAULT	4	/* alignment suitable for all types */
#endif /* INTEL_386 */


#ifdef SPARC
#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	4
#define AL_POINTER	4
#define AL_FLOAT	4
#define AL_DOUBLE	8
#define AL_STRUCT	8
#define AL_FUNC		4

#define AL_DEFAULT	8	/* alignment suitable for all types */
#endif /* SPARC */

/*
 *	List of symbolic constants for message numbers.
 *
 *	For text of message types see the 'msgout.c' module
 *
 *	It is EXTREMELY important that the order of this 
 *	enum statement is kept consistent with the table
 *	of messages in 'msgout.c'
 */

enum   err_msgs {
/*
 *	Parsing Error messages
 */
	ERR_ADDREGVAR,
	ERR_ARG	,
	ERR_BITFIELD,
	ERR_BLOCK,
	ERR_BREAK,
	ERR_CASE,
	ERR_CAST,
	ERR_CASTCON,
	ERR_CHARCONST,
	ERR_CONSTEXPR,
	ERR_CONSTFLOAT,
	ERR_CONT,
	ERR_COUNTPARAM,
	ERR_DEREF,
	ERR_DUPCASE,
	ERR_DUPDEFAULT,
	ERR_DUPLABEL,
	ERR_ENUMVAL,
	ERR_EOF	,
	ERR_EXPREXPECT,
	ERR_FIELD,
	ERR_FPCON,
	ERR_IDEXPECT,
	ERR_ILLCHAR,
	ERR_ILLCLASS,
	ERR_ILLINIT,
	ERR_ILLSIZEOF,
	ERR_ILLXCHAR,
	ERR_INCOMPLETE,
	ERR_INITSIZE,
	ERR_INTEGER,
	ERR_INTEXPR,
	ERR_LABEL,
	ERR_LVALUE,
	ERR_MISMATCH,
	ERR_NESTED,
	ERR_NOFUNC,
	ERR_NOINIT,
	ERR_NOMEMBER,
	ERR_NOPOINTER,
	ERR_PARMS,
	ERR_PARAMSIZE,
	ERR_PREPROC,
	ERR_PROTOTYPE,
	ERR_PUNCT,
	ERR_REDECL,
	ERR_SIZE,
	ERR_STATIC,
	ERR_STRINGCONST,
	ERR_SYNTAX,
	ERR_UNDEFINED,
	ERR_UNDEFLAB,
	ERR_VOIDFUNC,
	ERR_VOIDRETURN,
	ERR_WHILEXPECT,
	ERR_WIDTH,
/*
 *	Warning messages are ordered in order of increasing severity
 */
/*
 *	Level 6 - Only output if checking for portability
 *	Warnings at this level are normally too pedantic to be useful
 */
#define	WARN_LEVEL_MAX		6
#define	WARN_BASE	WARN_CONSTCAST
#define WARN_LEVEL6	WARN_CONSTCAST
	WARN_CONSTCAST,
	WARN_NARROWER,
/*
 *	Level 5
 *	These are warnings for things that are common C practise, but
 *	that might possibly indicate an error if you are having trouble
 *	tracking down a particular problem
 */
#define WARN_LEVEL5	WARN_ASSIGN
	WARN_ASSIGN,
	WARN_IMPLICITRET,
/*
 *	Level 4
 *	Warnings at this level are often encountered when porting
 *	code, but are quite likely not be an error.
 */
#define	WARN_LEVEL4	WARN_0TYPEDEF
	WARN_0TYPEDEF,
	WARN_ADDFUNC,
	WARN_EMPTY,
	WARN_HIDE,
	WARN_IMPLICIT,
	WARN_IMPLICITFN,
	WARN_NOTKANDR,
	WARN_NOTUSED,
/*
 *	Level 3
 *	Warnings at this level are often encountered when porting
 *	code. They are quite likely to indicate an error.
 */
#define	WARN_LEVEL3	WARN_ESCAPECH
	WARN_ESCAPECH,
	WARN_MATCHPARAM,
	WARN_PTRCAST,
	WARN_PTRDIFF16,
	WARN_SHORTPTR,
	WARN_VALRETURN,
/*
 *	Level 2
 *	Default warning level.  These should normally be fixed.
 *	Typically this just requires a cast or something similar.
 */
#define	WARN_LEVEL2	WARN_AUTOINIT
	WARN_AUTOINIT,
	WARN_NOHEX,
	WARN_REDEFINE,
	WARN_SIZEOF0,
	WARN_SIZEOFBIG,
	WARN_TYPECAST,
	WARN_ZEROMEM,
/*
 *	Level 1
 *	This is the most severe level of warnings.   These should
 *	not be suppressed unless one is certain that is OK.
 */
#define	WARN_LEVEL1	WARN_FLDTYPE
	WARN_FLDTYPE,
	WARN_NOCOPY,
	WARN_PRAGMA,
	WARN_STRINGCUT,
/*
 *	Messages below this point are output without file/line number details
 */
/*
 *	Generalised warning messages from code generator
 *	(they are all at warning level 1)
 */
#define	GWARN_BASE	GWARN_CHANGEINT
	GWARN_CHANGEINT,
	GWARN_DIVZERO,
	GWARN_ILLDOOPER,
	GWARN_SHIFTNEG,
	GWARN_SHIFTRANGE,
/*
 *	Miscellaneous messages
 */
#define	MSG_BASE	MSG_ARGSYMTABLE
	MSG_ARGSYMTABLE,
	MSG_ERROR,
	MSG_ERRORCNT,
	MSG_EXTRAPARAM,
	MSG_FATAL,
#ifdef ICODE
	MSG_ICODEFILE,
#endif /* ICODE */
	MSG_INFILE,
	MSG_LABSYMTABLE,
	MSG_LISTFILE,
	MSG_LOCALMEM,
	MSG_LOCSTRUCT,
	MSG_LOCSYMTABLE,
	MSG_MAXERROR,
	MSG_MAXMEMORY,
	MSG_MISSING,
	MSG_NOMEMORY,
#if (AL_DEFAULT > 2)
	MSG_NOSHORT,
#endif /* AL_DEFAULT */
	MSG_OUTFILE,
	MSG_PEEPLABEL,
#ifdef VERBOSE
	MSG_RELEASEGLB,
	MSG_RELEASELOC,
#endif /* VERBOSE */
	MSG_SIGNAL,
#ifdef VERBOSE
	MSG_TIMES,
#endif /* VERBOSE */
	MSG_UNKNOWNOPT,
	MSG_WARNING,
	MSG_LINE
	};

char           *strcpy();

#include "version.h"
#include "expr.h"
#include "gen.h"
#include "proto.h"

