/* The <sys/types.h> header contains important data type definitions.
 * It is considered good programming practice to use these definitions, 
 * instead of the underlying base type.  By convention, all type names end 
 * with _t.
 */

#ifndef _TYPES_H
#define _TYPES_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;	  /* type returned by sizeof */
#endif

typedef unsigned short	dev_t;	  /* holds (major|minor) device pair */
typedef unsigned short	uid_t;	  /* user id */
typedef unsigned char	gid_t;	  /* group id */
typedef unsigned short	ino_t;	  /* i-node number */
typedef unsigned short	mode_t;	  /* mode number within an i-node */
typedef unsigned char	nlink_t;  /* number-of-links field within an i-node */
typedef unsigned long	off_t;	  /* offsets within a file */
typedef unsigned int	pid_t;	  /* type for pids */

/* Not required by POSIX here, but convenient.  In any case, legal. */
#ifndef _TIME_H
typedef	long clock_t;		/* time in ticks since system boot */
typedef long time_t;		/* time in sec since 1 Jan 1970 0000 GMT */
#endif

#endif /* _TYPES_H */
