/* The <stdlib.h> header defines certain common macros, types, and functions.*/

#ifndef _STDLIB_H
#define _STDLIB_H

/* The macros are NULL, EXIT_FAILURE, EXIT_SUCCESS, RAND_MAX, and MB_CUR_MAX.*/
#ifndef NULL
#define NULL      (void *) 0
#endif

#define EXIT_FAILURE       1	/* standard error return using exit() */
#define EXIT_SUCCESS       0	/* successful return using exit() */
#define RAND_MAX       32767	/* largest value generated by rand() */
#define MB_CUR_MAX         1	/* max value of multibye character */


/* The types are size_t, wchar_t, div_t, and ldiv_t. */
#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;	/* type returned by sizeof */
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef char wchar_t;		/* type expanded character set */
#endif

typedef struct { int quot, rem; } div_t;
typedef struct { long quot, rem; } ldiv_t;

/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
double atof(const char *__nptr);
int atoi(const char *__nptr);
long atol(const char *__nptr);
double strtod(const char *__nptr, char **__endptr);
long strtol(const char *__nptr, char **__endptr, int __base);
unsigned long int strtoul(const char *__nptr, char **__endptr, int __base);
int rand(void);
void srand(unsigned int __seed);
void *calloc(size_t __nmemb, size_t __size);
void free(void *__ptr);
void *malloc(size_t __size);
void *realloc(void *__ptr, size_t __size);
void abort(void);
int atexit(void (*func)(void));
void exit(int __status);
char *getenv(const char *__name);
int system(const char *__string);
void *bsearch(const void *__key, const void *__base, size_t __nmemb,
		size_t __size, int (*__compar) (const void *, const void *));
int (*compar)(const void *, const void *));
void qsort(void *__base, size_t __nmemb, size_t __size,
int (*compar)(const void *, const void *));
int abs(int __j);
div_t div(int __numer, int __denom);
long labs(long __j);
ldiv_t ldiv(long __numer, long __denom);
int mblen(const char *__s, size_t __n);
int mbtowc(wchar_t *__pwc, const char *__s, size_t __n);
int wctomb(char *__s, wchar_t __wchar);
size_t mbstowcs(wchar_t *__pwcs, const char *__s, size_t __n);
size_t wcstombs(char *__s, const wchar_t *__pwcs, size_t __n);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
double atof();
long atol();
double strtod();
long strtol();
unsigned long int strtoul();
void srand();
void *calloc();
void free();
void *malloc();
void *realloc();
void abort();
void exit();
char *getenv();
void *bsearch();
void qsort();
div_t div();
long labs();
ldiv_t ldiv();
size_t mbstowcs();
size_t wcstombs();
#endif

#endif /* STDLIB_HEADER */
