/* The <setjmp.h> header relates to the C phenomenon known as setjmp/longjmp.  
 * It is used to escape out of the current situation into a previous one.  
 * A typical example is in an editor, where hitting DEL breaks off the current 
 * command and puts the editor back in the main loop.
 */

/* _JBLEN should be 3 for IBM PC, 13 for ATARI. */

#ifndef _SETJMP_H
#define _SETJMP_H

#define _JBLEN 3

typedef int jmp_buf[_JBLEN];

/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
int setjmp(jmp_buf __env);
void longjmp(jmp_buf __env, int __val);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
int setjmp();
void longjmp();
#endif

#endif /* _SETJMP_H */
