/* The <dirent.h> header file is for POSIX.  It is used by the opendir(), 
 * readdir(), writedir(), and related procedure calls.  This header requires
 * <sys/types.h>.
 */

/* DIRBUF must in general be larger than the filesystem buffer size. */
#define	_DIRBUF		2048	/* buffer size for fs-indep. dirs */
#define _DIR_MAGIC     19997	/* arbitrary number for marking DIRs */

/* The DIR structure is used for all the directory operations. */
typedef struct {
 int dd_fd;			/* file descriptor */
 int dd_loc;			/* offset in block */
 int dd_size;			/* amount of valid data */
 int dd_magic;			/* magic number to recognize DIRs */
 char *dd_buf;			/* -> directory block */
} DIR;				/* stream data from opendir() */


struct dirent {			/* data from getdents()/readdir() */
  long d_ino;			/* inode number of entry */
  off_t d_off;			/* offset of disk directory entry */
  unsigned short d_reclen;	/* length of this record */
  char d_name[1];		/* name of file */ /* non-POSIX */
};

/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
DIR *opendir(char *__dirname);
struct dirent *readdir(DIR *__dirp);
void rewinddir(DIR *__dirp);
int closedir(DIR *__dirp);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C declarations. */
DIR *opendir();
struct dirent *readdir();
void rewinddir();
#endif
