/* The <ctype.h> header file defines some macros used to identify characters.
 * It works by using a table stored in ctype.c.  When a character is presented
 * to one of these macros, the character is used as an index into the table
 * (_ctype_) to retrieve a byte.  The relevant bit is then extracted.
 */

#ifndef _CTYPE_H
#define _CTYPE_H

extern	char	__ctype[];	/* located in ctype.c */

#define _U		0001	/* this bit is for upper-case letters [A-Z] */
#define _L		0002	/* this bit is for lower-case letters [a-z] */
#define _N		0004	/* this bit is for numbers [0-9] */
#define _S		0010	/* this bit is for white space \t \n \f etc */
#define _P		0020	/* this bit is for punctuation characters */
#define _C		0040	/* this bit is for control characters */
#define _X		0100	/* this bit is for hex digits [a-f] and [A-F]*/
#define _SP		0200	/* this bit is for the space character only */

/* Declare ANSI prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
int isalpha(int  __c);		/* alphanumeric */
int isdigit(int  __c);		/* digit [0-9] */
int islower(int  __c);		/* lower-case letter [a-z] */
int isspace(int  __c);		/* white space sp, \f, \n, \r, \t, \v */
int isupper(int  __c);		/* upper-case letter [A-Z] */
int isxdigit(int __c);		/* hex digit [0-9], [a-f], [A-F] */
int isalnum(int  __c);		/* alphanumeric [a-z], [A-Z], [0-9] */
int iscntrl(int  __c);		/* control characters */
int isgraph(int  __c);		/* graphic character */
int isprint(int  __c);		/* printable character */
int ispunct(int  __c);		/* punctuation mark */
int tolower(int  __c);		/* convert upper case to lower case */
int toupper(int  __c);		/* convert lower case to upper case */
#endif

/* K&R prototypes are not needed for functions returning an 'int'. */

/* Macros for idenitifying character classes. */
#define isalpha(c)	((__ctype+1)[c]&(_U|_L))
#define isdigit(c)	((__ctype+1)[c]&_N)
#define islower(c)	((__ctype+1)[c]&_L)
#define isspace(c)	((__ctype+1)[c]&_S)
#define isupper(c)	((__ctype+1)[c]&_U)
#define isxdigit(c)	((__ctype+1)[c]&(_N|_X))
#define isalnum(c)	((__ctype+1)[c]&(_U|_L|_N))
#define iscntrl(c)	((__ctype+1)[c]&_C)
#define isgraph(c)	((__ctype+1)[c]&(_P|_U|_L|_N))
#define isprint(c)	((__ctype+1)[c]&(_SP|_P|_U|_L|_N))
#define ispunct(c)	((__ctype+1)[c]&_P)
#define toupper(c)	(islower(c) ? (c & 0xDF) : c)
#define tolower(c)	(isupper(c) ? (c | 0x20) : c)

#endif /* _CTYPE_H */
