/* Data structure used for keeping track of inodes in core
   Copyright (C) 1991, 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include <cthreads.h>

/* Incore inode */
struct inode
{
  struct inode *i_next;		/* link on hash list */
  struct inode **i_prev;	/* ditto */

  struct dinode *di;		/* disk inode info */
  int i_number;			/* easier than subraction with dinode */
  short i_refcnt;		/* ref count */
  struct inode *i_nfree;

  pid_t i_owner;

  fsys_t i_translator;		/* current translator */

  int flock_type;		/* LOCK_UN, _EX, or _SH */
  struct condition i_flockwait;
  int needflock;
  int shlock_count;

  /* Used by dir lookup routines */
  long i_diroff;		/* offset in dir where last entry found */
  off_t i_endoff;		/* end of useful stuff in dir */

  struct mutex i_shrinklock;	/* file size can't decrease without this */
  int i_shrinkcount;
  struct condition i_shrinkwait;

  struct mutex i_dinlock;

  /* sinlock protects the following */
  struct mutex i_sinlock;
  struct controlinfo *i_sininfo; /* used by the indir pager */
  daddr_t *i_dinloc;		/* location of double indir block */

  /* datalock protects the following */
  struct mutex i_datalock;
  struct controlinfo *i_fileinfo;
  daddr_t *i_sinloc;		/* where indirect blocks are mapped */

  struct mutex i_itlock;
  struct protid *i_it;		/* who is it? */

  struct mutex i_toplock;
  struct condition i_itwait;
  int i_allocsize;
};

/* Locking rules: 

   i_dinlock protects the INDIR_DOUBLE field of the inode.

   i_sinlock protects 
     1: mapping of the double indirect block
     2: contents of the INDIR_SINGLE field of the inode.
     3: contents of the double indirect block

   i_datalock protects
     1: mapping of the single indirect blocks
     2: contents of the direct block pointers of the inode.
     3: contents of the single indirect blocks.

   i_itlock protects i_it field

   i_toplock protects everything else
*/

