#ifndef	_auth_user_
#define	_auth_user_

/* Module auth */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>

/* Routine auth_getids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_getids
#if	defined(LINTLIBRARY)
    (handle, uids, uidsCnt, gids, gidsCnt)
	auth_t handle;
	idarray_t *uids;
	mach_msg_type_number_t *uidsCnt;
	idarray_t *gids;
	mach_msg_type_number_t *gidsCnt;
{ return auth_getids(handle, uids, uidsCnt, gids, gidsCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	idarray_t *uids,
	mach_msg_type_number_t *uidsCnt,
	idarray_t *gids,
	mach_msg_type_number_t *gidsCnt
);
#else
    ();
#endif
#endif

/* Routine auth_makeauth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_makeauth
#if	defined(LINTLIBRARY)
    (handle, uids, uidsCnt, gids, gidsCnt, newhandle)
	auth_t handle;
	idarray_t uids;
	mach_msg_type_number_t uidsCnt;
	idarray_t gids;
	mach_msg_type_number_t gidsCnt;
	mach_port_t *newhandle;
{ return auth_makeauth(handle, uids, uidsCnt, gids, gidsCnt, newhandle); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	idarray_t uids,
	mach_msg_type_number_t uidsCnt,
	idarray_t gids,
	mach_msg_type_number_t gidsCnt,
	mach_port_t *newhandle
);
#else
    ();
#endif
#endif

/* Routine auth_combine */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_combine
#if	defined(LINTLIBRARY)
    (handle1, handle2, newhandle)
	auth_t handle1;
	auth_t handle2;
	mach_port_t *newhandle;
{ return auth_combine(handle1, handle2, newhandle); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle1,
	auth_t handle2,
	mach_port_t *newhandle
);
#else
    ();
#endif
#endif

/* Routine auth_user_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_user_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, newport)
	auth_t handle;
	mach_port_t rendezvous;
	mach_port_t *newport;
{ return auth_user_authenticate(handle, rendezvous, newport); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_port_t *newport
);
#else
    ();
#endif
#endif

/* Routine auth_server_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_server_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, newport, uids, uidsCnt, gids, gidsCnt)
	auth_t handle;
	mach_port_t rendezvous;
	mach_port_t newport;
	idarray_t *uids;
	mach_msg_type_number_t *uidsCnt;
	idarray_t *gids;
	mach_msg_type_number_t *gidsCnt;
{ return auth_server_authenticate(handle, rendezvous, newport, uids, uidsCnt, gids, gidsCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_port_t newport,
	idarray_t *uids,
	mach_msg_type_number_t *uidsCnt,
	idarray_t *gids,
	mach_msg_type_number_t *gidsCnt
);
#else
    ();
#endif
#endif

#endif	_auth_user_
