/* Structures and information for terminal driver
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

/* Here is where we store stuff for terminals which aren't part of the
   filesystem.  */
struct fakenode
{
  uid_t owner;
  uid_t group;
  mode_t mode;
  uid_t author;
  time_value_t atime;
  time_value_t ctime;
  time_value_t mtime;
};
/* Our file ID */
fsid_t fsid;
ino_t fileid;

/* Terminal state */
struct termios termstate;
pid_t owner;
int modem_state;		/* for inline terminals */
int inline;			/* true if bottom half is hurd IO */
int exclusive;			/* not implemented fully */

/* Lower half */
device_t termdev;

/* Internal state: */
int intstate;
#define OSTOPPED	0x00000001 /* output stopped */
#define ISLASH		0x00000002 /* last char was \ */
#define ILNEXT		0x00000004 /* last char was VLNEXT */
#define IHDERASE	0x00000008 /* inside slash pair for hardcopy erase */
int owner;			/* owning pgrp */
mach_port_t cttyid;		/* ctty id for proc server sessions */

/* Per-port information */
struct termuser
{
  int openmode;
};

/* I/O queues */

#define QUEUE_SIZE 512

char lineq[QUEUE_SIZE];
char readq[QUEUE_SIZE];

char outq[QUEUE_SIZE];

char *lineqp;
char *readqp;			/* only used in ICANON mode */
char *outqp;

int inputpsize;		/* number of input characters appear in phys line */
int outputpsize;	/* cursor position */

/* Request queues */
/* User side: */
struct user_request
{
  struct user_request *next;
  struct termuser *term;
  mach_port_t reply_port;
  int isctty;
  int pid;
  int pgrp;
  char *buffer;
  char *bp;
  int nbytes;
};

struct user_request *ureads, *uwrites;



    
