/* Process server definitions
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

mach_port_t master_host_port;
mach_port_t master_device_port;

struct proc
{
  /* List of members of a process group */
  struct proc *p_gnext, **p_gprevp; /* process group */

  /* Hash table pointers that point here */
  struct proc **p_pidhashloc;	/* by pid */
  struct proc **p_taskhashloc;	/* by task port */

  /* Identification of this process */
  task_t p_task;
  pid_t p_pid;
  struct login *p_login;
  uid_t p_owner;
  struct idblock p_idblock;
  
  /* Process hierarchy */
  struct proc *p_parent;	/* parent process */
  struct proc *p_ochild;	/* youngest child */
  struct proc *p_sib, **p_prevsib; /* next youngest sibling */

  /* Process group structure */
  struct pgrp *p_pgrp;
  
  /* Communication */
  mach_port_t p_reqport;	/* receive right */
  mach_port_t p_msgport;	/* send right */

  /* proc_wait () continuation for parent */
  struct wait_continuation
    {
      mach_port_t pw_reply_port;
      mach_msg_type_name_t pw_reply_port_type;
      pid_t pw_pid;
      int pw_options;
    } p_wc;

  /* Miscellaneous information */
  int p_argv, p_envp;
  int p_status;			/* to return via wait */

  int p_exec:1;			/* has called proc_mark_exec */
  int p_stopped:1;		/* has called proc_mark_stop */
  int p_waited:1;		/* stop has been reported to parent */
  int p_exiting:1;		/* has called proc_mark_exit */
  int p_exited:1;		/* task has terminated */
  int p_waiting:1;		/* blocked in wait */
  int p_traced:1;		/* has called proc_mark_traced */
  int p_nostopcld:1;		/* has called proc_mark_nostopchild */
  int p_parentset:1;		/* has had a parent set with proc_child */
  int p_reassigned:1;		/* ignore requests, doesn't really exist. */
}
typedef struct proc *pstruct_t;

struct pgrp
{
  void **pg_hashloc;
  struct proc *pg_plist;	/* member processes */
  mach_port_t pg_fakecoll;	/* receive right */
  pid_t pg_pgid;
  struct session *pg_session;
  int pg_orphcnt;		/* number of non-orphaned processes */
};

struct session
{
  struct proc *s_leader;
  mach_port_t s_fakecoll;	/* receive right */
  mach_port_t s_sessionid;	/* receive right */
  int s_count;			/* number of member process groups */
};

struct login
{
  int l_refcnt;
  char l_name[0];
};

struct htable
{
  void **tab;
  int *ids;
  int size;
}
#define HASH_DEL ((void *) -1)

/* Global variables */
struct htable pghash, pidhash, taskhash;
