/* Resource control system calls
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

/* Missing: getrlimit, setrlimit, setrlimit_force */

/* SYSCALL: Get the current scheduling priority for a group of
   processes using proc_getpriority.  */
int
getpriority (void *ap, int *ret1, int *ret2)
{
  struct 
    {
      int which;
      int who;
    }
  *args = ap;

  return h2ae (proc_getpriority (procserver, args->which, args->who, &ret1));
}

/* SYSCALL: Set the current scheduling priority for a group of
   processes using proc_setpriority.  */
int
setpriority (void *ap, int *ret1, int *ret2)
{
  struct
    {
      int which;
      int who;
      int pri;
    }
  *args = ap;

  return h2ae (proc_setpriority (procserver, args->which, args->who, 
				 args->pri));
}

/* SYSCALL: Get resource usage for the process or all its exited
   children using proc_getrusage.  */
int
getrusage (void *ap, int *ret1, int *ret2)
{
  struct
    {
      int who;
      struct rusage *rup;
    }
  *args = ap;
  struct rusage ru;

  err = h2ae (proc_getrusage (procserver, args->pid, args->who, &ru));
  if (!err)
    err = copyout (&ru, args->rup, sizeof (struct rusage));
  return err;
}
