#ifndef LINUX_JOYSTICK_H
#define LINUX_JOYSTICK_H

#define JS_DEF_TIMEOUT	5000 	/* default timeout value for js_read () */
#define JS_DEF_CORR	0	/* default correction factor */
#define JS_DEF_TIMELIMIT 10L	/* default data valid time =10jiffies =100ms */

#define JS_SET_CAL	0x01	/* ioctl to set joystick correction factor */
#define JS_GET_CAL	0x02	/* ioctl to get joystick correction factor */
#define JS_SET_TIMEOUT	0x03	/* ioctl to set maximum number of iterations */
				/* to wait for a timeout*/
#define JS_GET_TIMEOUT	0x04	/* as above, to get */
#define JS_SET_TIMELIMIT 0x05	/* set data retention time */
#define JS_GET_TIMELIMIT 0x06	/* get data retention time */

/* This union is used for the ioctl to set the scaling factor and to return
 * the current values for a joystick. 'buttons' is ignored on the ioctl call
*/
struct JS_DATA_TYPE {
	int buttons;
	int x;
	int y;
};
#define JS_RETURN	sizeof (struct JS_DATA_TYPE)

/* This union is used for the long reads.
*/
struct JS_DATA_TYPE_LONG {
	int buttons;
	int x;
	int y;
	int x2;
	int y2;
};
#define JS_RETURN_LONG	sizeof (struct JS_DATA_TYPE_LONG)

#ifdef __KERNEL__

#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/major.h>
#include <linux/module.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>

#define JS_MAJOR	15	/* major device number for joysticks */
#define JS_TRUE		1		
#define JS_FALSE	0
#define JS_PORT		0x201	/* io port for joystick operations */

#define JS_X_0		0x01	/* bit mask for x-axis js0 */
#define JS_Y_0		0x02	/* bit mask for y-axis js0 */
#define JS_0		(JS_X_0 | JS_Y_0)
#define JS_X_1		0x04	/* bit mask for x-axis js1 */
#define JS_Y_1		0x08	/* bit mask for y-axis js1 */
#define JS_1		(JS_X_1 | JS_Y_1)
#define JS_ALL		(JS_0 | JS_1)

#define JS_MAX		2	/* Max number of joysticks */

#define PIT_MODE	0x43	/* io port for timer 0 */
#define PIT_COUNTER_0	0x40	/* io port for timer 0 */

/* This struct is used for misc data about the joystick.
*/
struct JS_DATA_SAVE_TYPE {
	int	timeout;	/* max timer counts for joystick port read */
	int	busy;		/* joystick is in use */
	long	expiretime;	/* Time after which stick must be re-read (jf) */
	long	timelimit;	/* Min time before re-reads (jf) */
	int	buttons;
	int	x;
	int	y;
	struct JS_DATA_TYPE corr;		/* correction factor */
};

#define LATCH		(1193180L/HZ)		/* timer 0 period */
#define DELTA_TIME(X,Y) ((X) - (Y) + ((X) >= (Y) ? 0 : LATCH))
#define CURRENT_JIFFIES	(jiffies /*+ jiffies_offset*/)

extern long js_init (long mem_start);

#endif /* ifdef __KERNEL__ */

#endif /* ifndef LINUX_JOYSTICK_H */
