# How to contribute

We'd love to accept your patches and contributions to this project. There are a
just a few small guidelines you need to follow.

## Contributor License Agreement

Contributions to any Google project must be accompanied by a Contributor License
Agreement. This is not a copyright **assignment**, it simply gives Google
permission to use and redistribute your contributions as part of the project.

When submitting a pull request, if you have not already signed the
[Contributor License Agreement (CLA)][CLA], then a bot will remind you.
Code cannot even be evaluated without this step.

## Submitting a patch

1.  It's generally best to start by opening a new issue describing the bug or
    feature you're intending to fix. Even if you think it's relatively minor,
    it's helpful to know what people are working on. Mention in the initial
    issue that you are planning to work on that bug or feature so that it can be
    assigned to you.

2.  Follow the normal process of [forking] the project, and setup a new branch
    to work in. It's important that each group of changes be done in separate
    branches in order to ensure that a pull request only includes the commits
    related to that bug or feature.

3.  Any significant changes should almost always be accompanied by tests. The
    project already has good test coverage, so look at some of the existing
    tests if you're unsure how to go about it.

4.  All contributions must be licensed Apache 2.0 and all files must have a copy
    of the boilerplate licence comment (can be copied from an existing file).
    Files should be formatted according to Google's [java style guide].

5.  Do your best to have [well-formed commit messages] for each change. This
    provides consistency throughout the project, and ensures that commit
    messages are able to be formatted properly by various git tools.

6.  Finally, push the commits to your fork and submit a [pull request].

[CLA]: https://cla.developers.google.com
[forking]: https://help.github.com/articles/fork-a-repo
[java style guide]: https://google.github.io/styleguide/javaguide.html
[well-formed commit messages]: http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html
[pull request]: https://help.github.com/articles/creating-a-pull-request
