# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.utils import ClientMixinABC
from ...operations._storage_cache_management_client_operations import (
    build_check_aml_fs_subnets_request,
    build_get_required_aml_fs_subnets_size_request,
)
from .._configuration import StorageCacheManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _StorageCacheManagementClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], StorageCacheManagementClientConfiguration]
):

    @overload
    async def check_aml_fs_subnets(
        self,
        aml_filesystem_subnet_info: Optional[_models.AmlFilesystemSubnetInfo] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Check that subnets will be valid for AML file system create calls.

        :param aml_filesystem_subnet_info: Information about the subnets to validate. Default value is
         None.
        :type aml_filesystem_subnet_info: ~azure.mgmt.storagecache.models.AmlFilesystemSubnetInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_aml_fs_subnets(
        self,
        aml_filesystem_subnet_info: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Check that subnets will be valid for AML file system create calls.

        :param aml_filesystem_subnet_info: Information about the subnets to validate. Default value is
         None.
        :type aml_filesystem_subnet_info: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_aml_fs_subnets(
        self,
        aml_filesystem_subnet_info: Optional[Union[_models.AmlFilesystemSubnetInfo, IO[bytes]]] = None,
        **kwargs: Any
    ) -> None:
        """Check that subnets will be valid for AML file system create calls.

        :param aml_filesystem_subnet_info: Information about the subnets to validate. Is either a
         AmlFilesystemSubnetInfo type or a IO[bytes] type. Default value is None.
        :type aml_filesystem_subnet_info: ~azure.mgmt.storagecache.models.AmlFilesystemSubnetInfo or
         IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if aml_filesystem_subnet_info else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if aml_filesystem_subnet_info else None
        _json = None
        _content = None
        if isinstance(aml_filesystem_subnet_info, (IOBase, bytes)):
            _content = aml_filesystem_subnet_info
        else:
            if aml_filesystem_subnet_info is not None:
                _json = self._serialize.body(aml_filesystem_subnet_info, "AmlFilesystemSubnetInfo")
            else:
                _json = None

        _request = build_check_aml_fs_subnets_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = None
            if response.status_code == 400:
                error = self._deserialize.failsafe_deserialize(_models.AmlFilesystemCheckSubnetError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def get_required_aml_fs_subnets_size(
        self,
        required_aml_filesystem_subnets_size_info: Optional[_models.RequiredAmlFilesystemSubnetsSizeInfo] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RequiredAmlFilesystemSubnetsSize:
        """Get the number of available IP addresses needed for the AML file system information provided.

        :param required_aml_filesystem_subnets_size_info: Information to determine the number of
         available IPs a subnet will need to host the AML file system. Default value is None.
        :type required_aml_filesystem_subnets_size_info:
         ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSizeInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RequiredAmlFilesystemSubnetsSize or the result of cls(response)
        :rtype: ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSize
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_required_aml_fs_subnets_size(
        self,
        required_aml_filesystem_subnets_size_info: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RequiredAmlFilesystemSubnetsSize:
        """Get the number of available IP addresses needed for the AML file system information provided.

        :param required_aml_filesystem_subnets_size_info: Information to determine the number of
         available IPs a subnet will need to host the AML file system. Default value is None.
        :type required_aml_filesystem_subnets_size_info: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RequiredAmlFilesystemSubnetsSize or the result of cls(response)
        :rtype: ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSize
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_required_aml_fs_subnets_size(
        self,
        required_aml_filesystem_subnets_size_info: Optional[
            Union[_models.RequiredAmlFilesystemSubnetsSizeInfo, IO[bytes]]
        ] = None,
        **kwargs: Any
    ) -> _models.RequiredAmlFilesystemSubnetsSize:
        """Get the number of available IP addresses needed for the AML file system information provided.

        :param required_aml_filesystem_subnets_size_info: Information to determine the number of
         available IPs a subnet will need to host the AML file system. Is either a
         RequiredAmlFilesystemSubnetsSizeInfo type or a IO[bytes] type. Default value is None.
        :type required_aml_filesystem_subnets_size_info:
         ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSizeInfo or IO[bytes]
        :return: RequiredAmlFilesystemSubnetsSize or the result of cls(response)
        :rtype: ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSize
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if required_aml_filesystem_subnets_size_info else None
        cls: ClsType[_models.RequiredAmlFilesystemSubnetsSize] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if required_aml_filesystem_subnets_size_info else None
        _json = None
        _content = None
        if isinstance(required_aml_filesystem_subnets_size_info, (IOBase, bytes)):
            _content = required_aml_filesystem_subnets_size_info
        else:
            if required_aml_filesystem_subnets_size_info is not None:
                _json = self._serialize.body(
                    required_aml_filesystem_subnets_size_info, "RequiredAmlFilesystemSubnetsSizeInfo"
                )
            else:
                _json = None

        _request = build_get_required_aml_fs_subnets_size_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RequiredAmlFilesystemSubnetsSize", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
