# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._quota_by_period_keys_operations import build_get_request, build_update_request
from .._vendor import ApiManagementClientMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class QuotaByPeriodKeysOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.apimanagement.aio.ApiManagementClient`'s
        :attr:`quota_by_period_keys` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, service_name: str, quota_counter_key: str, quota_period_key: str, **kwargs: Any
    ) -> _models.QuotaCounterContract:
        """Gets the value of the quota counter associated with the counter-key in the policy for the
        specific period in service instance.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param quota_counter_key: Quota counter key identifier.This is the result of expression defined
         in counter-key attribute of the quota-by-key policy.For Example, if you specify
         counter-key="boo" in the policy, then it’s accessible by "boo" counter key. But if it’s defined
         as counter-key="@("b"+"a")" then it will be accessible by "ba" key. Required.
        :type quota_counter_key: str
        :param quota_period_key: Quota period key identifier. Required.
        :type quota_period_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QuotaCounterContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.QuotaCounterContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-08-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.QuotaCounterContract]

        request = build_get_request(
            resource_group_name=resource_group_name,
            service_name=service_name,
            quota_counter_key=quota_counter_key,
            quota_period_key=quota_period_key,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("QuotaCounterContract", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/periods/{quotaPeriodKey}"}  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        service_name: str,
        quota_counter_key: str,
        quota_period_key: str,
        parameters: _models.QuotaCounterValueUpdateContract,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.QuotaCounterContract:
        """Updates an existing quota counter value in the specified service instance.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param quota_counter_key: Quota counter key identifier.This is the result of expression defined
         in counter-key attribute of the quota-by-key policy.For Example, if you specify
         counter-key="boo" in the policy, then it’s accessible by "boo" counter key. But if it’s defined
         as counter-key="@("b"+"a")" then it will be accessible by "ba" key. Required.
        :type quota_counter_key: str
        :param quota_period_key: Quota period key identifier. Required.
        :type quota_period_key: str
        :param parameters: The value of the Quota counter to be applied on the specified period.
         Required.
        :type parameters: ~azure.mgmt.apimanagement.models.QuotaCounterValueUpdateContract
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QuotaCounterContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.QuotaCounterContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        service_name: str,
        quota_counter_key: str,
        quota_period_key: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.QuotaCounterContract:
        """Updates an existing quota counter value in the specified service instance.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param quota_counter_key: Quota counter key identifier.This is the result of expression defined
         in counter-key attribute of the quota-by-key policy.For Example, if you specify
         counter-key="boo" in the policy, then it’s accessible by "boo" counter key. But if it’s defined
         as counter-key="@("b"+"a")" then it will be accessible by "ba" key. Required.
        :type quota_counter_key: str
        :param quota_period_key: Quota period key identifier. Required.
        :type quota_period_key: str
        :param parameters: The value of the Quota counter to be applied on the specified period.
         Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QuotaCounterContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.QuotaCounterContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        service_name: str,
        quota_counter_key: str,
        quota_period_key: str,
        parameters: Union[_models.QuotaCounterValueUpdateContract, IO],
        **kwargs: Any
    ) -> _models.QuotaCounterContract:
        """Updates an existing quota counter value in the specified service instance.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param service_name: The name of the API Management service. Required.
        :type service_name: str
        :param quota_counter_key: Quota counter key identifier.This is the result of expression defined
         in counter-key attribute of the quota-by-key policy.For Example, if you specify
         counter-key="boo" in the policy, then it’s accessible by "boo" counter key. But if it’s defined
         as counter-key="@("b"+"a")" then it will be accessible by "ba" key. Required.
        :type quota_counter_key: str
        :param quota_period_key: Quota period key identifier. Required.
        :type quota_period_key: str
        :param parameters: The value of the Quota counter to be applied on the specified period. Is
         either a model type or a IO type. Required.
        :type parameters: ~azure.mgmt.apimanagement.models.QuotaCounterValueUpdateContract or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QuotaCounterContract or the result of cls(response)
        :rtype: ~azure.mgmt.apimanagement.models.QuotaCounterContract
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-08-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.QuotaCounterContract]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "QuotaCounterValueUpdateContract")

        request = build_update_request(
            resource_group_name=resource_group_name,
            service_name=service_name,
            quota_counter_key=quota_counter_key,
            quota_period_key=quota_period_key,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("QuotaCounterContract", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/periods/{quotaPeriodKey}"}  # type: ignore
