/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import nu.xom.Element;
import nu.xom.NoSuchChildException;
import nu.xom.Node;
import nu.xom.Verifier;

public abstract class ParentNode
extends Node {
    ArrayList children;
    String actualBaseURI;

    ParentNode() {
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void insertChild(Node node, int n) {
        this._insertChild(node, n);
    }

    final void _insertChild(Node node, int n) {
        this.insertionAllowed(node, n);
        this.fastInsertChild(node, n);
    }

    void fastInsertChild(Node node, int n) {
        if (this.children == null) {
            this.children = new ArrayList(1);
        }
        this.children.add(n, node);
        node.setParent(this);
    }

    abstract void insertionAllowed(Node var1, int var2);

    public void appendChild(Node node) {
        this.insertChild(node, this.getChildCount());
    }

    public Node getChild(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        return (Node)this.children.get(n);
    }

    public int indexOf(Node node) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(node);
    }

    public Node removeChild(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        Node node = (Node)this.children.get(n);
        if (node.isElement()) {
            this.fillInBaseURI((Element)node);
        }
        this.children.remove(n);
        node.setParent(null);
        return node;
    }

    void fillInBaseURI(Element element) {
        String string = "";
        for (ParentNode parentNode = element; parentNode != null && string.equals(""); parentNode = parentNode.getParent()) {
            string = parentNode.getActualBaseURI();
        }
        element.setActualBaseURI(string);
    }

    public Node removeChild(Node node) {
        if (this.children == null) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        int n = this.children.indexOf(node);
        if (n == -1) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        if (node.isElement()) {
            this.fillInBaseURI((Element)node);
        }
        this.children.remove(n);
        node.setParent(null);
        return node;
    }

    public void replaceChild(Node node, Node node2) {
        if (node == null) {
            throw new NullPointerException("Tried to replace null child");
        }
        if (node2 == null) {
            throw new NullPointerException("Tried to replace child with null");
        }
        if (this.children == null) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        int n = this.children.indexOf(node);
        if (n == -1) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        if (node == node2) {
            return;
        }
        this.insertionAllowed(node2, n);
        this.removeChild(n);
        this.insertChild(node2, n);
    }

    public abstract void setBaseURI(String var1);

    String getActualBaseURI() {
        if (this.actualBaseURI == null) {
            return "";
        }
        return this.actualBaseURI;
    }

    void setActualBaseURI(String string) {
        if (string == null) {
            string = "";
        }
        if (!"".equals(string)) {
            Verifier.checkAbsoluteURI(string);
        }
        this.actualBaseURI = string;
    }

    final String findActualBaseURI() {
        String string;
        ParentNode parentNode = this;
        while (true) {
            string = parentNode.getActualBaseURI();
            ParentNode parentNode2 = parentNode.getParent();
            if (parentNode2 == null) {
                return string;
            }
            if (!"".equals(string)) break;
            parentNode = parentNode2;
        }
        return string;
    }
}

