/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.Attribute;
import com.claritysys.jvm.classfile.AttributeHandler;
import com.claritysys.jvm.classfile.CfFieldOrMethod;
import com.claritysys.jvm.classfile.ClassFile;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpRef;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class CfField
extends CfFieldOrMethod
implements AttributeHandler {
    private CfField next;
    private CpEntry constantValue;

    public CfField(ClassFile classFile) {
        super(classFile);
    }

    public CfField getNext() {
        return this.next;
    }

    public void setNext(CfField next) {
        this.next = next;
    }

    public CpEntry getConstantValue() {
        return this.constantValue;
    }

    public void setConstantValue(CpEntry constantValue) {
        this.constantValue = constantValue;
    }

    public void read(DataInputStream dataIn) throws IOException, ClassFileFormatException {
        super.read(dataIn);
        this.setAttributes(Attribute.readTable(dataIn, this.getConstantPool(), this));
    }

    public boolean handleAttribute(DataInputStream dataIn, String name, int length) throws IOException, ClassFileFormatException {
        boolean processed = false;
        if (name.equals("Deprecated")) {
            this.setDeprecated(true);
            processed = true;
        } else if (name.equals("ConstantValue")) {
            int index = dataIn.readUnsignedShort();
            this.constantValue = this.getConstantPool().getPoolEntry(index);
            processed = true;
        } else if (name.equals("Synthetic")) {
            this.setSynthetic(true);
            processed = true;
        }
        return processed;
    }

    public void write(DataOutput dout) throws IOException {
        super.write(dout);
        int attributeCount = this.getAttributeCount();
        if (this.isSynthetic()) {
            ++attributeCount;
        }
        if (this.isDeprecated()) {
            ++attributeCount;
        }
        if (this.getConstantValue() != null) {
            ++attributeCount;
        }
        dout.writeShort(attributeCount);
        ConstantPool cp = this.getConstantPool();
        if (this.isSynthetic()) {
            Attribute.writeAttribute(dout, cp, "Synthetic", 0, 0);
        }
        if (this.isDeprecated()) {
            Attribute.writeAttribute(dout, cp, "Deprecated", 0, 0);
        }
        if (this.getConstantValue() != null) {
            Attribute.writeAttribute(dout, cp, "ConstantValue", 2, this.getConstantValue().getIndex());
        }
        Attribute.writeTable(dout, this.getAttributes());
    }

    public CpRef getRef() {
        int classCp = this.classFile.getClassIndex();
        return this.getConstantPool().addFieldRef(classCp, this.nameIndex, this.descriptorIndex);
    }
}

