/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Var;

class FileUtil {
    static final int PATH_RELATIVE = 0;
    static final int PATH_VOLUME_RELATIVE = 1;
    static final int PATH_ABSOLUTE = 2;

    private static int getWinHomePath(String string, boolean bl, StringBuffer stringBuffer) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '/') break;
            ++n;
        }
        if (n < 2) {
            stringBuffer.setLength(0);
            return 0;
        }
        int n2 = n;
        while (n < string.length()) {
            if (string.charAt(n) == '/') break;
            ++n;
        }
        if (n == n2) {
            stringBuffer.setLength(0);
            return 0;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + string.length());
        stringBuffer.append("//");
        stringBuffer.append(string.substring(n2, n));
        int n3 = n;
        while (n < string.length()) {
            if (string.charAt(n) != '/') {
                if (n == n3) {
                    stringBuffer.setLength(0);
                    return 0;
                }
                if (bl) {
                    stringBuffer.setLength(0);
                    return n2;
                }
                n2 = n++;
                while (n < string.length()) {
                    if (string.charAt(n) == '/') break;
                    ++n;
                }
                stringBuffer.append('/');
                stringBuffer.append(string.substring(n2, n));
                return n;
            }
            ++n;
        }
        stringBuffer.setLength(0);
        return 0;
    }

    private static int beginsWithLetterColon(String string) {
        if (string.length() > 1 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            int n = 2;
            while (n < string.length()) {
                if (string.charAt(n) != '/') break;
                ++n;
            }
            return n;
        }
        return 0;
    }

    private static int getWinAbsPath(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        if (string.length() < 1) {
            return 0;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + string.length());
        int n = FileUtil.beginsWithLetterColon(string);
        if (n > 0) {
            if (n > 2) {
                stringBuffer.append(string.substring(0, 3));
            } else {
                stringBuffer.append(string.substring(0, 2));
            }
            return n;
        }
        int n2 = FileUtil.getWinHomePath(string, false, stringBuffer);
        if (n2 > 0) {
            return n2;
        }
        if (string.charAt(0) == '/') {
            int n3 = 1;
            while (n3 < string.length()) {
                if (string.charAt(n3) != '/') break;
                ++n3;
            }
            stringBuffer.append("/");
            return n3;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static int getDegenerateUnixPath(String var0) {
        var1_1 = 0;
        while (var1_1 < var0.length() && var0.charAt(var1_1) == '/') {
            ++var1_1;
        }
        if (var1_1 != 0) ** GOTO lbl16
        return 0;
lbl-1000:
        // 1 sources

        {
            var2_2 = var0.substring(var1_1);
            if (var2_2.startsWith("./")) {
                var1_1 += 2;
            } else {
                if (!var2_2.startsWith("../")) break;
                var1_1 += 3;
            }
            while (var1_1 < var0.length() && var0.charAt(var1_1) == '/') {
                ++var1_1;
            }
lbl16:
            // 2 sources

            ** while (var1_1 < var0.length())
        }
lbl17:
        // 2 sources

        if (var1_1 < var0.length() && var0.charAt(var1_1) == '.') {
            ++var1_1;
        }
        if (var1_1 < var0.length() && var0.charAt(var1_1) == '.') {
            ++var1_1;
        }
        return var1_1;
    }

    static int getPathType(String string) {
        if (string.length() < 1) {
            return 0;
        }
        switch (JACL.PLATFORM) {
            case 1: {
                string = string.replace('\\', '/');
                char c = string.charAt(0);
                if (c == '~') {
                    return 2;
                }
                if (c == '/') {
                    StringBuffer stringBuffer = new StringBuffer(0);
                    if (FileUtil.getWinHomePath(string, true, stringBuffer) > 0) {
                        return 2;
                    }
                    return 1;
                }
                int n = FileUtil.beginsWithLetterColon(string);
                if (n > 0) {
                    if (n > 2) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (string.charAt(0) == '~') {
                    return 2;
                }
                switch (string.indexOf(58)) {
                    case -1: {
                        if (string.charAt(0) != '/' || FileUtil.getDegenerateUnixPath(string) >= string.length()) break;
                        return 2;
                    }
                    case 0: {
                        return 0;
                    }
                    default: {
                        return 2;
                    }
                }
                return 0;
            }
        }
        char c = string.charAt(0);
        if (c == '/' || c == '~') {
            return 2;
        }
        return 0;
    }

    static File getNewFileObj(Interp interp, String string) throws TclException {
        string = FileUtil.translateFileName(interp, string);
        switch (FileUtil.getPathType(string)) {
            case 0: {
                return new File(interp.getWorkingDir(), string);
            }
            case 1: {
                String string2 = interp.getWorkingDir().toString();
                int n = FileUtil.beginsWithLetterColon(string2);
                if (n == 0) {
                    throw new TclRuntimeError("interp working directory \"" + string2 + "\" does not start with a drive letter");
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(0, 2));
                stringBuffer.append('\\');
                int n2 = 0;
                while (n2 < string.length()) {
                    if (string.charAt(n2) != '\\') {
                        stringBuffer.append(string.substring(n2));
                        break;
                    }
                    ++n2;
                }
                string = stringBuffer.toString();
                return new File(string);
            }
            case 2: {
                return new File(string);
            }
        }
        throw new TclRuntimeError("type for fileName \"" + string + "\" not matched in case statement");
    }

    private static void appendComponent(String string, int n, int n2, StringBuffer stringBuffer) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '/') {
                while (n < n2 && string.charAt(n + 1) == '/') {
                    ++n;
                }
                if (n < n2) {
                    stringBuffer.ensureCapacity(stringBuffer.length() + 1);
                    stringBuffer.append('/');
                }
            } else {
                stringBuffer.ensureCapacity(stringBuffer.length() + 1);
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    static String joinPath(Interp var0, TclObject[] var1_1, int var2_2, int var3_3) throws TclException {
        var4_4 = new StringBuffer(10);
        switch (JACL.PLATFORM) {
            case 1: {
                var5_5 = var2_2;
                while (var5_5 < var3_3) {
                    var6_7 = var1_1[var5_5].toString().replace('\\', '/');
                    var7_10 = 0;
                    var8_13 = var6_7.length() - 1;
                    if (var6_7.length() != 0) {
                        var9_16 = new StringBuffer(0);
                        var7_10 = FileUtil.getWinAbsPath(var6_7, var9_16);
                        if (var7_10 > 0) {
                            var4_4 = var9_16;
                        } else if (var6_7.charAt(0) == '~') {
                            var4_4.setLength(0);
                        } else {
                            if (var4_4.length() != 0 && var6_7.regionMatches(var7_10, "./~", 0, 3)) {
                                var7_10 = 2;
                            }
                            if (var4_4.length() != 0 && (var10_19 = var4_4.charAt(var4_4.length() - 1)) != '/' && var10_19 != ':') {
                                var4_4.ensureCapacity(var4_4.length() + 1);
                                var4_4.append('/');
                            }
                        }
                        FileUtil.appendComponent(var6_7, var7_10, var8_13, var4_4);
                        var7_10 = var6_7.length();
                    }
                    ++var5_5;
                }
                return var4_4.toString();
            }
            case 2: {
                var5_6 = true;
                var6_8 = var2_2;
                while (var6_8 < var3_3) {
                    var7_11 = TclList.getElements(var0, FileUtil.splitPath(var0, var1_1[var6_8].toString()));
                    if (var7_11.length == 0) ** GOTO lbl64
                    var8_14 = 0;
                    var9_17 = var7_11[0].toString();
                    if (var9_17.charAt(0) != ':' && var9_17.indexOf(58) != -1) {
                        var4_4.setLength(0);
                        var4_4.append(var9_17);
                        var5_6 = false;
                    }
                    var10_20 = ++var8_14;
                    while (var10_20 < var7_11.length) {
                        var9_17 = var7_11[var10_20].toString();
                        if (!var9_17.equals(":")) ** GOTO lbl49
                        if (var4_4.length() != 0) ** GOTO lbl62
                        var5_6 = false;
                        ** GOTO lbl60
lbl49:
                        // 1 sources

                        var11_21 = 111;
                        if (var9_17.length() > 1) {
                            var11_21 = var9_17.charAt(1);
                        }
                        if (var9_17.charAt(0) == ':') {
                            if (!var5_6) {
                                var9_17 = var9_17.substring(1);
                            }
                        } else if (var5_6) {
                            var4_4.append(':');
                        }
                        var5_6 = var11_21 != 58;
lbl60:
                        // 2 sources

                        var4_4.append(var9_17);
lbl62:
                        // 2 sources

                        ++var10_20;
                    }
lbl64:
                    // 2 sources

                    ++var6_8;
                }
                return var4_4.toString();
            }
        }
        var6_9 = var2_2;
        while (var6_9 < var3_3) {
            var7_12 = var1_1[var6_9].toString();
            var8_15 = 0;
            var9_18 = var7_12.length() - 1;
            if (var7_12.length() != 0) {
                if (var7_12.charAt(var8_15) == '/') {
                    while (var8_15 <= var9_18 && var7_12.charAt(var8_15) == '/') {
                        ++var8_15;
                    }
                    var4_4.setLength(0);
                    var4_4.append('/');
                } else if (var7_12.charAt(var8_15) == '~') {
                    var4_4.setLength(0);
                } else {
                    if (var4_4.length() != 0 && var7_12.regionMatches(var8_15, "./~", 0, 3)) {
                        var8_15 += 2;
                    }
                    if (var4_4.length() != 0 && var4_4.charAt(var4_4.length() - 1) != '/') {
                        var4_4.ensureCapacity(var4_4.length() + 1);
                        var4_4.append('/');
                    }
                }
                FileUtil.appendComponent(var7_12, var8_15, var9_18, var4_4);
                var8_15 = var7_12.length();
            }
            ++var6_9;
        }
        return var4_4.toString();
    }

    static TclObject splitPath(Interp interp, String string) throws TclException {
        TclObject tclObject;
        String string2;
        TclObject tclObject2 = TclList.newInstance();
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string4 = "./";
        if (string.length() == 0) {
            return tclObject2;
        }
        block0 : switch (JACL.PLATFORM) {
            case 1: {
                string2 = string.replace('\\', '/');
                StringBuffer stringBuffer = new StringBuffer(0);
                int n = FileUtil.getWinAbsPath(string2, stringBuffer);
                if (n <= 0) break;
                tclObject = TclString.newInstance((String)stringBuffer.toString());
                TclList.append(interp, tclObject2, tclObject);
                string2 = string2.substring(n);
                bl = true;
                break;
            }
            case 2: {
                string2 = "";
                string4 = ":";
                switch (string.indexOf(58)) {
                    case -1: {
                        if (string.charAt(0) != '/') {
                            string2 = string;
                            bl2 = true;
                            if (string.charAt(0) != '~') break block0;
                            bl4 = true;
                            break;
                        }
                        int n = FileUtil.getDegenerateUnixPath(string);
                        if (n < string.length()) {
                            string2 = string.substring(n);
                            bl2 = true;
                            bl4 = true;
                            break;
                        }
                        TclObject tclObject3 = TclString.newInstance((String)(":" + string));
                        TclList.append(interp, tclObject2, tclObject3);
                        return tclObject2;
                    }
                    case 0: {
                        if (string.length() == 1) {
                            TclObject tclObject4 = TclString.newInstance((String)":");
                            TclList.append(interp, tclObject2, tclObject4);
                            return tclObject2;
                        }
                        string2 = string.substring(1);
                        bl = true;
                        bl5 = true;
                        bl3 = true;
                        break;
                    }
                    default: {
                        string2 = string;
                        bl4 = true;
                        bl5 = true;
                        bl3 = true;
                        break;
                    }
                }
                break;
            }
            default: {
                if (string.charAt(0) == '/') {
                    tclObject = TclString.newInstance((String)"/");
                    TclList.append(interp, tclObject2, tclObject);
                    string2 = string.substring(1);
                    bl = true;
                    break;
                }
                string2 = string;
            }
        }
        int n = 0;
        while (n != -1) {
            if (bl3) {
                n = string2.indexOf(":");
                if (n == 0) {
                    tclObject = TclString.newInstance((String)"::");
                    TclList.append(interp, tclObject2, tclObject);
                    bl = true;
                    string2 = string2.substring(n + 1);
                    continue;
                }
            } else {
                n = string2.indexOf("/");
                if (n == 0) {
                    string2 = string2.substring(n + 1);
                    continue;
                }
            }
            if (n == -1) {
                if (string2.length() == 0) break;
                string3 = string2;
            } else {
                string3 = string2.substring(0, n);
            }
            if (bl2 && (string3.equals(".") || string3.equals(".."))) {
                string3 = string3.replace('.', ':');
            }
            if (bl) {
                if (string3.charAt(0) == '~') {
                    string3 = String.valueOf(string4) + string3;
                } else if (bl5) {
                    if (string2.indexOf(47) == -1) {
                        bl5 = false;
                    } else {
                        string3 = ":" + string3;
                    }
                }
            } else if (bl4) {
                string3 = String.valueOf(string3) + ":";
            }
            tclObject = TclString.newInstance((String)string3);
            TclList.append(interp, tclObject2, tclObject);
            bl = true;
            string2 = string2.substring(n + 1);
        }
        return tclObject2;
    }

    static String doTildeSubst(Interp interp, String string) throws TclException {
        if (string.length() == 0) {
            String string2;
            try {
                string2 = Var.getVar(interp, "env", "HOME", 512).toString();
            }
            catch (Exception exception) {
                throw new TclException(interp, "couldn't find HOME environment variable to expand path");
            }
            return string2;
        }
        String string3 = null;
        if (string3 == null) {
            throw new TclException(interp, "user \"" + string + "\" doesn't exist");
        }
        return string3;
    }

    static String translateFileName(Interp interp, String string) throws TclException {
        String string2 = "";
        if (string.length() == 0 || string.charAt(0) != '~') {
            TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance((String)string)};
            string2 = FileUtil.joinPath(interp, tclObjectArray, 0, 1);
        } else {
            TclObject[] tclObjectArray = TclList.getElements(interp, FileUtil.splitPath(interp, string));
            String string3 = tclObjectArray[0].toString().substring(1);
            if (JACL.PLATFORM == 2 && string3.endsWith(":")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = FileUtil.doTildeSubst(interp, string3);
            tclObjectArray[0] = TclString.newInstance((String)string3);
            string2 = FileUtil.joinPath(interp, tclObjectArray, 0, tclObjectArray.length);
        }
        if (JACL.PLATFORM == 1) {
            string2 = string2.replace('/', '\\');
        }
        return string2;
    }

    static TclObject splitAndTranslate(Interp interp, String string) throws TclException {
        String string2;
        TclObject tclObject = FileUtil.splitPath(interp, string);
        int n = TclList.getLength(interp, tclObject);
        if (n == 1 && (string2 = TclList.index(interp, tclObject, 0).toString()).charAt(0) == '~') {
            String string3 = FileUtil.translateFileName(interp, string2);
            tclObject = FileUtil.splitPath(interp, string3);
        }
        return tclObject;
    }

    FileUtil() {
    }
}

