/*
 * fs.h --
 *
 *	This file is a much-condensed version of Sprite's fs.h,
 *	containing just enough stuff to use the fsDispatch facilities.
 *
 * Copyright 1990 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * $Header: /sprite/src/lib/mx/RCS/fs.unix,v 1.1 90/01/29 14:05:11 ouster Exp $ SPRITE (Berkeley)
 */

#ifndef _FSUSER
#define _FSUSER

#ifndef _CLIENTDATA
typedef int *ClientData;
#define _CLIENTDATA
#endif

/*
 * Flags for Fs_Select:
 *
 *	FS_READABLE	- Does the stream have data that can be read?
 *	FS_WRITABLE	- Can data be written to the stream?
 *	FS_EXCEPTION	- Are there any exception conditions that have
 *			  raised for the stream? (e.g. out-of-band data).
 */

#define FS_READ		  		0x001
#define FS_WRITE	  		0x002
#define FS_EXECUTE	  		0x004
#define FS_READABLE	FS_READ
#define FS_WRITABLE	FS_WRITE
#define FS_EXCEPTION	FS_EXECUTE
#define FS_EXCEPTABLE	FS_EXCEPTION

/*
 * Definitions for the FS dispatcher library.
 */
typedef ClientData Fs_TimeoutHandler;

extern void		Fs_Dispatch();
extern void		Fs_EventHandlerCreate();
extern void 		Fs_EventHandlerDestroy();
extern ClientData 	Fs_EventHandlerData();
extern ClientData 	Fs_EventHandlerChangeData();
extern Fs_TimeoutHandler Fs_TimeoutHandlerCreate();
extern void 		Fs_TimeoutHandlerDestroy();

#endif /* _FSUSER */
