.TH TKPOSTAGE 1 "Tcl/Tk" "TkPostage 1.1"
.SH NAME
tkpostage - fancy mailbox message counter (like xbiff)
.SH SYNOPSIS
.B tkpostage
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
.I tkpostage
is a replacement for
.I xbiff
and similar programs.  It shows a picture similar to a U.S.A. metered stamp
with a count of how many messages are in your mail spool.  Clicking on
this window will bring up a window with one line per mail message, containing
the subject and author.
.SH OPTIONS
.I tkpostage
accepts all of the standard Tk Toolkit command line options along with the
additional options listed below:
.TP 8
.B \-help
This option gives the usual \fIwish\fP help summary which isn't really what you want.
To get detailed help on \fItkpostage\fP, use some other unused option, like \-foo.
This message is printed to standard error.
.TP 8
.B \-delay \fIseconds\fP
This option specifies the frequency in seconds at which \fItkpostage\fP
should check if you have new mail.
The default is 2 seconds.
.TP 8
.B \-mailDrop \fIfilename\fP
This option specifies the name of the file which should be monitored.  By
default, it watches /usr/spool/mail/\fIusername\fP, where \fIusername\fP
is your login name, or /usr/mail/\fIusername\fP if it can't find that.
\fItkpostage\fP will also try your MAILDROP environment variable, if set.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the foreground color of the postage window.  The
color is specified in the usual X syntax.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the background color of the postage window.
.TP 8
.B \-beep
This option tells \fItkpostage\fP to beep when new mail arrives.  Normally,
it's quiet.  This is currently a hack which sends a \fIcontrol-G\fP to 
standard output.  Ousterhout says this will be fixed in Tk4.0, and it
is also fairly easy to add a command to call \fIXBell\fP into your \fIwish\fP.
Since generic \fIwish\fP interpreters don't support \fIXBell\fP, \fItkpostage\fP
doesn't either.
.TP 8
.B \-paranoid
This option tells \fItkpostage\fP to watch the file access time on the mail
spool, which it normally ignores.  For most people, this is unnecessary,
but if you think \fItkpostage\fP isn't rescanning when things change, try
this flag out.  If you're running more than one copy of \fItkpostage\fP
or other application which accesses your mail spool, and you use the
\fB-paranoid\fP option, you may notice a substantial slowdown, or a beep
every so many seconds.  This isn't so much a bug as a problem with checking
the file access times.
.PP
The following options are intended more for the tinkerer than for general
usage.  They're included for completeness:
.TP 8
.B \-bitmap \fIbitmap-file\fP
This option specifies the path a different bitmap, if you don't want to use
the usual postage meter.
.TP 8
.B \-numberFont \fIfont-specification\fP
This option specifies the font to use for the counter.
.TP 8
.B \-numberAnchor \fIanchor-direction\fP
This option specifies the corner from which the following offsets are relative.
\fIanchor-direction\fP may be one of \fIc, sw, s, se, e, ne, n,
nw,\fP or \fIw\fP.
.TP 8
.B \-numberXOffset \fIinteger\fP
This option specifies the x-offset of the counter in the bitmap, relative
to the anchor.
.TP 8
.B \-numberYOffset \fIinteger\fP
This option specifies the y-offset of the counter in the bitmap, relative
to the anchor.
.TP 8
.B \-detailFont \fIfont-specification\fP
This option specifies the font to use for the message details window.
.TP 8
.B \-postageGeometry \fIgeometry-spec\fP
This option specifies the geometry of the main postage window.
.TP 8
.B \-detailGeometry \fIgeometry-spec\fP
This option specifies the geometry of the message details window.  The
width and height are specified as numbers of characters rather than pixels,
in the same way as \fIxterm\fP's geometry specification.
.SH X DEFAULTS
Due to some relatively obscure bugs in Tk3.3, I can't make
the class name be \fITkPostage\fP while keeping all the options working.  So,
you'll have to use resources like "tkpostage.delay: 5" rather than 
"TkPostage.delay: 5".  For convincing your window manager what borders
you want on your window, \fItkpostage\fP refers to the postage window, and
\fITkPostageDetails\fP refers to the message details window.  Things should
improve with the next release of Tk.
.PP
.I tkpostage
understands all of the core resource names and classes that Tk supports
as well a resource corresponding to all of the above flags.
.PP
.ta 3i
.nf
\fIX Resource	Command Line Option\fP

paranoid	-paranoid
beep	-beep
bitmap	-bitmap
delay	-delay
mailDrop	-mailDrop
foreground	-fg (or) -foreground
background	-bg (or) -background
numberXOffset	-numberXOffset
numberYOffset	-numberYOffset
numberAnchor	-numberAnchor
numberFont	-numberFont
detailFont	-detailFont
postageGeometry	-postageGeometry
detailGeometry	-detailGeometry
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B MAILDROP
if set, this overrides the usual checks of /usr/spool/mail/\fIusername\fP
and /usr/mail/\fIusername\fP.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1),
xterm(1),
xbiff(1),
wish(1),
Tcl(n),
xrdb(1),
stat(2)
.SH BUGS
Sure would be nice to have both windows with class TkPostage and have
the "option get" calls work, properly.  As soon as Tk4.0 is released,
or possibly the next release after Tk3.3, this bug will be fixable.
.SH AUTHOR
Copyright 1993, Dan Wallach <dwallach@cs.princeton.edu>
.SH INSPIRATION
\fIxpostage\fP, by Cliff Herod, Convex Computer Corp, 1989.
.br
128x64 bitmap image (Postage.xbm) used with permission.
