'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) spintime.n
'\"
.so man.macros
.HS spintime iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
spintime \- Create and manipulate time spinner widgets
.SH SYNOPSIS
\fBspintime\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Spintime

.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR	\fBhighlightColor\fR
\fBhighlightThickness\fR	\fBrelief\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "entryfield" manual entry for details on the above associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR	\fBlabelMargin\fR
.fi
.LP
See the "labeledwidget" manual entry for details on the above associated 
options.
.LP
.nf
.ta 4c 8c 12c
\fBstep\fR
.fi
.LP
See the "spinint" manual entry for details on the above associated options.
.LP
.nf
.ta 4c 8c 12c
\fBarrowOrient\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR
.fi
.LP
See the "spinner" manual entry for details on the above associated options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBlabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-labelpos\fR
.fi
.IP
Specifies the position of the label along the sides of the various 
spinners: \fBn\fR, \fBe\fR, \fBs\fR, or \fBw\fR.  The default is w.
.LP
.nf
Name:	\fBhourLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-hourlabel\fR
.fi
.IP
Specifies the text of the label for the hour spinner.  The default is "Hour".
.LP
.nf
Name:	\fBhourOn\fR
Class:	\fBhourOn\fR
Command-Line Switch:	\fB-houron\fR
.fi
.IP
Specifies whether or not to display the hour spinner in any of the forms
acceptable to \fBTcl_GetBoolean\fR.  The default is true.
.LP
.nf
Name:	\fBhourWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-hourwidth\fR
.fi
.IP
Specifies the width of the hour spinner in any of the forms acceptable to
\fBTcl_GetPixels\fR.  The default is 3 pixels.
.LP
.nf
Name:	\fBmilitaryOn\fR
Class:	\fBmilitaryOn\fR
Command-Line Switch:	\fB-militaryon\fR
.fi
.IP
Specifies use of a 24 hour clock for hour display in any of the forms 
acceptable to \fBTcl_GetBoolean\fR.  The default is true.
.LP
.nf
Name:	\fBminuteLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-minutelabel\fR
.fi
.IP
Specifies the text of the label for the minute spinner.  The default is
"Minute".
.LP
.nf
Name:	\fBminuteOn\fR
Class:	\fBminuteOn\fR
Command-Line Switch:	\fB-minuteon\fR
.fi
.IP
Specifies whether or not to display the minute spinner in any of the forms
acceptable to \fBTcl_GetBoolean\fR.  The default is true.
.LP
.nf
Name:	\fBminuteWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-minutewidth\fR
.fi
.IP
Specifies the width of the minute spinner in any of the forms acceptable to
\fBTcl_GetPixels\fR.  The default is 3 pixels.
.LP
.nf
Name:	\fBorient\fR
Class:	\fBOrient\fR
Command-Line Switch:	\fB-orient\fR
.fi
.IP
Specifies the orientation of the hour, minute, and second spinners: \fBvertical\fR or \fBhorizontal\fR.  The default is horizontal.
.LP
.nf
Name:	\fBsecondLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-secondlabel\fR
.fi
.IP
Specifies the text of the label for the second spinner.  The default is
"Second"
.LP
.nf
Name:	\fBsecondOn\fR
Class:	\fBsecondOn\fR
Command-Line Switch:	\fB-secondon\fR
.fi
.IP
Specifies whether or not to display the second spinner in any of the forms
acceptable to \fBTcl_GetBoolean\fR.  The default is true.
.LP
.nf
Name:	\fBsecondWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-secondwidth\fR
.fi
.IP
Specifies the width of the second spinner in any of the forms acceptable to
\fBTcl_GetPixels\fR.  The default is 3 pixels.
.LP
.nf
Name:	\fBtimeMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-timemargin\fR
.fi
.IP
Specifies the margin space between the hour, minute, and second spinners is 
any of the forms accpetable to \fBTcl_GetPixels\fR.  The default is 1 pixel.
.LP
.nf
.BE

.SH DESCRIPTION
.PP

The \fBspintime\fR command creates a set of spinners for use in time value
entry.  The set includes an hour, minute, and second spinner widget.

.SH "METHODS"
.PP
The \fBspintime\fR command creates a new Tcl command whose
name is \fIpathName\fR. This
command may be used to invoke various
operations on the widget. It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following
commands are possible for spintime widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBspintime\fR
command.
.TP
\fIpathName\fR \fBclear\fR
Delete the contents of all spinner components.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBspintime\fR
command.
.TP
\fIpathName\fR \fBdelete\fR \fIcomponent\fR \fIfirst\fR ?\fIlast\fR?
Delete one or more characters of the specified \fIcomponent\fR, 
where \fIcomponent\fR can be \fBhour\fR, \fBminute\fR, or \fBsecond\fR. 
\fIFirst\fR is the index of the first character to delete, and \fIlast\fR 
is the index of the character just after the last one to delete.
.TP
\fIpathName\fR \fBget\fR \fI?component?\fR
Get returns the value for the speicifed component: \fBhour\fR, \fBminute\fR, or
\fBsecond\fR.  Without parameters the command returns the all three values as 
a list.
.TP
\fIpathName\fR \fBinsert\fR \fIcomponent\fR \fIindex\fR \fIstring\fR
Inserts the characters of \fIstring\fR just before the character indicated
by \fIindex\fR in the \fIcomponent\fR, where \fIcomponent\fR can 
be \fBhour\fR, \fBminute\fR, or \fBsecond\fR.

.ta 4c
.SH "COMPONENTS"
.LP
.nf
Name:	\fBhour\fR
Class:	\fBSpinint\fR
.fi
.IP
The hour component is the hour spinner of the time spinner.  See the 
SpinInt widget manual entry for details on the hour component item.
.LP
.nf
Name:	\fBminute\fR
Class:	\fBSpinint\fR
.fi
.IP
The minute component is the minute spinner of the time spinner.  See 
the SpinInt widget manual entry for details on the minute component item.
.LP
.nf
Name:	\fBsecond\fR
Class:	\fBSpinint\fR
.fi
.IP
The second component is the second spinner of the time spinner.  See the
SpinInt widget manual entry for details on the second component item.
.fi

.SH EXAMPLE
.DS
spintime .st
pack .st -padx 10 -pady 10
.DE
.SH AUTHOR
Sue Yockey
.DE
Mark L. Ulferts
.SH KEYWORDS
spintime, spinint, spinner, entryfield, entry, widget

