(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 10:41:17 PDT 1992 by muller                   *)
(*      modified on Mon Jun  8 11:25:23 PDT 1992 by meehan                   *)

INTERFACE RTutils;

PROCEDURE Heap (suppressZeros := FALSE);
(* This prints a table of all the known types and some simple statistics
   about them (count, total size in bytes for all such objects, average
   size).  If "suppressZeros" is true, then nothing will be printed for a
   type that has no instances in the heap.  The table is printed onto
   stderr (using SmallIO).*)

PROCEDURE NewHeap (suppressZeros := TRUE);
(* This prints only the incremental information since the last call to
    Heap or NewHeap. *)
    
PROCEDURE TypeName (ref: REFANY): TEXT;
(* = TypecodeName (TYPECODE (ref)) *)

PROCEDURE TypecodeName (tc: CARDINAL): TEXT;
(* This returns a text describing the ref whose typecode = "tc".  Its
   heuristic is to consider, in order, "named typecells", brands, arrays,
   object-subtypes, objects, and procedures.  If all else fails, it returns
   "<?>". *)

END RTutils.
