(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: WordPlus.m3                                           *)
(* Last Modified On Tue Jun 30 09:36:03 PDT 1992 By kalsow     *)
(*      Modified On Tue Apr 10 11:16:59 1990 By muller         *)

MODULE WordPlus;

IMPORT Word, CallExpr, Expr, Type, Procedure, Emit, Temp;
IMPORT Int, IntegerExpr, Value, Formal, BuiltinArgs, ProcType;

VAR Z: CallExpr.MethodList;
VAR formals: ARRAY [0..1] OF Value.T;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  VAR cs: Expr.CheckState): Type.T =
  BEGIN
    EVAL Formal.CheckArgs (cs, args, formals);
    RETURN Int.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2, t3: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Expr.Compile (args[1]);
    t3 := Temp.AllocEmpty (Int.T);
    Emit.OpTTT ("@ = (unsigned)@ + (unsigned)@;\n", t3, t1, t2);
    Temp.Free (t1);
    Temp.Free (t2);
    RETURN t3;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR w0, w1: Word.T;
  BEGIN
    IF GetArgs (args, w0, w1) THEN
      RETURN IntegerExpr.New (Word.Plus (w0, w1));
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE GetArgs (args: Expr.List; VAR w0, w1: Word.T): BOOLEAN =
  VAR e0, e1: Expr.T;
  BEGIN
    e0 := Expr.ConstValue (args[0]);
    e1 := Expr.ConstValue (args[1]);
    RETURN (e0 # NIL) AND IntegerExpr.Split (e0, w0) AND 
	   (e1 # NIL) AND IntegerExpr.Split (e1, w1);
  END GetArgs;

PROCEDURE Initialize () =
  BEGIN
    formals[0] := BuiltinArgs.f1;
    formals[1] := BuiltinArgs.f5;
    Z := CallExpr.NewMethodList (2, 2, TRUE, TRUE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("Plus", Z, FALSE, ProcType.New (formals, Int.T));
  END Initialize;

BEGIN
END WordPlus.
