(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed May 20 16:57:19 PDT 1992 by muller                   *)

UNSAFE MODULE RTThread;

CONST 
  SP_pos = 13;
  FP_pos = 15;

PROCEDURE SP (s: State): ADDRESS =
  BEGIN
    RETURN LOOPHOLE (s [SP_pos], ADDRESS);
  END SP;

PROCEDURE FlushStackCache () =
  VAR d: State;
  BEGIN
    IF Save (d) = 0 THEN
      Restore (d, 1); END;
  END FlushStackCache;

PROCEDURE UpdateStateForNewSP (VAR s: State; offset: INTEGER) =
  BEGIN
    INC (s [SP_pos], offset);
    INC (s [FP_pos], offset);
  END UpdateStateForNewSP;

PROCEDURE UpdateFrameForNewSP (<*UNUSED*> a: ADDRESS; 
                               <*UNUSED*> offset: INTEGER) =
  BEGIN
  END UpdateFrameForNewSP;

BEGIN
END RTThread.
