(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ESet.i3                                               *)
(* Last modified on Thu Apr 30 16:12:33 PDT 1992 by kalsow     *)

INTERFACE ESet;

IMPORT M3, String, Value, Token, Type, MBuf;

TYPE
  T = M3.ExSet;

PROCEDURE ParseRaises (READONLY fail: Token.Set): T;
PROCEDURE ParseFails  (READONLY fail: Token.Set;  existing: T): T;

PROCEDURE Hash (t: T): INTEGER;
PROCEDURE Declare (t: T);
PROCEDURE UID (t: T): INTEGER;

PROCEDURE RaisesAny (t: T): BOOLEAN;
PROCEDURE RaisesNone (t: T): BOOLEAN;

PROCEDURE NewAny (): T;
PROCEDURE NewEmpty (): T;
PROCEDURE Add (t: T;  READONLY name: String.QID;   ex: Value.T);

PROCEDURE IsEqual (a, b: T): BOOLEAN;
(* TRUE iff 'a' equals 'b' *)

PROCEDURE IsSubset (a, b: T): BOOLEAN;
(* TRUE iff 'a' is a subset of 'b' *)

(* type checking *)
PROCEDURE TypeCheck (t: T);
PROCEDURE Push(VAR cs: M3.CheckState; ok_to_raise, no_error: T; stop: BOOLEAN);
PROCEDURE Pop (VAR cs: M3.CheckState; ok_to_raise, no_error: T; stop: BOOLEAN);
PROCEDURE NoteExceptions (VAR cs: M3.CheckState;  t: T);
PROCEDURE NoteException  (VAR cs: M3.CheckState;  v: Value.T);


PROCEDURE Fingerprint (t: T;  map: Type.FPMap;  wr: MBuf.T);

PROCEDURE Reset ();

END ESet.
